/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RotationSegment;

public class BannerRenderer
implements BlockEntityRenderer<BannerBlockEntity> {
    private static final int BANNER_WIDTH = 20;
    private static final int BANNER_HEIGHT = 40;
    private static final int MAX_PATTERNS = 16;
    public static final String FLAG = "flag";
    private static final String POLE = "pole";
    private static final String BAR = "bar";
    private final ModelPart flag;
    private final ModelPart pole;
    private final ModelPart bar;

    public BannerRenderer(BlockEntityRendererProvider.Context p_173521_) {
        ModelPart $$1 = p_173521_.bakeLayer(ModelLayers.BANNER);
        this.flag = $$1.getChild(FLAG);
        this.pole = $$1.getChild(POLE);
        this.bar = $$1.getChild(BAR);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition $$0 = new MeshDefinition();
        PartDefinition $$1 = $$0.getRoot();
        $$1.addOrReplaceChild(FLAG, CubeListBuilder.create().texOffs(0, 0).addBox(-10.0f, 0.0f, -2.0f, 20.0f, 40.0f, 1.0f), PartPose.ZERO);
        $$1.addOrReplaceChild(POLE, CubeListBuilder.create().texOffs(44, 0).addBox(-1.0f, -30.0f, -1.0f, 2.0f, 42.0f, 2.0f), PartPose.ZERO);
        $$1.addOrReplaceChild(BAR, CubeListBuilder.create().texOffs(0, 42).addBox(-10.0f, -32.0f, -1.0f, 20.0f, 2.0f, 2.0f), PartPose.ZERO);
        return LayerDefinition.create($$0, 64, 64);
    }

    @Override
    public void render(BannerBlockEntity p_112052_, float p_112053_, PoseStack p_112054_, MultiBufferSource p_112055_, int p_112056_, int p_112057_) {
        long $$9;
        float $$6 = 0.6666667f;
        boolean $$7 = p_112052_.getLevel() == null;
        p_112054_.pushPose();
        if ($$7) {
            long $$8 = 0L;
            p_112054_.translate(0.5f, 0.5f, 0.5f);
            this.pole.visible = true;
        } else {
            $$9 = p_112052_.getLevel().getGameTime();
            BlockState $$10 = p_112052_.getBlockState();
            if ($$10.getBlock() instanceof BannerBlock) {
                p_112054_.translate(0.5f, 0.5f, 0.5f);
                float $$11 = -RotationSegment.convertToDegrees($$10.getValue(BannerBlock.ROTATION));
                p_112054_.mulPose(Axis.YP.rotationDegrees($$11));
                this.pole.visible = true;
            } else {
                p_112054_.translate(0.5f, -0.16666667f, 0.5f);
                float $$12 = -$$10.getValue(WallBannerBlock.FACING).toYRot();
                p_112054_.mulPose(Axis.YP.rotationDegrees($$12));
                p_112054_.translate(0.0f, -0.3125f, -0.4375f);
                this.pole.visible = false;
            }
        }
        p_112054_.pushPose();
        p_112054_.scale(0.6666667f, -0.6666667f, -0.6666667f);
        VertexConsumer $$13 = ModelBakery.BANNER_BASE.buffer(p_112055_, RenderType::entitySolid);
        this.pole.render(p_112054_, $$13, p_112056_, p_112057_);
        this.bar.render(p_112054_, $$13, p_112056_, p_112057_);
        BlockPos $$14 = p_112052_.getBlockPos();
        float $$15 = ((float)Math.floorMod((long)($$14.getX() * 7 + $$14.getY() * 9 + $$14.getZ() * 13) + $$9, 100L) + p_112053_) / 100.0f;
        this.flag.xRot = (-0.0125f + 0.01f * Mth.cos((float)Math.PI * 2 * $$15)) * (float)Math.PI;
        this.flag.y = -32.0f;
        BannerRenderer.renderPatterns(p_112054_, p_112055_, p_112056_, p_112057_, this.flag, ModelBakery.BANNER_BASE, true, p_112052_.getBaseColor(), p_112052_.getPatterns());
        p_112054_.popPose();
        p_112054_.popPose();
    }

    public static void renderPatterns(PoseStack p_112066_, MultiBufferSource p_112067_, int p_112068_, int p_112069_, ModelPart p_112070_, Material p_112071_, boolean p_112072_, DyeColor p_332660_, BannerPatternLayers p_330986_) {
        BannerRenderer.renderPatterns(p_112066_, p_112067_, p_112068_, p_112069_, p_112070_, p_112071_, p_112072_, p_332660_, p_330986_, false);
    }

    public static void renderPatterns(PoseStack p_112075_, MultiBufferSource p_112076_, int p_112077_, int p_112078_, ModelPart p_112079_, Material p_112080_, boolean p_112081_, DyeColor p_332652_, BannerPatternLayers p_331851_, boolean p_332823_) {
        p_112079_.render(p_112075_, p_112080_.buffer(p_112076_, RenderType::entitySolid, p_332823_), p_112077_, p_112078_);
        BannerRenderer.renderPatternLayer(p_112075_, p_112076_, p_112077_, p_112078_, p_112079_, p_112081_ ? Sheets.BANNER_BASE : Sheets.SHIELD_BASE, p_332652_);
        for (int $$10 = 0; $$10 < 16 && $$10 < p_331851_.layers().size(); ++$$10) {
            BannerPatternLayers.Layer $$11 = p_331851_.layers().get($$10);
            Material $$12 = p_112081_ ? Sheets.getBannerMaterial($$11.pattern()) : Sheets.getShieldMaterial($$11.pattern());
            BannerRenderer.renderPatternLayer(p_112075_, p_112076_, p_112077_, p_112078_, p_112079_, $$12, $$11.color());
        }
    }

    private static void renderPatternLayer(PoseStack p_332737_, MultiBufferSource p_332758_, int p_332821_, int p_332828_, ModelPart p_332732_, Material p_332704_, DyeColor p_332728_) {
        int $$7 = p_332728_.getTextureDiffuseColor();
        p_332732_.render(p_332737_, p_332704_.buffer(p_332758_, RenderType::entityNoOutline), p_332821_, p_332828_, $$7);
    }
}

