/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ShulkerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ShulkerBoxRenderer
implements BlockEntityRenderer<ShulkerBoxBlockEntity> {
    private final ShulkerModel<?> model;

    public ShulkerBoxRenderer(BlockEntityRendererProvider.Context p_173626_) {
        this.model = new ShulkerModel(p_173626_.bakeLayer(ModelLayers.SHULKER));
    }

    @Override
    public void render(ShulkerBoxBlockEntity p_112478_, float p_112479_, PoseStack p_112480_, MultiBufferSource p_112481_, int p_112482_, int p_112483_) {
        Material $$10;
        DyeColor $$8;
        BlockState $$7;
        Direction $$6 = Direction.UP;
        if (p_112478_.hasLevel() && ($$7 = p_112478_.getLevel().getBlockState(p_112478_.getBlockPos())).getBlock() instanceof ShulkerBoxBlock) {
            $$6 = $$7.getValue(ShulkerBoxBlock.FACING);
        }
        if (($$8 = p_112478_.getColor()) == null) {
            Material $$9 = Sheets.DEFAULT_SHULKER_TEXTURE_LOCATION;
        } else {
            $$10 = Sheets.SHULKER_TEXTURE_LOCATION.get($$8.getId());
        }
        p_112480_.pushPose();
        p_112480_.translate(0.5f, 0.5f, 0.5f);
        float $$11 = 0.9995f;
        p_112480_.scale(0.9995f, 0.9995f, 0.9995f);
        p_112480_.mulPose($$6.getRotation());
        p_112480_.scale(1.0f, -1.0f, -1.0f);
        p_112480_.translate(0.0f, -1.0f, 0.0f);
        ModelPart $$12 = this.model.getLid();
        $$12.setPos(0.0f, 24.0f - p_112478_.getProgress(p_112479_) * 0.5f * 16.0f, 0.0f);
        $$12.yRot = 270.0f * p_112478_.getProgress(p_112479_) * ((float)Math.PI / 180);
        VertexConsumer $$13 = $$10.buffer(p_112481_, RenderType::entityCutoutNoCull);
        this.model.renderToBuffer(p_112480_, $$13, p_112482_, p_112483_);
        p_112480_.popPose();
    }
}

