/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class EntityRenderDispatcher
implements ResourceManagerReloadListener {
    private static final RenderType SHADOW_RENDER_TYPE = RenderType.entityShadow(ResourceLocation.withDefaultNamespace("textures/misc/shadow.png"));
    private static final float MAX_SHADOW_RADIUS = 32.0f;
    private static final float SHADOW_POWER_FALLOFF_Y = 0.5f;
    private Map<EntityType<?>, EntityRenderer<?>> renderers = ImmutableMap.of();
    private Map<PlayerSkin.Model, EntityRenderer<? extends Player>> playerRenderers = Map.of();
    public final TextureManager textureManager;
    private Level level;
    public Camera camera;
    private Quaternionf cameraOrientation;
    public Entity crosshairPickEntity;
    private final ItemRenderer itemRenderer;
    private final BlockRenderDispatcher blockRenderDispatcher;
    private final ItemInHandRenderer itemInHandRenderer;
    private final Font font;
    public final Options options;
    private final EntityModelSet entityModels;
    private boolean shouldRenderShadow = true;
    private boolean renderHitBoxes;

    public <E extends Entity> int getPackedLightCoords(E p_114395_, float p_114396_) {
        return this.getRenderer(p_114395_).getPackedLightCoords(p_114395_, p_114396_);
    }

    public EntityRenderDispatcher(Minecraft p_234579_, TextureManager p_234580_, ItemRenderer p_234581_, BlockRenderDispatcher p_234582_, Font p_234583_, Options p_234584_, EntityModelSet p_234585_) {
        this.textureManager = p_234580_;
        this.itemRenderer = p_234581_;
        this.itemInHandRenderer = new ItemInHandRenderer(p_234579_, this, p_234581_);
        this.blockRenderDispatcher = p_234582_;
        this.font = p_234583_;
        this.options = p_234584_;
        this.entityModels = p_234585_;
    }

    public <T extends Entity> EntityRenderer<? super T> getRenderer(T p_114383_) {
        if (p_114383_ instanceof AbstractClientPlayer) {
            AbstractClientPlayer $$1 = (AbstractClientPlayer)p_114383_;
            PlayerSkin.Model $$2 = $$1.getSkin().model();
            EntityRenderer<? extends Player> $$3 = this.playerRenderers.get((Object)$$2);
            if ($$3 != null) {
                return $$3;
            }
            return this.playerRenderers.get((Object)PlayerSkin.Model.WIDE);
        }
        return this.renderers.get(p_114383_.getType());
    }

    public void prepare(Level p_114409_, Camera p_114410_, Entity p_114411_) {
        this.level = p_114409_;
        this.camera = p_114410_;
        this.cameraOrientation = p_114410_.rotation();
        this.crosshairPickEntity = p_114411_;
    }

    public void overrideCameraOrientation(Quaternionf p_254264_) {
        this.cameraOrientation = p_254264_;
    }

    public void setRenderShadow(boolean p_114469_) {
        this.shouldRenderShadow = p_114469_;
    }

    public void setRenderHitBoxes(boolean p_114474_) {
        this.renderHitBoxes = p_114474_;
    }

    public boolean shouldRenderHitBoxes() {
        return this.renderHitBoxes;
    }

    public <E extends Entity> boolean shouldRender(E p_114398_, Frustum p_114399_, double p_114400_, double p_114401_, double p_114402_) {
        EntityRenderer<E> $$5 = this.getRenderer(p_114398_);
        return $$5.shouldRender(p_114398_, p_114399_, p_114400_, p_114401_, p_114402_);
    }

    public <E extends Entity> void render(E p_114385_, double p_114386_, double p_114387_, double p_114388_, float p_114389_, float p_114390_, PoseStack p_114391_, MultiBufferSource p_114392_, int p_114393_) {
        EntityRenderer<E> $$9 = this.getRenderer(p_114385_);
        try {
            double $$15;
            float $$16;
            float $$14;
            Vec3 $$10 = $$9.getRenderOffset(p_114385_, p_114390_);
            double $$11 = p_114386_ + $$10.x();
            double $$12 = p_114387_ + $$10.y();
            double $$13 = p_114388_ + $$10.z();
            p_114391_.pushPose();
            p_114391_.translate($$11, $$12, $$13);
            $$9.render(p_114385_, p_114389_, p_114390_, p_114391_, p_114392_, p_114393_);
            if (p_114385_.displayFireAnimation()) {
                this.renderFlame(p_114391_, p_114392_, p_114385_, Mth.rotationAroundAxis(Mth.Y_AXIS, this.cameraOrientation, new Quaternionf()));
            }
            p_114391_.translate(-$$10.x(), -$$10.y(), -$$10.z());
            if (this.options.entityShadows().get().booleanValue() && this.shouldRenderShadow && !p_114385_.isInvisible() && ($$14 = $$9.getShadowRadius(p_114385_)) > 0.0f && ($$16 = (float)((1.0 - ($$15 = this.distanceToSqr(p_114385_.getX(), p_114385_.getY(), p_114385_.getZ())) / 256.0) * (double)$$9.shadowStrength)) > 0.0f) {
                EntityRenderDispatcher.renderShadow(p_114391_, p_114392_, p_114385_, $$16, p_114390_, this.level, Math.min($$14, 32.0f));
            }
            if (this.renderHitBoxes && !p_114385_.isInvisible() && !Minecraft.getInstance().showOnlyReducedInfo()) {
                EntityRenderDispatcher.renderHitbox(p_114391_, p_114392_.getBuffer(RenderType.lines()), p_114385_, p_114390_, 1.0f, 1.0f, 1.0f);
            }
            p_114391_.popPose();
        }
        catch (Throwable $$17) {
            CrashReport $$18 = CrashReport.forThrowable($$17, "Rendering entity in world");
            CrashReportCategory $$19 = $$18.addCategory("Entity being rendered");
            p_114385_.fillCrashReportCategory($$19);
            CrashReportCategory $$20 = $$18.addCategory("Renderer details");
            $$20.setDetail("Assigned renderer", $$9);
            $$20.setDetail("Location", CrashReportCategory.formatLocation((LevelHeightAccessor)this.level, p_114386_, p_114387_, p_114388_));
            $$20.setDetail("Rotation", Float.valueOf(p_114389_));
            $$20.setDetail("Delta", Float.valueOf(p_114390_));
            throw new ReportedException($$18);
        }
    }

    private static void renderServerSideHitbox(PoseStack p_353069_, Entity p_353061_, MultiBufferSource p_353074_) {
        Entity $$3 = EntityRenderDispatcher.getServerSideEntity(p_353061_);
        if ($$3 == null) {
            DebugRenderer.renderFloatingText(p_353069_, p_353074_, "Missing", p_353061_.getX(), p_353061_.getBoundingBox().maxY + 1.5, p_353061_.getZ(), -65536);
            return;
        }
        p_353069_.pushPose();
        p_353069_.translate($$3.getX() - p_353061_.getX(), $$3.getY() - p_353061_.getY(), $$3.getZ() - p_353061_.getZ());
        EntityRenderDispatcher.renderHitbox(p_353069_, p_353074_.getBuffer(RenderType.lines()), $$3, 1.0f, 0.0f, 1.0f, 0.0f);
        EntityRenderDispatcher.renderVector(p_353069_, p_353074_.getBuffer(RenderType.lines()), new Vector3f(), $$3.getDeltaMovement(), -256);
        p_353069_.popPose();
    }

    @Nullable
    private static Entity getServerSideEntity(Entity p_353043_) {
        ServerLevel $$2;
        IntegratedServer $$1 = Minecraft.getInstance().getSingleplayerServer();
        if ($$1 != null && ($$2 = $$1.getLevel(p_353043_.level().dimension())) != null) {
            return $$2.getEntity(p_353043_.getId());
        }
        return null;
    }

    private static void renderHitbox(PoseStack p_114442_, VertexConsumer p_114443_, Entity p_114444_, float p_114445_, float p_353064_, float p_353059_, float p_353042_) {
        Entity $$16;
        AABB $$7 = p_114444_.getBoundingBox().move(-p_114444_.getX(), -p_114444_.getY(), -p_114444_.getZ());
        LevelRenderer.renderLineBox(p_114442_, p_114443_, $$7, p_353064_, p_353059_, p_353042_, 1.0f);
        if (p_114444_ instanceof EnderDragon) {
            double $$8 = -Mth.lerp((double)p_114445_, p_114444_.xOld, p_114444_.getX());
            double $$9 = -Mth.lerp((double)p_114445_, p_114444_.yOld, p_114444_.getY());
            double $$10 = -Mth.lerp((double)p_114445_, p_114444_.zOld, p_114444_.getZ());
            for (EnderDragonPart $$11 : ((EnderDragon)p_114444_).getSubEntities()) {
                p_114442_.pushPose();
                double $$12 = $$8 + Mth.lerp((double)p_114445_, $$11.xOld, $$11.getX());
                double $$13 = $$9 + Mth.lerp((double)p_114445_, $$11.yOld, $$11.getY());
                double $$14 = $$10 + Mth.lerp((double)p_114445_, $$11.zOld, $$11.getZ());
                p_114442_.translate($$12, $$13, $$14);
                LevelRenderer.renderLineBox(p_114442_, p_114443_, $$11.getBoundingBox().move(-$$11.getX(), -$$11.getY(), -$$11.getZ()), 0.25f, 1.0f, 0.0f, 1.0f);
                p_114442_.popPose();
            }
        }
        if (p_114444_ instanceof LivingEntity) {
            float $$15 = 0.01f;
            LevelRenderer.renderLineBox(p_114442_, p_114443_, $$7.minX, p_114444_.getEyeHeight() - 0.01f, $$7.minZ, $$7.maxX, p_114444_.getEyeHeight() + 0.01f, $$7.maxZ, 1.0f, 0.0f, 0.0f, 1.0f);
        }
        if (($$16 = p_114444_.getVehicle()) != null) {
            float $$17 = Math.min($$16.getBbWidth(), p_114444_.getBbWidth()) / 2.0f;
            float $$18 = 0.0625f;
            Vec3 $$19 = $$16.getPassengerRidingPosition(p_114444_).subtract(p_114444_.position());
            LevelRenderer.renderLineBox(p_114442_, p_114443_, $$19.x - (double)$$17, $$19.y, $$19.z - (double)$$17, $$19.x + (double)$$17, $$19.y + 0.0625, $$19.z + (double)$$17, 1.0f, 1.0f, 0.0f, 1.0f);
        }
        EntityRenderDispatcher.renderVector(p_114442_, p_114443_, new Vector3f(0.0f, p_114444_.getEyeHeight(), 0.0f), p_114444_.getViewVector(p_114445_).scale(2.0), -16776961);
    }

    private static void renderVector(PoseStack p_353057_, VertexConsumer p_353027_, Vector3f p_353068_, Vec3 p_353070_, int p_353032_) {
        PoseStack.Pose $$5 = p_353057_.last();
        p_353027_.addVertex($$5, p_353068_).setColor(p_353032_).setNormal($$5, (float)p_353070_.x, (float)p_353070_.y, (float)p_353070_.z);
        p_353027_.addVertex($$5, (float)((double)p_353068_.x() + p_353070_.x), (float)((double)p_353068_.y() + p_353070_.y), (float)((double)p_353068_.z() + p_353070_.z)).setColor(p_353032_).setNormal($$5, (float)p_353070_.x, (float)p_353070_.y, (float)p_353070_.z);
    }

    private void renderFlame(PoseStack p_114454_, MultiBufferSource p_114455_, Entity p_114456_, Quaternionf p_304964_) {
        TextureAtlasSprite $$4 = ModelBakery.FIRE_0.sprite();
        TextureAtlasSprite $$5 = ModelBakery.FIRE_1.sprite();
        p_114454_.pushPose();
        float $$6 = p_114456_.getBbWidth() * 1.4f;
        p_114454_.scale($$6, $$6, $$6);
        float $$7 = 0.5f;
        float $$8 = 0.0f;
        float $$9 = p_114456_.getBbHeight() / $$6;
        float $$10 = 0.0f;
        p_114454_.mulPose(p_304964_);
        p_114454_.translate(0.0f, 0.0f, 0.3f - (float)((int)$$9) * 0.02f);
        float $$11 = 0.0f;
        int $$12 = 0;
        VertexConsumer $$13 = p_114455_.getBuffer(Sheets.cutoutBlockSheet());
        PoseStack.Pose $$14 = p_114454_.last();
        while ($$9 > 0.0f) {
            TextureAtlasSprite $$15 = $$12 % 2 == 0 ? $$4 : $$5;
            float $$16 = $$15.getU0();
            float $$17 = $$15.getV0();
            float $$18 = $$15.getU1();
            float $$19 = $$15.getV1();
            if ($$12 / 2 % 2 == 0) {
                float $$20 = $$18;
                $$18 = $$16;
                $$16 = $$20;
            }
            EntityRenderDispatcher.fireVertex($$14, $$13, -$$7 - 0.0f, 0.0f - $$10, $$11, $$18, $$19);
            EntityRenderDispatcher.fireVertex($$14, $$13, $$7 - 0.0f, 0.0f - $$10, $$11, $$16, $$19);
            EntityRenderDispatcher.fireVertex($$14, $$13, $$7 - 0.0f, 1.4f - $$10, $$11, $$16, $$17);
            EntityRenderDispatcher.fireVertex($$14, $$13, -$$7 - 0.0f, 1.4f - $$10, $$11, $$18, $$17);
            $$9 -= 0.45f;
            $$10 -= 0.45f;
            $$7 *= 0.9f;
            $$11 -= 0.03f;
            ++$$12;
        }
        p_114454_.popPose();
    }

    private static void fireVertex(PoseStack.Pose p_114415_, VertexConsumer p_114416_, float p_114417_, float p_114418_, float p_114419_, float p_114420_, float p_114421_) {
        p_114416_.addVertex(p_114415_, p_114417_, p_114418_, p_114419_).setColor(-1).setUv(p_114420_, p_114421_).setUv1(0, 10).setLight(240).setNormal(p_114415_, 0.0f, 1.0f, 0.0f);
    }

    private static void renderShadow(PoseStack p_114458_, MultiBufferSource p_114459_, Entity p_114460_, float p_114461_, float p_114462_, LevelReader p_114463_, float p_114464_) {
        double $$7 = Mth.lerp((double)p_114462_, p_114460_.xOld, p_114460_.getX());
        double $$8 = Mth.lerp((double)p_114462_, p_114460_.yOld, p_114460_.getY());
        double $$9 = Mth.lerp((double)p_114462_, p_114460_.zOld, p_114460_.getZ());
        float $$10 = Math.min(p_114461_ / 0.5f, p_114464_);
        int $$11 = Mth.floor($$7 - (double)p_114464_);
        int $$12 = Mth.floor($$7 + (double)p_114464_);
        int $$13 = Mth.floor($$8 - (double)$$10);
        int $$14 = Mth.floor($$8);
        int $$15 = Mth.floor($$9 - (double)p_114464_);
        int $$16 = Mth.floor($$9 + (double)p_114464_);
        PoseStack.Pose $$17 = p_114458_.last();
        VertexConsumer $$18 = p_114459_.getBuffer(SHADOW_RENDER_TYPE);
        BlockPos.MutableBlockPos $$19 = new BlockPos.MutableBlockPos();
        for (int $$20 = $$15; $$20 <= $$16; ++$$20) {
            for (int $$21 = $$11; $$21 <= $$12; ++$$21) {
                $$19.set($$21, 0, $$20);
                ChunkAccess $$22 = p_114463_.getChunk($$19);
                for (int $$23 = $$13; $$23 <= $$14; ++$$23) {
                    $$19.setY($$23);
                    float $$24 = p_114461_ - (float)($$8 - (double)$$19.getY()) * 0.5f;
                    EntityRenderDispatcher.renderBlockShadow($$17, $$18, $$22, p_114463_, $$19, $$7, $$8, $$9, p_114464_, $$24);
                }
            }
        }
    }

    private static void renderBlockShadow(PoseStack.Pose p_277956_, VertexConsumer p_277533_, ChunkAccess p_277501_, LevelReader p_277622_, BlockPos p_277911_, double p_277682_, double p_278099_, double p_277806_, float p_277844_, float p_277496_) {
        BlockPos $$10 = p_277911_.below();
        BlockState $$11 = p_277501_.getBlockState($$10);
        if ($$11.getRenderShape() == RenderShape.INVISIBLE || p_277622_.getMaxLocalRawBrightness(p_277911_) <= 3) {
            return;
        }
        if (!$$11.isCollisionShapeFullBlock(p_277501_, $$10)) {
            return;
        }
        VoxelShape $$12 = $$11.getShape(p_277501_, $$10);
        if ($$12.isEmpty()) {
            return;
        }
        float $$13 = LightTexture.getBrightness(p_277622_.dimensionType(), p_277622_.getMaxLocalRawBrightness(p_277911_));
        float $$14 = p_277496_ * 0.5f * $$13;
        if ($$14 >= 0.0f) {
            if ($$14 > 1.0f) {
                $$14 = 1.0f;
            }
            int $$15 = FastColor.ARGB32.color(Mth.floor($$14 * 255.0f), 255, 255, 255);
            AABB $$16 = $$12.bounds();
            double $$17 = (double)p_277911_.getX() + $$16.minX;
            double $$18 = (double)p_277911_.getX() + $$16.maxX;
            double $$19 = (double)p_277911_.getY() + $$16.minY;
            double $$20 = (double)p_277911_.getZ() + $$16.minZ;
            double $$21 = (double)p_277911_.getZ() + $$16.maxZ;
            float $$22 = (float)($$17 - p_277682_);
            float $$23 = (float)($$18 - p_277682_);
            float $$24 = (float)($$19 - p_278099_);
            float $$25 = (float)($$20 - p_277806_);
            float $$26 = (float)($$21 - p_277806_);
            float $$27 = -$$22 / 2.0f / p_277844_ + 0.5f;
            float $$28 = -$$23 / 2.0f / p_277844_ + 0.5f;
            float $$29 = -$$25 / 2.0f / p_277844_ + 0.5f;
            float $$30 = -$$26 / 2.0f / p_277844_ + 0.5f;
            EntityRenderDispatcher.shadowVertex(p_277956_, p_277533_, $$15, $$22, $$24, $$25, $$27, $$29);
            EntityRenderDispatcher.shadowVertex(p_277956_, p_277533_, $$15, $$22, $$24, $$26, $$27, $$30);
            EntityRenderDispatcher.shadowVertex(p_277956_, p_277533_, $$15, $$23, $$24, $$26, $$28, $$30);
            EntityRenderDispatcher.shadowVertex(p_277956_, p_277533_, $$15, $$23, $$24, $$25, $$28, $$29);
        }
    }

    private static void shadowVertex(PoseStack.Pose p_114423_, VertexConsumer p_114424_, int p_350992_, float p_114425_, float p_114426_, float p_114427_, float p_114428_, float p_114429_) {
        Vector3f $$8 = p_114423_.pose().transformPosition(p_114425_, p_114426_, p_114427_, new Vector3f());
        p_114424_.addVertex($$8.x(), $$8.y(), $$8.z(), p_350992_, p_114428_, p_114429_, OverlayTexture.NO_OVERLAY, 0xF000F0, 0.0f, 1.0f, 0.0f);
    }

    public void setLevel(@Nullable Level p_114407_) {
        this.level = p_114407_;
        if (p_114407_ == null) {
            this.camera = null;
        }
    }

    public double distanceToSqr(Entity p_114472_) {
        return this.camera.getPosition().distanceToSqr(p_114472_.position());
    }

    public double distanceToSqr(double p_114379_, double p_114380_, double p_114381_) {
        return this.camera.getPosition().distanceToSqr(p_114379_, p_114380_, p_114381_);
    }

    public Quaternionf cameraOrientation() {
        return this.cameraOrientation;
    }

    public ItemInHandRenderer getItemInHandRenderer() {
        return this.itemInHandRenderer;
    }

    @Override
    public void onResourceManagerReload(ResourceManager p_174004_) {
        EntityRendererProvider.Context $$1 = new EntityRendererProvider.Context(this, this.itemRenderer, this.blockRenderDispatcher, this.itemInHandRenderer, p_174004_, this.entityModels, this.font);
        this.renderers = EntityRenderers.createEntityRenderers($$1);
        this.playerRenderers = EntityRenderers.createPlayerRenderers($$1);
    }
}

