/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import com.mojang.math.MatrixUtil;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;

public class ItemRenderer
implements ResourceManagerReloadListener {
    public static final ResourceLocation ENCHANTED_GLINT_ENTITY = ResourceLocation.withDefaultNamespace("textures/misc/enchanted_glint_entity.png");
    public static final ResourceLocation ENCHANTED_GLINT_ITEM = ResourceLocation.withDefaultNamespace("textures/misc/enchanted_glint_item.png");
    private static final Set<Item> IGNORED = Sets.newHashSet((Object[])new Item[]{Items.AIR});
    public static final int GUI_SLOT_CENTER_X = 8;
    public static final int GUI_SLOT_CENTER_Y = 8;
    public static final int ITEM_COUNT_BLIT_OFFSET = 200;
    public static final float COMPASS_FOIL_UI_SCALE = 0.5f;
    public static final float COMPASS_FOIL_FIRST_PERSON_SCALE = 0.75f;
    public static final float COMPASS_FOIL_TEXTURE_SCALE = 0.0078125f;
    private static final ModelResourceLocation TRIDENT_MODEL = ModelResourceLocation.inventory(ResourceLocation.withDefaultNamespace("trident"));
    public static final ModelResourceLocation TRIDENT_IN_HAND_MODEL = ModelResourceLocation.inventory(ResourceLocation.withDefaultNamespace("trident_in_hand"));
    private static final ModelResourceLocation SPYGLASS_MODEL = ModelResourceLocation.inventory(ResourceLocation.withDefaultNamespace("spyglass"));
    public static final ModelResourceLocation SPYGLASS_IN_HAND_MODEL = ModelResourceLocation.inventory(ResourceLocation.withDefaultNamespace("spyglass_in_hand"));
    private final Minecraft minecraft;
    private final ItemModelShaper itemModelShaper;
    private final TextureManager textureManager;
    private final ItemColors itemColors;
    private final BlockEntityWithoutLevelRenderer blockEntityRenderer;

    public ItemRenderer(Minecraft p_266926_, TextureManager p_266774_, ModelManager p_266850_, ItemColors p_267016_, BlockEntityWithoutLevelRenderer p_267049_) {
        this.minecraft = p_266926_;
        this.textureManager = p_266774_;
        this.itemModelShaper = new ItemModelShaper(p_266850_);
        this.blockEntityRenderer = p_267049_;
        for (Item $$5 : BuiltInRegistries.ITEM) {
            if (IGNORED.contains($$5)) continue;
            this.itemModelShaper.register($$5, ModelResourceLocation.inventory(BuiltInRegistries.ITEM.getKey($$5)));
        }
        this.itemColors = p_267016_;
    }

    public ItemModelShaper getItemModelShaper() {
        return this.itemModelShaper;
    }

    private void renderModelLists(BakedModel p_115190_, ItemStack p_115191_, int p_115192_, int p_115193_, PoseStack p_115194_, VertexConsumer p_115195_) {
        RandomSource $$6 = RandomSource.create();
        long $$7 = 42L;
        for (Direction $$8 : Direction.values()) {
            $$6.setSeed(42L);
            this.renderQuadList(p_115194_, p_115195_, p_115190_.getQuads(null, $$8, $$6), p_115191_, p_115192_, p_115193_);
        }
        $$6.setSeed(42L);
        this.renderQuadList(p_115194_, p_115195_, p_115190_.getQuads(null, null, $$6), p_115191_, p_115192_, p_115193_);
    }

    public void render(ItemStack p_115144_, ItemDisplayContext p_270188_, boolean p_115146_, PoseStack p_115147_, MultiBufferSource p_115148_, int p_115149_, int p_115150_, BakedModel p_115151_) {
        boolean $$8;
        if (p_115144_.isEmpty()) {
            return;
        }
        p_115147_.pushPose();
        boolean bl = $$8 = p_270188_ == ItemDisplayContext.GUI || p_270188_ == ItemDisplayContext.GROUND || p_270188_ == ItemDisplayContext.FIXED;
        if ($$8) {
            if (p_115144_.is(Items.TRIDENT)) {
                p_115151_ = this.itemModelShaper.getModelManager().getModel(TRIDENT_MODEL);
            } else if (p_115144_.is(Items.SPYGLASS)) {
                p_115151_ = this.itemModelShaper.getModelManager().getModel(SPYGLASS_MODEL);
            }
        }
        p_115151_.getTransforms().getTransform(p_270188_).apply(p_115146_, p_115147_);
        p_115147_.translate(-0.5f, -0.5f, -0.5f);
        if (p_115151_.isCustomRenderer() || p_115144_.is(Items.TRIDENT) && !$$8) {
            this.blockEntityRenderer.renderByItem(p_115144_, p_270188_, p_115147_, p_115148_, p_115149_, p_115150_);
        } else {
            VertexConsumer $$17;
            boolean $$12;
            Item item;
            if (p_270188_ != ItemDisplayContext.GUI && !p_270188_.firstPerson() && (item = p_115144_.getItem()) instanceof BlockItem) {
                BlockItem $$9 = (BlockItem)item;
                Block $$10 = $$9.getBlock();
                boolean $$11 = !($$10 instanceof HalfTransparentBlock) && !($$10 instanceof StainedGlassPaneBlock);
            } else {
                $$12 = true;
            }
            RenderType $$13 = ItemBlockRenderTypes.getRenderType(p_115144_, $$12);
            if (ItemRenderer.hasAnimatedTexture(p_115144_) && p_115144_.hasFoil()) {
                PoseStack.Pose $$14 = p_115147_.last().copy();
                if (p_270188_ == ItemDisplayContext.GUI) {
                    MatrixUtil.mulComponentWise($$14.pose(), 0.5f);
                } else if (p_270188_.firstPerson()) {
                    MatrixUtil.mulComponentWise($$14.pose(), 0.75f);
                }
                VertexConsumer $$15 = ItemRenderer.getCompassFoilBuffer(p_115148_, $$13, $$14);
            } else if ($$12) {
                VertexConsumer $$16 = ItemRenderer.getFoilBufferDirect(p_115148_, $$13, true, p_115144_.hasFoil());
            } else {
                $$17 = ItemRenderer.getFoilBuffer(p_115148_, $$13, true, p_115144_.hasFoil());
            }
            this.renderModelLists(p_115151_, p_115144_, p_115149_, p_115150_, p_115147_, $$17);
        }
        p_115147_.popPose();
    }

    private static boolean hasAnimatedTexture(ItemStack p_286353_) {
        return p_286353_.is(ItemTags.COMPASSES) || p_286353_.is(Items.CLOCK);
    }

    public static VertexConsumer getArmorFoilBuffer(MultiBufferSource p_115185_, RenderType p_115186_, boolean p_115187_) {
        if (p_115187_) {
            return VertexMultiConsumer.create(p_115185_.getBuffer(RenderType.armorEntityGlint()), p_115185_.getBuffer(p_115186_));
        }
        return p_115185_.getBuffer(p_115186_);
    }

    public static VertexConsumer getCompassFoilBuffer(MultiBufferSource p_115181_, RenderType p_115182_, PoseStack.Pose p_115183_) {
        return VertexMultiConsumer.create((VertexConsumer)new SheetedDecalTextureGenerator(p_115181_.getBuffer(RenderType.glint()), p_115183_, 0.0078125f), p_115181_.getBuffer(p_115182_));
    }

    public static VertexConsumer getFoilBuffer(MultiBufferSource p_115212_, RenderType p_115213_, boolean p_115214_, boolean p_115215_) {
        if (p_115215_) {
            if (Minecraft.useShaderTransparency() && p_115213_ == Sheets.translucentItemSheet()) {
                return VertexMultiConsumer.create(p_115212_.getBuffer(RenderType.glintTranslucent()), p_115212_.getBuffer(p_115213_));
            }
            return VertexMultiConsumer.create(p_115212_.getBuffer(p_115214_ ? RenderType.glint() : RenderType.entityGlint()), p_115212_.getBuffer(p_115213_));
        }
        return p_115212_.getBuffer(p_115213_);
    }

    public static VertexConsumer getFoilBufferDirect(MultiBufferSource p_115223_, RenderType p_115224_, boolean p_115225_, boolean p_115226_) {
        if (p_115226_) {
            return VertexMultiConsumer.create(p_115223_.getBuffer(p_115225_ ? RenderType.glint() : RenderType.entityGlintDirect()), p_115223_.getBuffer(p_115224_));
        }
        return p_115223_.getBuffer(p_115224_);
    }

    private void renderQuadList(PoseStack p_115163_, VertexConsumer p_115164_, List<BakedQuad> p_115165_, ItemStack p_115166_, int p_115167_, int p_115168_) {
        boolean $$6 = !p_115166_.isEmpty();
        PoseStack.Pose $$7 = p_115163_.last();
        for (BakedQuad $$8 : p_115165_) {
            int $$9 = -1;
            if ($$6 && $$8.isTinted()) {
                $$9 = this.itemColors.getColor(p_115166_, $$8.getTintIndex());
            }
            float $$10 = (float)FastColor.ARGB32.alpha($$9) / 255.0f;
            float $$11 = (float)FastColor.ARGB32.red($$9) / 255.0f;
            float $$12 = (float)FastColor.ARGB32.green($$9) / 255.0f;
            float $$13 = (float)FastColor.ARGB32.blue($$9) / 255.0f;
            p_115164_.putBulkData($$7, $$8, $$11, $$12, $$13, $$10, p_115167_, p_115168_);
        }
    }

    public BakedModel getModel(ItemStack p_174265_, @Nullable Level p_174266_, @Nullable LivingEntity p_174267_, int p_174268_) {
        BakedModel $$6;
        if (p_174265_.is(Items.TRIDENT)) {
            BakedModel $$4 = this.itemModelShaper.getModelManager().getModel(TRIDENT_IN_HAND_MODEL);
        } else if (p_174265_.is(Items.SPYGLASS)) {
            BakedModel $$5 = this.itemModelShaper.getModelManager().getModel(SPYGLASS_IN_HAND_MODEL);
        } else {
            $$6 = this.itemModelShaper.getItemModel(p_174265_);
        }
        ClientLevel $$7 = p_174266_ instanceof ClientLevel ? (ClientLevel)p_174266_ : null;
        BakedModel $$8 = $$6.getOverrides().resolve($$6, p_174265_, $$7, p_174267_, p_174268_);
        return $$8 == null ? this.itemModelShaper.getModelManager().getMissingModel() : $$8;
    }

    public void renderStatic(ItemStack p_270761_, ItemDisplayContext p_270648_, int p_270410_, int p_270894_, PoseStack p_270430_, MultiBufferSource p_270457_, @Nullable Level p_270149_, int p_270509_) {
        this.renderStatic(null, p_270761_, p_270648_, false, p_270430_, p_270457_, p_270149_, p_270410_, p_270894_, p_270509_);
    }

    public void renderStatic(@Nullable LivingEntity p_270101_, ItemStack p_270637_, ItemDisplayContext p_270437_, boolean p_270434_, PoseStack p_270230_, MultiBufferSource p_270411_, @Nullable Level p_270641_, int p_270595_, int p_270927_, int p_270845_) {
        if (p_270637_.isEmpty()) {
            return;
        }
        BakedModel $$10 = this.getModel(p_270637_, p_270641_, p_270101_, p_270845_);
        this.render(p_270637_, p_270437_, p_270434_, p_270230_, p_270411_, p_270595_, p_270927_, $$10);
    }

    @Override
    public void onResourceManagerReload(ResourceManager p_115105_) {
        this.itemModelShaper.rebuildCache();
    }
}

