/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.MinecartModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class MinecartRenderer<T extends AbstractMinecart>
extends EntityRenderer<T> {
    private static final ResourceLocation MINECART_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/minecart.png");
    protected final EntityModel<T> model;
    private final BlockRenderDispatcher blockRenderer;

    public MinecartRenderer(EntityRendererProvider.Context p_174300_, ModelLayerLocation p_174301_) {
        super(p_174300_);
        this.shadowRadius = 0.7f;
        this.model = new MinecartModel(p_174300_.bakeLayer(p_174301_));
        this.blockRenderer = p_174300_.getBlockRenderDispatcher();
    }

    @Override
    public void render(T p_115418_, float p_115419_, float p_115420_, PoseStack p_115421_, MultiBufferSource p_115422_, int p_115423_) {
        super.render(p_115418_, p_115419_, p_115420_, p_115421_, p_115422_, p_115423_);
        p_115421_.pushPose();
        long $$6 = (long)((Entity)p_115418_).getId() * 493286711L;
        $$6 = $$6 * $$6 * 4392167121L + $$6 * 98761L;
        float $$7 = (((float)($$6 >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float $$8 = (((float)($$6 >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float $$9 = (((float)($$6 >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        p_115421_.translate($$7, $$8, $$9);
        double $$10 = Mth.lerp((double)p_115420_, ((AbstractMinecart)p_115418_).xOld, ((Entity)p_115418_).getX());
        double $$11 = Mth.lerp((double)p_115420_, ((AbstractMinecart)p_115418_).yOld, ((Entity)p_115418_).getY());
        double $$12 = Mth.lerp((double)p_115420_, ((AbstractMinecart)p_115418_).zOld, ((Entity)p_115418_).getZ());
        double $$13 = 0.3f;
        Vec3 $$14 = ((AbstractMinecart)p_115418_).getPos($$10, $$11, $$12);
        float $$15 = Mth.lerp(p_115420_, ((AbstractMinecart)p_115418_).xRotO, ((Entity)p_115418_).getXRot());
        if ($$14 != null) {
            Vec3 $$16 = ((AbstractMinecart)p_115418_).getPosOffs($$10, $$11, $$12, 0.3f);
            Vec3 $$17 = ((AbstractMinecart)p_115418_).getPosOffs($$10, $$11, $$12, -0.3f);
            if ($$16 == null) {
                $$16 = $$14;
            }
            if ($$17 == null) {
                $$17 = $$14;
            }
            p_115421_.translate($$14.x - $$10, ($$16.y + $$17.y) / 2.0 - $$11, $$14.z - $$12);
            Vec3 $$18 = $$17.add(-$$16.x, -$$16.y, -$$16.z);
            if ($$18.length() != 0.0) {
                $$18 = $$18.normalize();
                p_115419_ = (float)(Math.atan2($$18.z, $$18.x) * 180.0 / Math.PI);
                $$15 = (float)(Math.atan($$18.y) * 73.0);
            }
        }
        p_115421_.translate(0.0f, 0.375f, 0.0f);
        p_115421_.mulPose(Axis.YP.rotationDegrees(180.0f - p_115419_));
        p_115421_.mulPose(Axis.ZP.rotationDegrees(-$$15));
        float $$19 = (float)((VehicleEntity)p_115418_).getHurtTime() - p_115420_;
        float $$20 = ((VehicleEntity)p_115418_).getDamage() - p_115420_;
        if ($$20 < 0.0f) {
            $$20 = 0.0f;
        }
        if ($$19 > 0.0f) {
            p_115421_.mulPose(Axis.XP.rotationDegrees(Mth.sin($$19) * $$19 * $$20 / 10.0f * (float)((VehicleEntity)p_115418_).getHurtDir()));
        }
        int $$21 = ((AbstractMinecart)p_115418_).getDisplayOffset();
        BlockState $$22 = ((AbstractMinecart)p_115418_).getDisplayBlockState();
        if ($$22.getRenderShape() != RenderShape.INVISIBLE) {
            p_115421_.pushPose();
            float $$23 = 0.75f;
            p_115421_.scale(0.75f, 0.75f, 0.75f);
            p_115421_.translate(-0.5f, (float)($$21 - 8) / 16.0f, 0.5f);
            p_115421_.mulPose(Axis.YP.rotationDegrees(90.0f));
            this.renderMinecartContents(p_115418_, p_115420_, $$22, p_115421_, p_115422_, p_115423_);
            p_115421_.popPose();
        }
        p_115421_.scale(-1.0f, -1.0f, 1.0f);
        this.model.setupAnim(p_115418_, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        VertexConsumer $$24 = p_115422_.getBuffer(this.model.renderType(this.getTextureLocation(p_115418_)));
        this.model.renderToBuffer(p_115421_, $$24, p_115423_, OverlayTexture.NO_OVERLAY);
        p_115421_.popPose();
    }

    @Override
    public ResourceLocation getTextureLocation(T p_115416_) {
        return MINECART_LOCATION;
    }

    protected void renderMinecartContents(T p_115424_, float p_115425_, BlockState p_115426_, PoseStack p_115427_, MultiBufferSource p_115428_, int p_115429_) {
        this.blockRenderer.renderSingleBlock(p_115426_, p_115427_, p_115428_, p_115429_, OverlayTexture.NO_OVERLAY);
    }
}

