/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class ElytraLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation WINGS_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/elytra.png");
    private final ElytraModel<T> elytraModel;

    public ElytraLayer(RenderLayerParent<T, M> p_174493_, EntityModelSet p_174494_) {
        super(p_174493_);
        this.elytraModel = new ElytraModel(p_174494_.bakeLayer(ModelLayers.ELYTRA));
    }

    @Override
    public void render(PoseStack p_116951_, MultiBufferSource p_116952_, int p_116953_, T p_116954_, float p_116955_, float p_116956_, float p_116957_, float p_116958_, float p_116959_, float p_116960_) {
        ResourceLocation $$16;
        ItemStack $$10 = ((LivingEntity)p_116954_).getItemBySlot(EquipmentSlot.CHEST);
        if (!$$10.is(Items.ELYTRA)) {
            return;
        }
        if (p_116954_ instanceof AbstractClientPlayer) {
            AbstractClientPlayer $$11 = (AbstractClientPlayer)p_116954_;
            PlayerSkin $$12 = $$11.getSkin();
            if ($$12.elytraTexture() != null) {
                ResourceLocation $$13 = $$12.elytraTexture();
            } else if ($$12.capeTexture() != null && $$11.isModelPartShown(PlayerModelPart.CAPE)) {
                ResourceLocation $$14 = $$12.capeTexture();
            } else {
                ResourceLocation $$15 = WINGS_LOCATION;
            }
        } else {
            $$16 = WINGS_LOCATION;
        }
        p_116951_.pushPose();
        p_116951_.translate(0.0f, 0.0f, 0.125f);
        ((EntityModel)this.getParentModel()).copyPropertiesTo(this.elytraModel);
        this.elytraModel.setupAnim(p_116954_, p_116955_, p_116956_, p_116958_, p_116959_, p_116960_);
        VertexConsumer $$17 = ItemRenderer.getArmorFoilBuffer(p_116952_, RenderType.armorCutoutNoCull($$16), $$10.hasFoil());
        this.elytraModel.renderToBuffer(p_116951_, $$17, p_116953_, OverlayTexture.NO_OVERLAY);
        p_116951_.popPose();
    }
}

