/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;

public class MultiPartBakedModel
implements BakedModel {
    private final List<Pair<Predicate<BlockState>, BakedModel>> selectors;
    protected final boolean hasAmbientOcclusion;
    protected final boolean isGui3d;
    protected final boolean usesBlockLight;
    protected final TextureAtlasSprite particleIcon;
    protected final ItemTransforms transforms;
    protected final ItemOverrides overrides;
    private final Map<BlockState, BitSet> selectorCache = new Reference2ObjectOpenHashMap();

    public MultiPartBakedModel(List<Pair<Predicate<BlockState>, BakedModel>> p_119462_) {
        this.selectors = p_119462_;
        BakedModel $$1 = (BakedModel)p_119462_.iterator().next().getRight();
        this.hasAmbientOcclusion = $$1.useAmbientOcclusion();
        this.isGui3d = $$1.isGui3d();
        this.usesBlockLight = $$1.usesBlockLight();
        this.particleIcon = $$1.getParticleIcon();
        this.transforms = $$1.getTransforms();
        this.overrides = $$1.getOverrides();
    }

    @Override
    public List<BakedQuad> getQuads(@Nullable BlockState p_235050_, @Nullable Direction p_235051_, RandomSource p_235052_) {
        if (p_235050_ == null) {
            return Collections.emptyList();
        }
        BitSet $$3 = this.selectorCache.get(p_235050_);
        if ($$3 == null) {
            $$3 = new BitSet();
            for (int $$4 = 0; $$4 < this.selectors.size(); ++$$4) {
                Pair<Predicate<BlockState>, BakedModel> $$5 = this.selectors.get($$4);
                if (!((Predicate)$$5.getLeft()).test(p_235050_)) continue;
                $$3.set($$4);
            }
            this.selectorCache.put(p_235050_, $$3);
        }
        ArrayList $$6 = Lists.newArrayList();
        long $$7 = p_235052_.nextLong();
        for (int $$8 = 0; $$8 < $$3.length(); ++$$8) {
            if (!$$3.get($$8)) continue;
            $$6.addAll(((BakedModel)this.selectors.get($$8).getRight()).getQuads(p_235050_, p_235051_, RandomSource.create($$7)));
        }
        return $$6;
    }

    @Override
    public boolean useAmbientOcclusion() {
        return this.hasAmbientOcclusion;
    }

    @Override
    public boolean isGui3d() {
        return this.isGui3d;
    }

    @Override
    public boolean usesBlockLight() {
        return this.usesBlockLight;
    }

    @Override
    public boolean isCustomRenderer() {
        return false;
    }

    @Override
    public TextureAtlasSprite getParticleIcon() {
        return this.particleIcon;
    }

    @Override
    public ItemTransforms getTransforms() {
        return this.transforms;
    }

    @Override
    public ItemOverrides getOverrides() {
        return this.overrides;
    }

    public static class Builder {
        private final List<Pair<Predicate<BlockState>, BakedModel>> selectors = Lists.newArrayList();

        public void add(Predicate<BlockState> p_119478_, BakedModel p_119479_) {
            this.selectors.add((Pair<Predicate<BlockState>, BakedModel>)Pair.of(p_119478_, (Object)p_119479_));
        }

        public BakedModel build() {
            return new MultiPartBakedModel(this.selectors);
        }
    }
}

