/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;

public class ClientboundLevelChunkPacketData {
    private static final int TWO_MEGABYTES = 0x200000;
    private final CompoundTag heightmaps;
    private final byte[] buffer;
    private final List<BlockEntityInfo> blockEntitiesData;

    public ClientboundLevelChunkPacketData(LevelChunk p_195651_) {
        this.heightmaps = new CompoundTag();
        for (Map.Entry<Heightmap.Types, Heightmap> entry : p_195651_.getHeightmaps()) {
            if (!entry.getKey().sendToClient()) continue;
            this.heightmaps.put(entry.getKey().getSerializationKey(), new LongArrayTag(entry.getValue().getRawData()));
        }
        this.buffer = new byte[ClientboundLevelChunkPacketData.calculateChunkSize(p_195651_)];
        ClientboundLevelChunkPacketData.extractChunkData(new FriendlyByteBuf(this.getWriteBuffer()), p_195651_);
        this.blockEntitiesData = Lists.newArrayList();
        for (Map.Entry<Object, Object> entry : p_195651_.getBlockEntities().entrySet()) {
            this.blockEntitiesData.add(BlockEntityInfo.create((BlockEntity)entry.getValue()));
        }
    }

    public ClientboundLevelChunkPacketData(RegistryFriendlyByteBuf p_320343_, int p_195654_, int p_195655_) {
        this.heightmaps = p_320343_.readNbt();
        if (this.heightmaps == null) {
            throw new RuntimeException("Can't read heightmap in packet for [" + p_195654_ + ", " + p_195655_ + "]");
        }
        int $$3 = p_320343_.readVarInt();
        if ($$3 > 0x200000) {
            throw new RuntimeException("Chunk Packet trying to allocate too much memory on read.");
        }
        this.buffer = new byte[$$3];
        p_320343_.readBytes(this.buffer);
        this.blockEntitiesData = (List)BlockEntityInfo.LIST_STREAM_CODEC.decode(p_320343_);
    }

    public void write(RegistryFriendlyByteBuf p_320863_) {
        p_320863_.writeNbt(this.heightmaps);
        p_320863_.writeVarInt(this.buffer.length);
        p_320863_.writeBytes(this.buffer);
        BlockEntityInfo.LIST_STREAM_CODEC.encode(p_320863_, this.blockEntitiesData);
    }

    private static int calculateChunkSize(LevelChunk p_195665_) {
        int $$1 = 0;
        for (LevelChunkSection $$2 : p_195665_.getSections()) {
            $$1 += $$2.getSerializedSize();
        }
        return $$1;
    }

    private ByteBuf getWriteBuffer() {
        ByteBuf $$0 = Unpooled.wrappedBuffer((byte[])this.buffer);
        $$0.writerIndex(0);
        return $$0;
    }

    public static void extractChunkData(FriendlyByteBuf p_195669_, LevelChunk p_195670_) {
        for (LevelChunkSection $$2 : p_195670_.getSections()) {
            $$2.write(p_195669_);
        }
    }

    public Consumer<BlockEntityTagOutput> getBlockEntitiesTagsConsumer(int p_195658_, int p_195659_) {
        return p_195663_ -> this.getBlockEntitiesTags((BlockEntityTagOutput)p_195663_, p_195658_, p_195659_);
    }

    private void getBlockEntitiesTags(BlockEntityTagOutput p_195675_, int p_195676_, int p_195677_) {
        int $$3 = 16 * p_195676_;
        int $$4 = 16 * p_195677_;
        BlockPos.MutableBlockPos $$5 = new BlockPos.MutableBlockPos();
        for (BlockEntityInfo $$6 : this.blockEntitiesData) {
            int $$7 = $$3 + SectionPos.sectionRelative($$6.packedXZ >> 4);
            int $$8 = $$4 + SectionPos.sectionRelative($$6.packedXZ);
            $$5.set($$7, $$6.y, $$8);
            p_195675_.accept($$5, $$6.type, $$6.tag);
        }
    }

    public FriendlyByteBuf getReadBuffer() {
        return new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])this.buffer));
    }

    public CompoundTag getHeightmaps() {
        return this.heightmaps;
    }

    static class BlockEntityInfo {
        public static final StreamCodec<RegistryFriendlyByteBuf, BlockEntityInfo> STREAM_CODEC = StreamCodec.ofMember(BlockEntityInfo::write, BlockEntityInfo::new);
        public static final StreamCodec<RegistryFriendlyByteBuf, List<BlockEntityInfo>> LIST_STREAM_CODEC = STREAM_CODEC.apply(ByteBufCodecs.list());
        final int packedXZ;
        final int y;
        final BlockEntityType<?> type;
        @Nullable
        final CompoundTag tag;

        private BlockEntityInfo(int p_195685_, int p_195686_, BlockEntityType<?> p_195687_, @Nullable CompoundTag p_195688_) {
            this.packedXZ = p_195685_;
            this.y = p_195686_;
            this.type = p_195687_;
            this.tag = p_195688_;
        }

        private BlockEntityInfo(RegistryFriendlyByteBuf p_319780_) {
            this.packedXZ = p_319780_.readByte();
            this.y = p_319780_.readShort();
            this.type = (BlockEntityType)ByteBufCodecs.registry(Registries.BLOCK_ENTITY_TYPE).decode(p_319780_);
            this.tag = p_319780_.readNbt();
        }

        private void write(RegistryFriendlyByteBuf p_320914_) {
            p_320914_.writeByte(this.packedXZ);
            p_320914_.writeShort(this.y);
            ByteBufCodecs.registry(Registries.BLOCK_ENTITY_TYPE).encode(p_320914_, this.type);
            p_320914_.writeNbt(this.tag);
        }

        static BlockEntityInfo create(BlockEntity p_195692_) {
            CompoundTag $$1 = p_195692_.getUpdateTag(p_195692_.getLevel().registryAccess());
            BlockPos $$2 = p_195692_.getBlockPos();
            int $$3 = SectionPos.sectionRelative($$2.getX()) << 4 | SectionPos.sectionRelative($$2.getZ());
            return new BlockEntityInfo($$3, $$2.getY(), p_195692_.getType(), $$1.isEmpty() ? null : $$1);
        }
    }

    @FunctionalInterface
    public static interface BlockEntityTagOutput {
        public void accept(BlockPos var1, BlockEntityType<?> var2, @Nullable CompoundTag var3);
    }
}

