/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ObjectiveArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;

public class TriggerCommand {
    private static final SimpleCommandExceptionType ERROR_NOT_PRIMED = new SimpleCommandExceptionType((Message)Component.translatable("commands.trigger.failed.unprimed"));
    private static final SimpleCommandExceptionType ERROR_INVALID_OBJECTIVE = new SimpleCommandExceptionType((Message)Component.translatable("commands.trigger.failed.invalid"));

    public static void register(CommandDispatcher<CommandSourceStack> p_139142_) {
        p_139142_.register((LiteralArgumentBuilder)Commands.literal("trigger").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("objective", ObjectiveArgument.objective()).suggests((p_139146_, p_139147_) -> TriggerCommand.suggestObjectives((CommandSourceStack)p_139146_.getSource(), p_139147_)).executes(p_313576_ -> TriggerCommand.simpleTrigger((CommandSourceStack)p_313576_.getSource(), ((CommandSourceStack)p_313576_.getSource()).getPlayerOrException(), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)p_313576_, "objective")))).then(Commands.literal("add").then(Commands.argument("value", IntegerArgumentType.integer()).executes(p_313577_ -> TriggerCommand.addValue((CommandSourceStack)p_313577_.getSource(), ((CommandSourceStack)p_313577_.getSource()).getPlayerOrException(), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)p_313577_, "objective"), IntegerArgumentType.getInteger((CommandContext)p_313577_, (String)"value")))))).then(Commands.literal("set").then(Commands.argument("value", IntegerArgumentType.integer()).executes(p_313581_ -> TriggerCommand.setValue((CommandSourceStack)p_313581_.getSource(), ((CommandSourceStack)p_313581_.getSource()).getPlayerOrException(), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)p_313581_, "objective"), IntegerArgumentType.getInteger((CommandContext)p_313581_, (String)"value")))))));
    }

    public static CompletableFuture<Suggestions> suggestObjectives(CommandSourceStack p_139149_, SuggestionsBuilder p_139150_) {
        Entity $$2 = p_139149_.getEntity();
        ArrayList $$3 = Lists.newArrayList();
        if ($$2 != null) {
            ServerScoreboard $$4 = p_139149_.getServer().getScoreboard();
            for (Objective $$5 : $$4.getObjectives()) {
                ReadOnlyScoreInfo $$6;
                if ($$5.getCriteria() != ObjectiveCriteria.TRIGGER || ($$6 = $$4.getPlayerScoreInfo($$2, $$5)) == null || $$6.isLocked()) continue;
                $$3.add($$5.getName());
            }
        }
        return SharedSuggestionProvider.suggest($$3, p_139150_);
    }

    private static int addValue(CommandSourceStack p_139155_, ServerPlayer p_313736_, Objective p_313848_, int p_139157_) throws CommandSyntaxException {
        ScoreAccess $$4 = TriggerCommand.getScore(p_139155_.getServer().getScoreboard(), p_313736_, p_313848_);
        int $$5 = $$4.add(p_139157_);
        p_139155_.sendSuccess(() -> Component.translatable("commands.trigger.add.success", p_313848_.getFormattedDisplayName(), p_139157_), true);
        return $$5;
    }

    private static int setValue(CommandSourceStack p_139161_, ServerPlayer p_313837_, Objective p_313724_, int p_139163_) throws CommandSyntaxException {
        ScoreAccess $$4 = TriggerCommand.getScore(p_139161_.getServer().getScoreboard(), p_313837_, p_313724_);
        $$4.set(p_139163_);
        p_139161_.sendSuccess(() -> Component.translatable("commands.trigger.set.success", p_313724_.getFormattedDisplayName(), p_139163_), true);
        return p_139163_;
    }

    private static int simpleTrigger(CommandSourceStack p_139152_, ServerPlayer p_313865_, Objective p_313706_) throws CommandSyntaxException {
        ScoreAccess $$3 = TriggerCommand.getScore(p_139152_.getServer().getScoreboard(), p_313865_, p_313706_);
        int $$4 = $$3.add(1);
        p_139152_.sendSuccess(() -> Component.translatable("commands.trigger.simple.success", p_313706_.getFormattedDisplayName()), true);
        return $$4;
    }

    private static ScoreAccess getScore(Scoreboard p_313748_, ScoreHolder p_313873_, Objective p_139140_) throws CommandSyntaxException {
        if (p_139140_.getCriteria() != ObjectiveCriteria.TRIGGER) {
            throw ERROR_INVALID_OBJECTIVE.create();
        }
        ReadOnlyScoreInfo $$3 = p_313748_.getPlayerScoreInfo(p_313873_, p_139140_);
        if ($$3 == null || $$3.isLocked()) {
            throw ERROR_NOT_PRIMED.create();
        }
        ScoreAccess $$4 = p_313748_.getOrCreatePlayerScore(p_313873_, p_139140_);
        $$4.lock();
        return $$4;
    }
}

