/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.OptionalInt;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.phys.Vec3;

public interface ProjectileItem {
    public Projectile asProjectile(Level var1, Position var2, ItemStack var3, Direction var4);

    default public DispenseConfig createDispenseConfig() {
        return DispenseConfig.DEFAULT;
    }

    default public void shoot(Projectile p_338559_, double p_338418_, double p_338827_, double p_338653_, float p_338287_, float p_338314_) {
        p_338559_.shoot(p_338418_, p_338827_, p_338653_, p_338287_, p_338314_);
    }

    public record DispenseConfig(PositionFunction positionFunction, float uncertainty, float power, OptionalInt overrideDispenseEvent) {
        public static final DispenseConfig DEFAULT = DispenseConfig.builder().build();

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private PositionFunction positionFunction = (p_338429_, p_338348_) -> DispenserBlock.getDispensePosition(p_338429_, 0.7, new Vec3(0.0, 0.1, 0.0));
            private float uncertainty = 6.0f;
            private float power = 1.1f;
            private OptionalInt overrideDispenseEvent = OptionalInt.empty();

            public Builder positionFunction(PositionFunction p_338644_) {
                this.positionFunction = p_338644_;
                return this;
            }

            public Builder uncertainty(float p_338449_) {
                this.uncertainty = p_338449_;
                return this;
            }

            public Builder power(float p_338328_) {
                this.power = p_338328_;
                return this;
            }

            public Builder overrideDispenseEvent(int p_338272_) {
                this.overrideDispenseEvent = OptionalInt.of(p_338272_);
                return this;
            }

            public DispenseConfig build() {
                return new DispenseConfig(this.positionFunction, this.uncertainty, this.power, this.overrideDispenseEvent);
            }
        }
    }

    @FunctionalInterface
    public static interface PositionFunction {
        public Position getDispensePosition(BlockSource var1, Direction var2);
    }
}

