/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public record Tool(List<Rule> rules, float defaultMiningSpeed, int damagePerBlock) {
    public static final Codec<Tool> CODEC = RecordCodecBuilder.create(p_337953_ -> p_337953_.group((App)Rule.CODEC.listOf().fieldOf("rules").forGetter(Tool::rules), (App)Codec.FLOAT.optionalFieldOf("default_mining_speed", (Object)Float.valueOf(1.0f)).forGetter(Tool::defaultMiningSpeed), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("damage_per_block", (Object)1).forGetter(Tool::damagePerBlock)).apply((Applicative)p_337953_, Tool::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Tool> STREAM_CODEC = StreamCodec.composite(Rule.STREAM_CODEC.apply(ByteBufCodecs.list()), Tool::rules, ByteBufCodecs.FLOAT, Tool::defaultMiningSpeed, ByteBufCodecs.VAR_INT, Tool::damagePerBlock, Tool::new);

    public float getMiningSpeed(BlockState p_336131_) {
        for (Rule $$1 : this.rules) {
            if (!$$1.speed.isPresent() || !p_336131_.is($$1.blocks)) continue;
            return $$1.speed.get().floatValue();
        }
        return this.defaultMiningSpeed;
    }

    public boolean isCorrectForDrops(BlockState p_336189_) {
        for (Rule $$1 : this.rules) {
            if (!$$1.correctForDrops.isPresent() || !p_336189_.is($$1.blocks)) continue;
            return $$1.correctForDrops.get();
        }
        return false;
    }

    public record Rule(HolderSet<Block> blocks, Optional<Float> speed, Optional<Boolean> correctForDrops) {
        public static final Codec<Rule> CODEC = RecordCodecBuilder.create(p_337954_ -> p_337954_.group((App)RegistryCodecs.homogeneousList(Registries.BLOCK).fieldOf("blocks").forGetter(Rule::blocks), (App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("speed").forGetter(Rule::speed), (App)Codec.BOOL.optionalFieldOf("correct_for_drops").forGetter(Rule::correctForDrops)).apply((Applicative)p_337954_, Rule::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Rule> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.holderSet(Registries.BLOCK), Rule::blocks, ByteBufCodecs.FLOAT.apply(ByteBufCodecs::optional), Rule::speed, ByteBufCodecs.BOOL.apply(ByteBufCodecs::optional), Rule::correctForDrops, Rule::new);

        public static Rule minesAndDrops(List<Block> p_335413_, float p_335923_) {
            return Rule.forBlocks(p_335413_, Optional.of(Float.valueOf(p_335923_)), Optional.of(true));
        }

        public static Rule minesAndDrops(TagKey<Block> p_335441_, float p_336060_) {
            return Rule.forTag(p_335441_, Optional.of(Float.valueOf(p_336060_)), Optional.of(true));
        }

        public static Rule deniesDrops(TagKey<Block> p_335654_) {
            return Rule.forTag(p_335654_, Optional.empty(), Optional.of(false));
        }

        public static Rule overrideSpeed(TagKey<Block> p_335580_, float p_335857_) {
            return Rule.forTag(p_335580_, Optional.of(Float.valueOf(p_335857_)), Optional.empty());
        }

        public static Rule overrideSpeed(List<Block> p_335776_, float p_335593_) {
            return Rule.forBlocks(p_335776_, Optional.of(Float.valueOf(p_335593_)), Optional.empty());
        }

        private static Rule forTag(TagKey<Block> p_336036_, Optional<Float> p_335728_, Optional<Boolean> p_335781_) {
            return new Rule(BuiltInRegistries.BLOCK.getOrCreateTag(p_336036_), p_335728_, p_335781_);
        }

        private static Rule forBlocks(List<Block> p_335983_, Optional<Float> p_335694_, Optional<Boolean> p_335468_) {
            return new Rule(HolderSet.direct(p_335983_.stream().map(Block::builtInRegistryHolder).collect(Collectors.toList())), p_335694_, p_335468_);
        }
    }
}

