/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BaseCoralWallFanBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SeaPickleBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public abstract class CoralFeature
extends Feature<NoneFeatureConfiguration> {
    public CoralFeature(Codec<NoneFeatureConfiguration> p_65429_) {
        super(p_65429_);
    }

    @Override
    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> p_159536_) {
        RandomSource $$1 = p_159536_.random();
        WorldGenLevel $$2 = p_159536_.level();
        BlockPos $$3 = p_159536_.origin();
        Optional<Block> $$4 = BuiltInRegistries.BLOCK.getRandomElementOf(BlockTags.CORAL_BLOCKS, $$1).map(Holder::value);
        if ($$4.isEmpty()) {
            return false;
        }
        return this.placeFeature($$2, $$1, $$3, $$4.get().defaultBlockState());
    }

    protected abstract boolean placeFeature(LevelAccessor var1, RandomSource var2, BlockPos var3, BlockState var4);

    protected boolean placeCoralBlock(LevelAccessor p_224974_, RandomSource p_224975_, BlockPos p_224976_, BlockState p_224977_) {
        BlockPos $$4 = p_224976_.above();
        BlockState $$5 = p_224974_.getBlockState(p_224976_);
        if (!$$5.is(Blocks.WATER) && !$$5.is(BlockTags.CORALS) || !p_224974_.getBlockState($$4).is(Blocks.WATER)) {
            return false;
        }
        p_224974_.setBlock(p_224976_, p_224977_, 3);
        if (p_224975_.nextFloat() < 0.25f) {
            BuiltInRegistries.BLOCK.getRandomElementOf(BlockTags.CORALS, p_224975_).map(Holder::value).ifPresent(p_204720_ -> p_224974_.setBlock($$4, p_204720_.defaultBlockState(), 2));
        } else if (p_224975_.nextFloat() < 0.05f) {
            p_224974_.setBlock($$4, (BlockState)Blocks.SEA_PICKLE.defaultBlockState().setValue(SeaPickleBlock.PICKLES, p_224975_.nextInt(4) + 1), 2);
        }
        for (Direction $$6 : Direction.Plane.HORIZONTAL) {
            BlockPos $$7;
            if (!(p_224975_.nextFloat() < 0.2f) || !p_224974_.getBlockState($$7 = p_224976_.relative($$6)).is(Blocks.WATER)) continue;
            BuiltInRegistries.BLOCK.getRandomElementOf(BlockTags.WALL_CORALS, p_224975_).map(Holder::value).ifPresent(p_204725_ -> {
                BlockState $$4 = p_204725_.defaultBlockState();
                if ($$4.hasProperty(BaseCoralWallFanBlock.FACING)) {
                    $$4 = (BlockState)$$4.setValue(BaseCoralWallFanBlock.FACING, $$6);
                }
                p_224974_.setBlock($$7, $$4, 2);
            });
        }
        return true;
    }
}

