/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class EnvironmentScanPlacement
extends PlacementModifier {
    private final Direction directionOfSearch;
    private final BlockPredicate targetCondition;
    private final BlockPredicate allowedSearchCondition;
    private final int maxSteps;
    public static final MapCodec<EnvironmentScanPlacement> CODEC = RecordCodecBuilder.mapCodec(p_191650_ -> p_191650_.group((App)Direction.VERTICAL_CODEC.fieldOf("direction_of_search").forGetter(p_191672_ -> p_191672_.directionOfSearch), (App)BlockPredicate.CODEC.fieldOf("target_condition").forGetter(p_191670_ -> p_191670_.targetCondition), (App)BlockPredicate.CODEC.optionalFieldOf("allowed_search_condition", (Object)BlockPredicate.alwaysTrue()).forGetter(p_191668_ -> p_191668_.allowedSearchCondition), (App)Codec.intRange((int)1, (int)32).fieldOf("max_steps").forGetter(p_191652_ -> p_191652_.maxSteps)).apply((Applicative)p_191650_, EnvironmentScanPlacement::new));

    private EnvironmentScanPlacement(Direction p_191645_, BlockPredicate p_191646_, BlockPredicate p_191647_, int p_191648_) {
        this.directionOfSearch = p_191645_;
        this.targetCondition = p_191646_;
        this.allowedSearchCondition = p_191647_;
        this.maxSteps = p_191648_;
    }

    public static EnvironmentScanPlacement scanningFor(Direction p_191658_, BlockPredicate p_191659_, BlockPredicate p_191660_, int p_191661_) {
        return new EnvironmentScanPlacement(p_191658_, p_191659_, p_191660_, p_191661_);
    }

    public static EnvironmentScanPlacement scanningFor(Direction p_191654_, BlockPredicate p_191655_, int p_191656_) {
        return EnvironmentScanPlacement.scanningFor(p_191654_, p_191655_, BlockPredicate.alwaysTrue(), p_191656_);
    }

    @Override
    public Stream<BlockPos> getPositions(PlacementContext p_226336_, RandomSource p_226337_, BlockPos p_226338_) {
        BlockPos.MutableBlockPos $$3 = p_226338_.mutable();
        WorldGenLevel $$4 = p_226336_.getLevel();
        if (!this.allowedSearchCondition.test($$4, $$3)) {
            return Stream.of(new BlockPos[0]);
        }
        for (int $$5 = 0; $$5 < this.maxSteps; ++$$5) {
            if (this.targetCondition.test($$4, $$3)) {
                return Stream.of($$3);
            }
            $$3.move(this.directionOfSearch);
            if ($$4.isOutsideBuildHeight($$3.getY())) {
                return Stream.of(new BlockPos[0]);
            }
            if (!this.allowedSearchCondition.test($$4, $$3)) break;
        }
        if (this.targetCondition.test($$4, $$3)) {
            return Stream.of($$3);
        }
        return Stream.of(new BlockPos[0]);
    }

    @Override
    public PlacementModifierType<?> type() {
        return PlacementModifierType.ENVIRONMENT_SCAN;
    }
}

