/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.specialsource.provider;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import net.md_5.specialsource.provider.InheritanceProvider;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

public class ClassLoaderProvider
implements InheritanceProvider {
    private final ClassLoader classLoader;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<String> getParents(String owner) {
        String ownerInternalName = owner.replace('.', '/').concat(".class");
        try (InputStream input = this.classLoader.getResourceAsStream(ownerInternalName);){
            if (input == null) {
                Collection<String> collection = null;
                return collection;
            }
            ClassReader cr = new ClassReader(input);
            ClassNode node = new ClassNode();
            cr.accept((ClassVisitor)node, 0);
            HashSet<String> parents = new HashSet<String>();
            for (String iface : node.interfaces) {
                parents.add(iface);
            }
            if (node.superName != null) {
                parents.add(node.superName);
            }
            HashSet<String> hashSet = parents;
            return hashSet;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ClassLoaderProvider(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

