/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.api.parsers;

import com.google.common.collect.ImmutableList;
import eu.pb4.placeholders.api.arguments.StringArgs;
import eu.pb4.placeholders.api.node.EmptyNode;
import eu.pb4.placeholders.api.node.LiteralNode;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.node.parent.ParentNode;
import eu.pb4.placeholders.api.node.parent.ParentTextNode;
import eu.pb4.placeholders.api.parsers.NodeParser;
import eu.pb4.placeholders.impl.GeneralUtils;
import eu.pb4.placeholders.impl.textparser.TextParserImpl;
import eu.pb4.placeholders.impl.textparser.TextTagsV1;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

@Deprecated(forRemoval=true)
public class TextParserV1
implements NodeParser {
    public static final TextParserV1 DEFAULT = new TextParserV1();
    public static final TextParserV1 SAFE = new TextParserV1();
    private boolean allowOverrides = false;
    private final List<TextTag> tags = new ArrayList<TextTag>();
    private final Map<String, TextTag> byName = new HashMap<String, TextTag>();
    private final Map<String, TextTag> byNameAlias = new HashMap<String, TextTag>();

    public static TextParserV1 createDefault() {
        return DEFAULT.copy();
    }

    public static TextParserV1 createSafe() {
        return SAFE.copy();
    }

    public static void registerDefault(TextTag tag) {
        DEFAULT.register(tag);
        if (tag.userSafe()) {
            SAFE.register(tag);
        }
    }

    public void register(TextTag tag) {
        if (this.byName.containsKey(tag.name())) {
            if (this.allowOverrides) {
                this.tags.removeIf(t -> t.name().equals(tag.name()));
            } else {
                throw new RuntimeException("Duplicate tag identifier!");
            }
        }
        this.byName.put(tag.name(), tag);
        this.tags.add(tag);
        this.byNameAlias.put(tag.name(), tag);
        if (tag.aliases() != null) {
            for (int i = 0; i < tag.aliases().length; ++i) {
                String alias = tag.aliases()[i];
                TextTag old = this.byNameAlias.get(alias);
                if (old != null && old.name().equals(alias)) continue;
                this.byNameAlias.put(alias, tag);
            }
        }
    }

    public List<TextTag> getTags() {
        return ImmutableList.copyOf(this.tags);
    }

    @Override
    public TextNode[] parseNodes(TextNode input) {
        return TextParserV1.parseNodesWith(input, this::getTagParser);
    }

    public TextParserV1 copy() {
        TextParserV1 parser = new TextParserV1();
        for (TextTag tag : this.tags) {
            parser.register(tag);
        }
        return parser;
    }

    public static TextNode[] parseNodesWith(TextNode input, TagParserGetter getter) {
        if (input instanceof LiteralNode) {
            LiteralNode literalNode = (LiteralNode)input;
            return TextParserImpl.parse(literalNode.value(), getter);
        }
        if (input instanceof ParentTextNode) {
            ParentTextNode parentTextNode = (ParentTextNode)input;
            ArrayList<ParentNode> list = new ArrayList<ParentNode>();
            for (TextNode child : parentTextNode.getChildren()) {
                list.add(new ParentNode(TextParserV1.parseNodesWith(child, getter)));
            }
            return list.toArray(new TextNode[0]);
        }
        return new TextNode[]{input};
    }

    public static NodeList parseNodesWith(String input, TagParserGetter handlers, @Nullable String endingTag) {
        return TextParserImpl.recursiveParsing(input, handlers, endingTag);
    }

    @Nullable
    public TagNodeBuilder getTagParser(String name) {
        TextTag o = this.byNameAlias.get(name);
        return o != null ? o.parser() : null;
    }

    @Nullable
    public TextTag getTag(String name) {
        TextTag o = this.byNameAlias.get(name);
        return o;
    }

    static {
        TextTagsV1.register();
    }

    public record TextTag(String name, String[] aliases, String type, boolean userSafe, TagNodeBuilder parser) {
        public static TextTag of(String name, String type, TagNodeBuilder parser) {
            return TextTag.of(name, type, true, parser);
        }

        public static TextTag of(String name, String type, boolean userSafe, TagNodeBuilder parser) {
            return TextTag.of(name, List.of(), type, userSafe, parser);
        }

        public static TextTag of(String name, List<String> aliases, String type, boolean userSafe, TagNodeBuilder parser) {
            return new TextTag(name, aliases.toArray(new String[0]), type, userSafe, parser);
        }

        public static TextTag from(eu.pb4.placeholders.api.parsers.tag.TextTag tag) {
            return new TextTag(tag.name(), tag.aliases(), tag.type(), tag.userSafe(), tag.selfContained() ? TagNodeBuilder.selfClosing((a, b) -> tag.nodeCreator().createTextNode(GeneralUtils.CASTER, StringArgs.ordered(a, ':'), b)) : TagNodeBuilder.wrapping((a, b, c) -> tag.nodeCreator().createTextNode(a, StringArgs.ordered(b, ':'), c)));
        }
    }

    @FunctionalInterface
    public static interface TagParserGetter {
        @Nullable
        public TagNodeBuilder getTagParser(String var1);
    }

    public record NodeList(TextNode[] nodes, int length) {
        public static final NodeList EMPTY = new NodeList(new TextNode[0], 0);

        public TagNodeValue value(TextNode node) {
            return new TagNodeValue(node, this.length);
        }

        public TagNodeValue value(Function<TextNode[], TextNode> function) {
            return new TagNodeValue(function.apply(this.nodes), this.length);
        }
    }

    @FunctionalInterface
    public static interface TagNodeBuilder {
        public TagNodeValue parseString(String var1, String var2, String var3, TagParserGetter var4, String var5);

        public static TagNodeBuilder selfClosing(SelfTagParsedCreator selfTagCreator) {
            return (tag, data, input, handlers, endAt) -> new TagNodeValue(selfTagCreator.createTextNode(data, new TagParserGetterParser(handlers)), 0);
        }

        public static TagNodeBuilder wrapping(FormattingTagParsedCreator formattingTagCreator) {
            return (tag, data, input, handlers, endAt) -> {
                NodeList out = TextParserV1.parseNodesWith(input, handlers, endAt);
                return new TagNodeValue(formattingTagCreator.createTextNode(out.nodes(), data, new TagParserGetterParser(handlers)), out.length());
            };
        }

        public static TagNodeBuilder selfClosing(SelfTagCreator selfTagCreator) {
            return (tag, data, input, handlers, endAt) -> new TagNodeValue(selfTagCreator.createTextNode(data), 0);
        }

        public static TagNodeBuilder wrapping(FormattingTagCreator formattingTagCreator) {
            return (tag, data, input, handlers, endAt) -> {
                NodeList out = TextParserV1.parseNodesWith(input, handlers, endAt);
                return new TagNodeValue(formattingTagCreator.createTextNode(out.nodes(), data), out.length());
            };
        }

        public static TagNodeBuilder wrappingBoolean(BooleanFormattingTagCreator formattingTagCreator) {
            return (tag, data, input, handlers, endAt) -> {
                NodeList out = TextParserV1.parseNodesWith(input, handlers, endAt);
                return new TagNodeValue(formattingTagCreator.createTextNode(out.nodes(), data == null || data.isEmpty() || !data.equals("false")), out.length());
            };
        }

        public static interface SelfTagParsedCreator {
            public TextNode createTextNode(String var1, NodeParser var2);
        }

        public static interface FormattingTagParsedCreator {
            public TextNode createTextNode(TextNode[] var1, String var2, NodeParser var3);
        }

        public static interface SelfTagCreator {
            public TextNode createTextNode(String var1);
        }

        public static interface FormattingTagCreator {
            public TextNode createTextNode(TextNode[] var1, String var2);
        }

        public static interface BooleanFormattingTagCreator {
            public TextNode createTextNode(TextNode[] var1, boolean var2);
        }
    }

    private record TagParserGetterParser(TagParserGetter getter) implements NodeParser
    {
        @Override
        public TextNode[] parseNodes(TextNode input) {
            return TextParserV1.parseNodesWith(input, this.getter);
        }
    }

    public record TagNodeValue(TextNode node, int length) {
        public static final TagNodeValue EMPTY = new TagNodeValue(EmptyNode.INSTANCE, 0);
    }
}

