/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.client.uncapvd.common;

import com.ishland.c2me.base.common.network.ExtRenderDistance;
import com.ishland.c2me.client.uncapvd.common.Config;
import java.util.function.BooleanSupplier;
import net.fabricmc.fabric.api.client.networking.v1.C2SPlayChannelEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_310;
import net.minecraft.class_8710;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientExtNetworking {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"C2ME ClientExtNetworking");

    public static void sendViewDistance(int viewDistance) {
        if (!class_310.method_1551().method_18854()) {
            new IllegalStateException("Tried to send packet not on client thread!").printStackTrace();
            return;
        }
        if (ClientExtNetworking.catchExceptions(() -> ClientPlayNetworking.canSend((class_8710.class_9154)ExtRenderDistance.ID))) {
            LOGGER.info("Changing view distance to {} (play stage)", (Object)viewDistance);
            ClientPlayNetworking.send((class_8710)new ExtRenderDistance(viewDistance));
            return;
        }
        if (ClientExtNetworking.catchExceptions(() -> ClientConfigurationNetworking.canSend((class_8710.class_9154)ExtRenderDistance.ID))) {
            LOGGER.info("Changing view distance to {} (config stage)", (Object)viewDistance);
            ClientConfigurationNetworking.send((class_8710)new ExtRenderDistance(viewDistance));
            return;
        }
    }

    private static boolean catchExceptions(BooleanSupplier supplier) {
        try {
            return supplier.getAsBoolean();
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public static void registerListeners() {
        ExtRenderDistance.init();
        C2SPlayChannelEvents.REGISTER.register((handler, sender, client, channels) -> {
            if (channels.contains(ExtRenderDistance.ID.comp_2242())) {
                if (Config.enableExtRenderDistanceProtocol) {
                    LOGGER.info("Joined server with {} support", (Object)ExtRenderDistance.ID.comp_2242());
                    class_310.method_1551().execute(() -> class_310.method_1551().field_1690.method_1643());
                } else {
                    LOGGER.info("Server supports {} but it is disabled in config", (Object)ExtRenderDistance.ID.comp_2242());
                }
            }
        });
    }
}

