/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.lib.tinyremapper.extension.mixin.soft.annotation;

import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.loader.impl.lib.tinyremapper.extension.mixin.common.data.CommonData;
import net.fabricmc.loader.impl.lib.tinyremapper.extension.mixin.common.data.MxMember;
import net.fabricmc.loader.impl.lib.tinyremapper.extension.mixin.soft.annotation.FirstPassAnnotationVisitor;
import net.fabricmc.loader.impl.lib.tinyremapper.extension.mixin.soft.util.NamedMappable;
import org.objectweb.asm.AnnotationVisitor;

public class AccessorAnnotationVisitor
extends FirstPassAnnotationVisitor {
    private final CommonData data;
    private final AnnotationVisitor delegate;
    private final MxMember method;
    private final List<String> targets;

    public AccessorAnnotationVisitor(CommonData data, AnnotationVisitor delegate, MxMember method, boolean remap, List<String> targets) {
        super("Lorg/spongepowered/asm/mixin/gen/Accessor;", remap);
        this.data = Objects.requireNonNull(data);
        this.delegate = Objects.requireNonNull(delegate);
        this.method = Objects.requireNonNull(method);
        this.targets = Objects.requireNonNull(targets);
    }

    public void visitEnd() {
        if (this.remap) {
            this.accept(new AccessorSecondPassAnnotationVisitor(this.data, this.delegate, this.method, this.targets));
        } else {
            this.accept(this.delegate);
        }
        super.visitEnd();
    }

    private static class AccessorSecondPassAnnotationVisitor
    extends AnnotationVisitor {
        private final CommonData data;
        private final List<String> targets;
        private final String fieldDesc;
        private static final Pattern GETTER_PATTERN = Pattern.compile("(?<=\\(\\)).*");
        private static final Pattern SETTER_PATTERN = Pattern.compile("(?<=\\().*(?=\\)V)");

        AccessorSecondPassAnnotationVisitor(CommonData data, AnnotationVisitor delegate, MxMember method, List<String> targets) {
            super(589824, delegate);
            this.data = Objects.requireNonNull(data);
            this.targets = Objects.requireNonNull(targets);
            Matcher getterMatcher = GETTER_PATTERN.matcher(method.getDesc());
            Matcher setterMatcher = SETTER_PATTERN.matcher(method.getDesc());
            if (getterMatcher.find()) {
                this.fieldDesc = getterMatcher.group();
            } else if (setterMatcher.find()) {
                this.fieldDesc = setterMatcher.group();
            } else {
                throw new RuntimeException(method.getDesc() + " is not getter or setter");
            }
        }

        public void visit(String name, Object value) {
            if (name.equals("value")) {
                String fieldName = Objects.requireNonNull((String)value);
                value = new NamedMappable(this.data, fieldName, this.fieldDesc, this.targets).result();
            }
            super.visit(name, value);
        }
    }
}

