/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading;

import cpw.mods.jarhandling.JarContents;
import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.SecureJar;
import cpw.mods.modlauncher.api.ITransformationService;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import net.neoforged.neoforgespi.earlywindow.GraphicsBootstrapper;
import net.neoforged.neoforgespi.earlywindow.ImmediateWindowProvider;
import net.neoforged.neoforgespi.locating.IDependencyLocator;
import net.neoforged.neoforgespi.locating.IModFileCandidateLocator;
import net.neoforged.neoforgespi.locating.IModFileReader;

public final class TransformerDiscovererConstants {
    public static final Set<String> SERVICES = Set.of(ITransformationService.class.getName(), IModFileCandidateLocator.class.getName(), IModFileReader.class.getName(), IDependencyLocator.class.getName(), GraphicsBootstrapper.class.getName(), ImmediateWindowProvider.class.getName());

    private TransformerDiscovererConstants() {
    }

    public static boolean shouldLoadInServiceLayer(Collection<Path> paths) {
        return TransformerDiscovererConstants.shouldLoadInServiceLayer(JarContents.of(paths));
    }

    public static boolean shouldLoadInServiceLayer(Path path) {
        return TransformerDiscovererConstants.shouldLoadInServiceLayer(JarContents.of((Path)path));
    }

    public static boolean shouldLoadInServiceLayer(JarContents jarContents) {
        JarMetadata metadata = JarMetadata.from((JarContents)jarContents);
        return metadata.providers().stream().map(SecureJar.Provider::serviceName).anyMatch(SERVICES::contains);
    }
}

