/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.image.impl;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.isxander.yacl3.gui.image.ImageRenderer;
import dev.isxander.yacl3.gui.image.ImageRendererFactory;
import dev.isxander.yacl3.gui.utils.GuiUtils;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class DynamicTextureImage
implements ImageRenderer {
    protected static final class_1060 textureManager = class_310.method_1551().method_1531();
    protected class_1011 image;
    protected class_1043 texture;
    protected final class_2960 uniqueLocation;
    protected final int width;
    protected final int height;
    protected final boolean textureFiltering;

    public DynamicTextureImage(class_1011 image, class_2960 location, boolean textureFiltering) {
        RenderSystem.assertOnRenderThread();
        this.image = image;
        this.texture = new class_1043(() -> ((class_2960)location).toString(), image);
        this.textureFiltering = textureFiltering;
        this.uniqueLocation = location;
        textureManager.method_4616(this.uniqueLocation, (class_1044)this.texture);
        this.width = image.method_4307();
        this.height = image.method_4323();
    }

    @Override
    public int render(class_332 graphics, int x, int y, int renderWidth, float tickDelta) {
        if (this.image == null) {
            return 0;
        }
        float ratio = (float)renderWidth / (float)this.width;
        int targetHeight = (int)((float)this.height * ratio);
        GuiUtils.pushPose(graphics);
        GuiUtils.translate2D(graphics, x, y);
        GuiUtils.scale2D(graphics, ratio, ratio);
        GuiUtils.blitGuiTex(graphics, this.uniqueLocation, 0, 0, 0.0f, 0.0f, this.width, this.height, this.width, this.height, this.textureFiltering);
        GuiUtils.popPose(graphics);
        return targetHeight;
    }

    @Override
    public void close() {
        this.image.close();
        this.image = null;
        this.texture = null;
        textureManager.method_4615(this.uniqueLocation);
    }

    public static ImageRendererFactory fromPath(Path imagePath, class_2960 location, boolean textureFiltering) {
        return () -> () -> new DynamicTextureImage(class_1011.method_4309((InputStream)new FileInputStream(imagePath.toFile())), location, textureFiltering);
    }
}

