/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.engine.source;

import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.echo.GuardianEntityLightSource;
import dev.lambdaurora.lambdynlights.engine.DynamicLightingEngine;
import dev.lambdaurora.lambdynlights.engine.scheduler.ChunkRebuildStatus;
import dev.lambdaurora.lambdynlights.engine.source.DynamicLightSource;
import dev.lambdaurora.lambdynlights.engine.source.EntityDynamicLightSource;
import it.unimi.dsi.fastutil.longs.Long2ObjectArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.class_1297;
import net.minecraft.class_1577;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public interface EntityDynamicLightSourceBehavior
extends EntityDynamicLightSource {
    public double getDynamicLightPrevX();

    public double getDynamicLightPrevY();

    public double getDynamicLightPrevZ();

    public void updateDynamicLightPreviousCoordinates();

    public void setLuminance(int var1);

    public int getLastDynamicLuminance();

    public void setLastDynamicLuminance(int var1);

    @ApiStatus.Internal
    default public void setDynamicLightEnabled(boolean enabled) {
        this.resetDynamicLight();
        if (enabled) {
            LambDynLights.get().addLightSource(this);
        } else {
            LambDynLights.get().removeLightSource(this);
        }
    }

    public static void tickEntity(class_1297 entity) {
        EntityDynamicLightSourceBehavior lightSource = (EntityDynamicLightSourceBehavior)entity;
        if (!LambDynLights.get().shouldTick(lightSource)) {
            return;
        }
        if (entity.method_31481()) {
            lightSource.setDynamicLightEnabled(false);
        } else {
            if (DynamicLightingEngine.canLightUp(entity)) {
                lightSource.dynamicLightTick();
            } else {
                lightSource.setLuminance(0);
            }
            LambDynLights.updateTracking(lightSource);
        }
        if (entity instanceof class_1577) {
            class_1577 guardian = (class_1577)entity;
            GuardianEntityLightSource.tick(guardian);
        }
    }

    @Override
    default public Long2ObjectMap<ChunkRebuildStatus> getDynamicLightChunksToRebuild(boolean forced) {
        double x = this.getDynamicLightX();
        double y = this.getDynamicLightY();
        double z = this.getDynamicLightZ();
        double deltaX = x - this.getDynamicLightPrevX();
        double deltaY = y - this.getDynamicLightPrevY();
        double deltaZ = z - this.getDynamicLightPrevZ();
        int luminance = this.getLuminance();
        if (!forced && Math.abs(deltaX) <= 0.1 && Math.abs(deltaY) <= 0.1 && Math.abs(deltaZ) <= 0.1 && luminance == this.getLastDynamicLuminance()) {
            return Long2ObjectMaps.emptyMap();
        }
        LongOpenHashSet newPos = new LongOpenHashSet();
        if (luminance > 0) {
            DynamicLightSource.gatherClosestChunks(x, y, z, arg_0 -> ((LongOpenHashSet)newPos).add(arg_0));
        }
        Long2ObjectArrayMap result = new Long2ObjectArrayMap(8);
        this.lambdynlights$getTrackedLitChunkPos().forEach(chunk -> result.put(chunk, (Object)ChunkRebuildStatus.REMOVE_REQUESTED));
        newPos.forEach(chunk -> result.put(chunk, (Object)ChunkRebuildStatus.REQUESTED));
        this.updateDynamicLightPreviousCoordinates();
        this.setLastDynamicLuminance(luminance);
        this.lambdynlights$setTrackedLitChunkPos((LongSet)newPos);
        return result;
    }

    public LongSet lambdynlights$getTrackedLitChunkPos();

    public void lambdynlights$setTrackedLitChunkPos(LongSet var1);
}

