/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.gui;

import dev.lambdaurora.lambdynlights.DynamicLightsConfig;
import dev.lambdaurora.lambdynlights.ExplosiveLightingMode;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.LambDynLightsConstants;
import dev.lambdaurora.lambdynlights.accessor.DynamicLightHandlerHolder;
import dev.lambdaurora.lambdynlights.gui.LightSourceListWidget;
import dev.lambdaurora.lambdynlights.gui.RandomPrideFlagBackground;
import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.SprucePositioned;
import dev.lambdaurora.spruceui.SpruceTextAlignment;
import dev.lambdaurora.spruceui.SpruceTexts;
import dev.lambdaurora.spruceui.option.SpruceCyclingOption;
import dev.lambdaurora.spruceui.option.SpruceOption;
import dev.lambdaurora.spruceui.option.SpruceSimpleActionOption;
import dev.lambdaurora.spruceui.screen.SpruceScreen;
import dev.lambdaurora.spruceui.widget.SpruceButtonWidget;
import dev.lambdaurora.spruceui.widget.SpruceLabelWidget;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import dev.lambdaurora.spruceui.widget.container.SpruceContainerWidget;
import dev.lambdaurora.spruceui.widget.container.SpruceOptionListWidget;
import dev.lambdaurora.spruceui.widget.container.SpruceParentWidget;
import dev.lambdaurora.spruceui.widget.container.tabbed.SpruceTabbedWidget;
import dev.lambdaurora.spruceui.widget.text.SpruceTextFieldWidget;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7923;
import org.jspecify.annotations.Nullable;

public class SettingsScreen
extends SpruceScreen {
    public static final class_2561 MOD_NAME = class_2561.method_43471((String)"lambdynlights");
    public static final class_2561 TITLE = class_2561.method_43469((String)"lambdynlights.menu.title", (Object[])new Object[]{MOD_NAME});
    private static final class_2561 VERSION;
    private static final String DYNAMIC_LIGHT_SOURCES_KEY = "lambdynlights.menu.light_sources";
    private static final String SPECIAL_DYNAMIC_LIGHT_SOURCES_KEY = "lambdynlights.menu.light_sources.special";
    private final DynamicLightsConfig config;
    private final @Nullable class_437 parent;
    private final SpruceOption entitiesOption;
    private final SpruceOption selfOption;
    private final SpruceOption waterSensitiveOption;
    private final SpruceOption creeperLightingOption;
    private final SpruceOption tntLightingOption;
    private final SpruceOption debugCellDisplayRadiusOption;
    private final SpruceOption debugLightLevelRadiusOption;
    private final SpruceOption resetOption;
    private @Nullable SpruceTabbedWidget tabbedWidget;
    private @Nullable SpruceTextFieldWidget searchInput;

    public SettingsScreen(@Nullable class_437 parent) {
        super(TITLE);
        this.parent = parent;
        this.config = LambDynLights.get().config;
        this.entitiesOption = this.config.getEntitiesLightSource().getOption();
        this.selfOption = this.config.getSelfLightSource().getOption();
        this.waterSensitiveOption = this.config.getWaterSensitiveCheck().getOption();
        this.creeperLightingOption = ((SpruceCyclingOption.Builder)SpruceOption.cyclingBuilder((String)"entity.minecraft.creeper", amount -> this.config.setCreeperLightingMode(this.config.getCreeperLightingMode().next()), option -> option.getDisplayText(this.config.getCreeperLightingMode().getTranslatedText())).tooltip((class_2561)class_2561.method_43469((String)"lambdynlights.tooltip.creeper_lighting", (Object[])new Object[]{ExplosiveLightingMode.OFF.getTranslatedText(), ExplosiveLightingMode.SIMPLE.getTranslatedText(), ExplosiveLightingMode.FANCY.getTranslatedText()}))).build();
        this.tntLightingOption = ((SpruceCyclingOption.Builder)SpruceOption.cyclingBuilder((String)"block.minecraft.tnt", amount -> this.config.setTntLightingMode(this.config.getTntLightingMode().next()), option -> option.getDisplayText(this.config.getTntLightingMode().getTranslatedText())).tooltip((class_2561)class_2561.method_43469((String)"lambdynlights.tooltip.tnt_lighting", (Object[])new Object[]{ExplosiveLightingMode.OFF.getTranslatedText(), ExplosiveLightingMode.SIMPLE.getTranslatedText(), ExplosiveLightingMode.FANCY.getTranslatedText()}))).build();
        this.debugCellDisplayRadiusOption = SpruceOption.doubleBuilder((String)"lambdynlights.option.debug.cell_display_radius", (double)0.0, (double)10.0, (float)1.0f, () -> this.config.getDebugCellDisplayRadius(), value -> this.config.setDebugCellDisplayRadius(value.intValue()), option -> option.getDisplayText((class_2561)(option.get() <= 0.0 ? SpruceTexts.OPTIONS_OFF.method_27661().method_27692(class_124.field_1061) : class_2561.method_43470((String)String.format("%.0f", option.get()))))).build();
        this.debugLightLevelRadiusOption = SpruceOption.doubleBuilder((String)"lambdynlights.option.debug.light_level_radius", (double)0.0, (double)10.0, (float)1.0f, () -> this.config.getDebugLightLevelRadius(), value -> this.config.setDebugLightLevelRadius(value.intValue()), option -> option.getDisplayText((class_2561)(option.get() <= 0.0 ? SpruceTexts.OPTIONS_OFF.method_27661().method_27692(class_124.field_1061) : class_2561.method_43470((String)String.format("%.0f", option.get()))))).build();
        this.resetOption = SpruceSimpleActionOption.reset(btn -> {
            this.config.reset();
            class_310 client = class_310.method_1551();
            this.method_25423(client.method_22683().method_4486(), client.method_22683().method_4502());
        });
    }

    public void method_25432() {
        super.method_25432();
        this.config.save();
    }

    protected void method_25426() {
        Object e;
        super.method_25426();
        int tabIndex = 0;
        if (this.tabbedWidget != null) {
            SpruceTabbedWidget.TabEntry oldEntry = this.tabbedWidget.getList().getCurrentTab();
            tabIndex = this.tabbedWidget.getList().children().indexOf(oldEntry);
        }
        this.tabbedWidget = new SpruceTabbedWidget(Position.origin(), this.field_22789, this.field_22790 - 40, (class_2561)this.field_22785.method_27661(), Math.max(100, this.field_22789 / 8));
        this.tabbedWidget.getList().setBackground(RandomPrideFlagBackground.random());
        this.tabbedWidget.addTabEntry((class_2561)class_2561.method_43471((String)"lambdynlights.menu.tabs.general"), null, this.tabContainerBuilder(this::buildGeneralTab));
        this.tabbedWidget.addTabEntry((class_2561)class_2561.method_43471((String)"lambdynlights.menu.tabs.performance"), null, this.tabContainerBuilder(this::buildPerformanceTab));
        this.tabbedWidget.addSeparatorEntry((class_2561)class_2561.method_43471((String)DYNAMIC_LIGHT_SOURCES_KEY));
        this.tabbedWidget.addTabEntry(this.entitiesOption.getPrefix(), null, this.tabContainerBuilder(this::buildEntitiesTab));
        this.tabbedWidget.addTabEntry((class_2561)class_2561.method_43471((String)"lambdynlights.menu.tabs.dynamic_lights.special"), null, this.tabContainerBuilder(this::buildSpecialTab));
        this.tabbedWidget.addSeparatorEntry((class_2561)class_2561.method_43471((String)"lambdynlights.menu.tabs.advanced"));
        this.tabbedWidget.addTabEntry((class_2561)class_2561.method_43471((String)"lambdynlights.menu.tabs.debug"), (class_2561)class_2561.method_43471((String)"lambdynlights.menu.tabs.debug.description").method_27692(class_124.field_1080), this.tabContainerBuilder(this::buildDebugTab));
        this.method_37063((class_364)this.tabbedWidget);
        int tabsWidth = this.tabbedWidget.getList().getWidth();
        Position resetButtonPos = Position.of((SprucePositioned)this, (int)(tabsWidth + (this.field_22789 - tabsWidth) / 2 - 155), (int)(this.field_22790 - 29));
        SpruceButtonWidget supportMeButton = new SpruceButtonWidget(Position.of((SprucePositioned)this, (int)4, (int)resetButtonPos.getRelativeY()), tabsWidth - 8, 20, (class_2561)class_2561.method_43471((String)"lambdynlights.menu.support_me"), btn -> class_156.method_668().method_670("https://donate.lambdaurora.dev/"));
        supportMeButton.setTooltip((class_2561)class_2561.method_43471((String)"lambdynlights.menu.support_me.tooltip"));
        this.method_37063((class_364)supportMeButton);
        this.method_37063((class_364)this.resetOption.createWidget(resetButtonPos, 150));
        Position doneButtonPos = resetButtonPos.copy();
        doneButtonPos.setRelativeX(doneButtonPos.getRelativeX() + 160);
        this.method_37063((class_364)new SpruceButtonWidget(doneButtonPos, 150, 20, SpruceTexts.GUI_DONE, btn -> this.field_22787.method_1507(this.parent)));
        if (tabIndex > 0 && (e = this.tabbedWidget.getList().children().get(tabIndex)) instanceof SpruceTabbedWidget.TabEntry) {
            SpruceTabbedWidget.TabEntry tabEntry = (SpruceTabbedWidget.TabEntry)e;
            this.tabbedWidget.getList().setSelected(tabEntry);
        }
    }

    private SpruceTabbedWidget.ContainerFactory tabContainerBuilder(Consumer<TabContext> innerFactory) {
        return (width, height) -> this.buildTabContainer(width, height, innerFactory);
    }

    private SpruceContainerWidget buildTabContainer(int width, int height, Consumer<TabContext> tabConsumer) {
        SpruceContainerWidget container = new SpruceContainerWidget(Position.origin(), width, height);
        tabConsumer.accept(new TabContext(Objects.requireNonNull(this.tabbedWidget), container, height - this.tabbedWidget.getList().getPosition().getRelativeY()));
        return container;
    }

    private void buildGeneralTab(TabContext context) {
        context.addVersionLabel();
        SpruceOptionListWidget list = new SpruceOptionListWidget(Position.origin(), context.width(), context.height());
        list.addSingleOptionEntry(this.config.dynamicLightsModeOption);
        list.addOptionEntry(this.entitiesOption, this.selfOption);
        list.addSingleOptionEntry(this.waterSensitiveOption);
        context.addInnerWidget((SpruceParentWidget<?>)list);
    }

    private void buildPerformanceTab(TabContext context) {
        context.addVersionLabel();
        SpruceOptionListWidget list = new SpruceOptionListWidget(Position.origin(), context.width(), context.height());
        list.addSingleOptionEntry(this.config.chunkRebuildSchedulerOption);
        list.addSingleOptionEntry((SpruceOption)this.config.slowTickingOption);
        list.addSingleOptionEntry((SpruceOption)this.config.slowerTickingOption);
        list.addSingleOptionEntry(this.config.getBackgroundAdaptiveTicking().getOption());
        context.addInnerWidget((SpruceParentWidget<?>)list);
    }

    private void buildDebugTab(TabContext context) {
        context.addVersionLabel();
        SpruceOptionListWidget list = new SpruceOptionListWidget(Position.origin(), context.width(), context.height());
        list.addSingleOptionEntry(this.config.getDebugActiveDynamicLightingCells().getOption());
        list.addSingleOptionEntry(this.debugCellDisplayRadiusOption);
        list.addSingleOptionEntry(this.config.getDebugDisplayDynamicLightingChunkRebuilds().getOption());
        list.addSingleOptionEntry(this.debugLightLevelRadiusOption);
        list.addSingleOptionEntry(this.config.getDebugDisplayHandlerBoundingBox().getOption());
        context.addInnerWidget((SpruceParentWidget<?>)list);
    }

    private void buildEntitiesTab(TabContext context) {
        this.buildLightSourcesTab(context, class_7923.field_41177.method_10220().map(DynamicLightHandlerHolder::cast).collect(Collectors.toList()));
    }

    private void buildSpecialTab(TabContext context) {
        context.addVersionLabel();
        SpruceOptionListWidget list = new SpruceOptionListWidget(Position.origin(), context.width(), context.height());
        list.addOptionEntry(this.creeperLightingOption, this.tntLightingOption);
        list.addOptionEntry(this.config.getBeamLighting().getOption(), this.config.getFireflyLighting().getOption());
        list.addOptionEntry(this.config.getGuardianLaser().getOption(), this.config.getSonicBoomLighting().getOption());
        list.addSmallSingleOptionEntry(this.config.getGlowingEffectLighting().getOption());
        context.addInnerWidget((SpruceParentWidget<?>)list);
    }

    private void buildLightSourcesTab(TabContext context, List<DynamicLightHandlerHolder<?>> entries) {
        String oldSearch = this.searchInput != null ? this.searchInput.getText() : "";
        this.searchInput = context.addSearchInput();
        this.searchInput.setTooltip((class_2561)class_2561.method_43469((String)"lambdynlights.menu.tabs.dynamic_lights.entity.search.tooltip", (Object[])new Object[]{class_2561.method_43470((String)"@").method_27692(class_124.field_1075), class_2561.method_43470((String)"@minecraft").method_27692(class_124.field_1075), class_2561.method_43470((String)"$").method_10852(SpruceTexts.OPTIONS_ON).method_27692(class_124.field_1065), class_2561.method_43470((String)"$").method_10852(SpruceTexts.OPTIONS_OFF).method_27692(class_124.field_1065)}));
        LightSourceListWidget list = new LightSourceListWidget(Position.origin(), context.width(), context.height(), this.searchInput);
        list.addAll(entries);
        context.addInnerWidget((SpruceParentWidget<?>)list);
        this.searchInput.setText(oldSearch);
    }

    static {
        String rawVersion = LambDynLightsConstants.VERSION;
        if (rawVersion.endsWith("-local")) {
            rawVersion = rawVersion.substring(0, rawVersion.length() - "-local".length());
        }
        class_5250 version = class_2561.method_43470((String)("v" + rawVersion)).method_27692(class_124.field_1080);
        if (rawVersion.matches("^.+-rc\\.\\d+\\+.+$")) {
            version.method_10852((class_2561)class_2561.method_43470((String)" (Release Candidate)").method_27692(class_124.field_1065));
        }
        if (LambDynLightsConstants.isDevMode()) {
            version.method_10852((class_2561)class_2561.method_43470((String)" (dev)").method_27692(class_124.field_1061));
        }
        VERSION = version;
    }

    record TabContext(SpruceTabbedWidget tabbedWidget, SpruceContainerWidget container, int height) {
        int width() {
            return this.container().getWidth();
        }

        void addVersionLabel() {
            this.addWidget(new SpruceLabelWidget(Position.of((int)0, (int)16), VERSION, this.width() - 4, SpruceTextAlignment.RIGHT));
        }

        SpruceTextFieldWidget addSearchInput() {
            class_5250 searchText = class_2561.method_43471((String)"lambdynlights.menu.search");
            int textWidth = class_310.method_1551().field_1772.method_27525((class_5348)searchText);
            int searchInputX = this.width() - 140;
            this.container.addChild((SpruceWidget)new SpruceLabelWidget(Position.of((int)(searchInputX - 4 - textWidth), (int)8), (class_2561)searchText, textWidth));
            SpruceTextFieldWidget searchInput = SpruceTextFieldWidget.builder((Position)Position.of((int)searchInputX, (int)4), (int)136, (int)20).title((class_2561)class_2561.method_43470((String)"Search")).placeholder((class_2561)class_1299.field_6099.method_5897().method_27661().method_27695(new class_124[]{class_124.field_1080, class_124.field_1056})).build();
            return this.addWidget(searchInput);
        }

        <T extends SpruceWidget> T addWidget(T widget) {
            this.container().addChild(widget);
            return widget;
        }

        void addInnerWidget(SpruceParentWidget<?> widget) {
            widget.getPosition().setRelativeY(this.tabbedWidget.getList().getPosition().getRelativeY());
            this.addWidget((SpruceWidget)widget);
        }
    }
}

