/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.util;

import dev.lambdaurora.lambdynlights.DynamicLightsConfig;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.engine.scheduler.ChunkRebuildStatus;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_12021;
import net.minecraft.class_12179;
import net.minecraft.class_12180;
import net.minecraft.class_12187;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_251;
import net.minecraft.class_310;
import net.minecraft.class_4076;
import net.minecraft.class_4604;
import net.minecraft.class_863;
import org.jspecify.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public abstract class DynamicLightDebugRenderer
implements class_863.class_864 {
    final class_310 client = class_310.method_1551();
    final DynamicLightsConfig config;

    public DynamicLightDebugRenderer(LambDynLights mod) {
        this.config = mod.config;
    }

    static void renderFaces(class_251 shape, class_2382 origin, int cellSize, int color) {
        shape.method_1046((direction, cellX, cellY, cellZ) -> {
            int realCellX = cellX + origin.method_10263();
            int realCellY = cellY + origin.method_10264();
            int realCellZ = cellZ + origin.method_10260();
            DynamicLightDebugRenderer.renderFace(direction, cellSize, realCellX, realCellY, realCellZ, color);
        });
    }

    static void renderEdges(class_251 shape, class_2382 origin, int cellSize, int color) {
        shape.method_1064((startCellX, startCellY, startCellZ, endCellX, endCellY, endCellZ) -> {
            int realStartCellX = startCellX + origin.method_10263();
            int realStartCellY = startCellY + origin.method_10264();
            int realStartCellZ = startCellZ + origin.method_10260();
            int realEndCellX = endCellX + origin.method_10263();
            int realEndCellY = endCellY + origin.method_10264();
            int realEndCellZ = endCellZ + origin.method_10260();
            DynamicLightDebugRenderer.renderEdge(cellSize, realStartCellX, realStartCellY, realStartCellZ, realEndCellX, realEndCellY, realEndCellZ, color);
        }, true);
    }

    static void renderFace(class_2350 direction, int cellSize, int cellX, int cellY, int cellZ, int color) {
        class_243 facePos = new class_243((double)(cellX * cellSize), (double)(cellY * cellSize), (double)(cellZ * cellSize));
        class_12180.method_75548((class_243)facePos, (class_243)facePos.method_61889((double)cellSize), (class_2350)direction, (class_12179)class_12179.method_75539((int)color));
    }

    static void renderEdge(int cellSize, int startCellX, int startCellY, int startCellZ, int endCellX, int endCellY, int endCellZ, int color) {
        float startX = startCellX * cellSize;
        float startY = startCellY * cellSize;
        float startZ = startCellZ * cellSize;
        float endX = endCellX * cellSize;
        float endY = endCellY * cellSize;
        float endZ = endCellZ * cellSize;
        DynamicLightDebugRenderer.renderLine(startX, startY, startZ, endX, endY, endZ, color);
    }

    static void renderLine(float startX, float startY, float startZ, float endX, float endY, float endZ, int color) {
        class_12180.method_75545((class_243)new class_243((double)startX, (double)startY, (double)startZ), (class_243)new class_243((double)endX, (double)endY, (double)endZ), (int)color);
    }

    public static class SectionRebuild
    extends DynamicLightDebugRenderer {
        private static final int SCHEDULED_COLOR = 1057004031;
        private static final int REQUESTED_COLOR = 1067122854;
        private final Long2IntMap scheduledChunks = new Long2IntOpenHashMap();
        private @Nullable Long2ObjectMap<int[]> requestedChunks;

        public SectionRebuild(LambDynLights mod) {
            super(mod);
        }

        public boolean isEnabled() {
            return (Boolean)this.config.getDebugDisplayDynamicLightingChunkRebuilds().get();
        }

        public void method_23109(double x, double y, double z, class_12021 debugValueAccess, class_4604 frustum, float tickDelta) {
            if (!this.isEnabled()) {
                return;
            }
            for (Long2IntMap.Entry entry : this.scheduledChunks.long2IntEntrySet()) {
                this.addBox(1057004031, (int)((float)entry.getIntValue() / 4.0f * 255.0f), class_4076.method_18677((long)entry.getLongKey()));
            }
            if (this.requestedChunks != null) {
                for (Long2ObjectMap.Entry chunk : this.requestedChunks.long2ObjectEntrySet()) {
                    class_4076 chunkPos = class_4076.method_18677((long)chunk.getLongKey());
                    int[] statuses = (int[])chunk.getValue();
                    boolean canRenderBox = false;
                    int statusY = chunkPos.method_19531() - 4;
                    for (int i = 0; i < statuses.length; ++i) {
                        if (statuses[i] > 0) {
                            ChunkRebuildStatus status = ChunkRebuildStatus.VALUES.get(i);
                            class_12180.method_75551((String)(statuses[i] + "x " + String.valueOf((Object)status)), (class_243)new class_243((double)(chunkPos.method_19527() + 8), (double)statusY, (double)(chunkPos.method_19529() + 8)), (class_12187.class_12188)class_12187.class_12188.method_75566((int)status.color()).method_75565(1.0f));
                            if (i != ChunkRebuildStatus.AFFECTED.ordinal()) {
                                canRenderBox = true;
                            }
                        }
                        statusY -= 2;
                    }
                    if (!canRenderBox) continue;
                    this.addBox(1067122854, 255, chunkPos);
                }
            }
        }

        private void addBox(int color, int alpha, class_4076 chunk) {
            class_238 box = new class_238((double)chunk.method_19527(), (double)chunk.method_19528(), (double)chunk.method_19529(), (double)class_4076.method_32205((int)chunk.method_18674(), (int)16), (double)class_4076.method_32205((int)chunk.method_18683(), (int)16), (double)class_4076.method_32205((int)chunk.method_18687(), (int)16));
            class_12180.method_75541((class_238)box, (class_12179)class_12179.method_75535((int)(alpha << 24 | color & 0xFFFFFF)));
        }

        public void scheduleChunkRebuild(long chunkPos) {
            if (!this.isEnabled()) {
                return;
            }
            this.scheduledChunks.put(chunkPos, 4);
        }

        public void setRequestedChunks(Supplier<Long2ObjectMap<int[]>> chunks) {
            if (!this.isEnabled()) {
                return;
            }
            this.requestedChunks = chunks.get();
        }

        public void clearRequestedChunks() {
            this.requestedChunks = Long2ObjectMaps.emptyMap();
        }

        public void tick() {
            if (!this.isEnabled()) {
                return;
            }
            ObjectIterator iterator = this.scheduledChunks.long2IntEntrySet().iterator();
            while (iterator.hasNext()) {
                Long2IntMap.Entry entry = (Long2IntMap.Entry)iterator.next();
                if (entry.getIntValue() == 0) {
                    iterator.remove();
                    continue;
                }
                entry.setValue(entry.getIntValue() - 1);
            }
        }
    }
}

