/*
 * Decompiled with CFR 0.152.
 */
package page.langeweile.ok_zoomer.config.screen;

import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5676;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8132;
import net.minecraft.class_8667;
import org.quiltmc.config.api.Config;
import org.quiltmc.config.api.Configs;
import org.quiltmc.config.api.Constraint;
import org.quiltmc.config.api.values.TrackedValue;
import org.quiltmc.config.api.values.ValueTreeNode;
import page.langeweile.ok_zoomer.config.ConfigEnums;
import page.langeweile.ok_zoomer.config.OkZoomerConfigManager;
import page.langeweile.ok_zoomer.config.metadata.WidgetSize;
import page.langeweile.ok_zoomer.config.screen.ConfigTextUtils;
import page.langeweile.ok_zoomer.config.screen.ZoomPresets;
import page.langeweile.ok_zoomer.config.screen.components.LabelledEditBox;
import page.langeweile.ok_zoomer.config.screen.components.OkZoomerSelectionList;
import page.langeweile.ok_zoomer.utils.ModUtils;
import page.langeweile.ok_zoomer.utils.ZoomUtils;

public class OkZoomerConfigScreen
extends class_437 {
    private final class_2960 configId;
    private final class_437 parent;
    private ConfigTextUtils configTextUtils;
    private final class_8132 layout = new class_8132((class_437)this);
    private OkZoomerSelectionList selectionList;
    private final Map<TrackedValue<Object>, Object> newValues;
    private final Set<TrackedValue<Object>> invalidValues;
    private class_339 buttonBuffer = null;

    public OkZoomerConfigScreen(class_437 parent) {
        super(ConfigTextUtils.getConfigTitle(ModUtils.id("config")));
        this.configId = ModUtils.id("config");
        this.parent = parent;
        this.newValues = new Reference2ObjectArrayMap();
        this.invalidValues = new ObjectArraySet();
    }

    protected void method_25426() {
        Config config = Configs.getConfig((String)this.configId.method_12836(), (String)this.configId.method_12832());
        this.configTextUtils = new ConfigTextUtils(config);
        this.selectionList = new OkZoomerSelectionList(this.field_22787, this.field_22789, this.field_22790 - 64, 32, this);
        this.selectionList.addCategory((class_2561)class_2561.method_43471((String)"config.ok_zoomer.presets"));
        class_5676 presetButton = class_5676.method_32606(value -> class_2561.method_43471((String)String.format("config.ok_zoomer.presets.preset.%s", value.toString().toLowerCase(Locale.ROOT))), (Object)ConfigEnums.ZoomPresets.CAMERA).method_32624((Object[])ConfigEnums.ZoomPresets.values()).method_32618(value -> class_7919.method_47407((class_2561)class_2561.method_43471((String)String.format("config.ok_zoomer.presets.preset.%s.tooltip", value.toString().toLowerCase(Locale.ROOT))))).method_35723(0, 0, 150, 20, (class_2561)class_2561.method_43471((String)"config.ok_zoomer.presets.preset"));
        class_4185 resetButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"config.ok_zoomer.presets.apply_preset"), button -> this.resetToPreset((ConfigEnums.ZoomPresets)presetButton.method_32603())).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"config.ok_zoomer.presets.apply_preset.tooltip"))).method_46431();
        this.selectionList.addButton((class_339)presetButton, (class_339)resetButton);
        for (ValueTreeNode node : config.nodes()) {
            if (!(node instanceof ValueTreeNode.Section)) continue;
            ValueTreeNode.Section section = (ValueTreeNode.Section)node;
            this.selectionList.addCategory(this.configTextUtils.getCategoryText(section.key().toString()));
            for (ValueTreeNode subNode : section) {
                Object button2;
                TrackedValue trackedValue;
                WidgetSize.Size size = (WidgetSize.Size)((Object)subNode.metadata(WidgetSize.TYPE));
                if (!(subNode instanceof TrackedValue)) continue;
                TrackedValue trackie = trackedValue = (TrackedValue)subNode;
                this.newValues.putIfAbsent((TrackedValue<Object>)trackie, trackedValue.getRealValue());
                if (trackedValue.value() instanceof Boolean) {
                    button2 = !trackedValue.equals(OkZoomerConfigManager.CONFIG.tweaks.unbindConflictingKey) ? class_5676.method_32614((boolean)((Boolean)this.newValues.get(trackie))).method_32618(value -> class_7919.method_47407((class_2561)this.configTextUtils.getOptionTextTooltip(trackedValue))).method_32617(0, 0, 150, 20, this.configTextUtils.getOptionText(trackedValue), (button_, value) -> this.newValues.replace((TrackedValue<Object>)trackie, value)) : class_4185.method_46430((class_2561)class_2561.method_43471((String)"config.ok_zoomer.tweaks.unbind_conflicting_key"), button_ -> ZoomUtils.unbindConflictingKey(this.field_22787, true)).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"config.ok_zoomer.tweaks.unbind_conflicting_key.tooltip"))).method_46431();
                    this.addOptionToList((class_339)button2, size);
                    continue;
                }
                if (trackedValue.value() instanceof Double) {
                    button2 = new LabelledEditBox(this.field_22793, 0, 0, 150, 32, this.configTextUtils.getOptionText(trackedValue));
                    button2.method_1852(((Double)this.newValues.get(trackie)).toString());
                    button2.method_1863(arg_0 -> this.lambda$init$6(trackedValue, trackie, (LabelledEditBox)((Object)button2), arg_0));
                    button2.method_47400(class_7919.method_47407((class_2561)this.configTextUtils.getOptionTextTooltip(trackedValue)));
                    this.addOptionToList((class_339)button2, size);
                    continue;
                }
                if (trackedValue.value() instanceof Integer) {
                    button2 = new LabelledEditBox(this.field_22793, 0, 0, 150, 32, this.configTextUtils.getOptionText(trackedValue));
                    button2.method_1852(((Integer)this.newValues.get(trackie)).toString());
                    button2.method_1863(arg_0 -> this.lambda$init$7(trackedValue, trackie, (LabelledEditBox)((Object)button2), arg_0));
                    button2.method_47400(class_7919.method_47407((class_2561)this.configTextUtils.getOptionTextTooltip(trackedValue)));
                    this.addOptionToList((class_339)button2, size);
                    continue;
                }
                button2 = trackedValue.value();
                if (!(button2 instanceof ConfigEnums.ConfigEnum)) continue;
                ConfigEnums.ConfigEnum configEnum = (ConfigEnums.ConfigEnum)button2;
                button2 = class_5676.method_32606(value -> this.configTextUtils.getEnumOptionText((TrackedValue<?>)trackedValue, (ConfigEnums.ConfigEnum)value), (Object)((ConfigEnums.ConfigEnum)this.newValues.get(trackie))).method_32624((Object[])((ConfigEnums.ConfigEnum[])((Enum)((Object)configEnum)).getDeclaringClass().getEnumConstants())).method_32618(value -> class_7919.method_47407((class_2561)this.configTextUtils.getEnumOptionTextTooltip((TrackedValue<?>)trackedValue, (ConfigEnums.ConfigEnum)value))).method_32617(0, 0, 150, 20, this.configTextUtils.getOptionText(trackedValue), (button_, value) -> this.newValues.replace((TrackedValue<Object>)trackie, value));
                this.addOptionToList((class_339)button2, size);
            }
            if (this.buttonBuffer == null) continue;
            this.selectionList.addButton(this.buttonBuffer, null);
            this.buttonBuffer = null;
        }
        this.method_37063((class_364)this.selectionList);
        this.layout.method_57726(this.field_22785, this.field_22793);
        class_8667 footerLayout = (class_8667)this.layout.method_48996((class_8021)class_8667.method_52742().method_52735(8));
        footerLayout.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"config.ok_zoomer.discard_changes"), button -> this.resetNewValues()).method_46432(150).method_46431());
        footerLayout.method_52736((class_8021)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46432(150).method_46431());
        this.layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.method_48640();
    }

    protected void method_48640() {
        this.layout.method_48222();
        this.selectionList.method_57712(this.field_22789, this.layout);
    }

    private void addOptionToList(class_339 button, WidgetSize.Size size) {
        if (size == WidgetSize.Size.HALF) {
            if (this.buttonBuffer == null) {
                this.buttonBuffer = button;
            } else {
                this.selectionList.addButton(this.buttonBuffer, button);
                this.buttonBuffer = null;
            }
        } else {
            if (this.buttonBuffer != null) {
                this.selectionList.addButton(this.buttonBuffer, null);
                this.buttonBuffer = null;
            }
            this.selectionList.addButton(button);
        }
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public void method_25432() {
        this.newValues.forEach((trackedValue, newValue) -> {
            if (!this.invalidValues.contains(trackedValue)) {
                trackedValue.setValue(newValue, false);
            }
        });
        OkZoomerConfigManager.CONFIG.save();
    }

    private void refresh() {
        double scrollAmount = this.selectionList.method_44387();
        this.method_41843();
        this.selectionList.method_44382(scrollAmount);
    }

    private void resetNewValues() {
        this.newValues.clear();
        for (TrackedValue trackedValue : OkZoomerConfigManager.CONFIG.values()) {
            if (trackedValue.getRealValue() == null) continue;
            this.newValues.put((TrackedValue<Object>)trackedValue, trackedValue.getRealValue());
        }
        this.refresh();
    }

    public void resetToPreset(ConfigEnums.ZoomPresets preset) {
        this.newValues.clear();
        this.invalidValues.clear();
        for (TrackedValue trackedValue : OkZoomerConfigManager.CONFIG.values()) {
            this.newValues.put((TrackedValue<Object>)trackedValue, ZoomPresets.PRESET_ENUM_TO_PRESET.get(preset).getOrDefault(trackedValue, trackedValue.getDefaultValue()));
        }
        this.refresh();
    }

    private /* synthetic */ void lambda$init$7(TrackedValue trackedValue, TrackedValue trackie, LabelledEditBox button, String value) {
        try {
            int min = Integer.MIN_VALUE;
            int max = Integer.MAX_VALUE;
            for (Constraint constraint : trackedValue.constraints()) {
                if (!(constraint instanceof Constraint.Range)) continue;
                Constraint.Range range = (Constraint.Range)constraint;
                min = Math.max((Integer)range.min(), min);
                max = Math.min((Integer)range.max(), max);
            }
            int parsedValue = Integer.parseInt(value);
            if (parsedValue < min || parsedValue > max) {
                throw new IndexOutOfBoundsException();
            }
            this.newValues.replace((TrackedValue<Object>)trackie, parsedValue);
            this.invalidValues.remove(trackie);
            button.method_1868(-2039584);
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            this.invalidValues.add((TrackedValue<Object>)trackie);
            button.method_1868(-65536);
        }
    }

    private /* synthetic */ void lambda$init$6(TrackedValue trackedValue, TrackedValue trackie, LabelledEditBox button, String value) {
        try {
            double min = Double.NEGATIVE_INFINITY;
            double max = Double.POSITIVE_INFINITY;
            for (Constraint constraint : trackedValue.constraints()) {
                if (!(constraint instanceof Constraint.Range)) continue;
                Constraint.Range range = (Constraint.Range)constraint;
                min = Math.max((Double)range.min(), min);
                max = Math.min((Double)range.max(), max);
            }
            double parsedValue = Double.parseDouble(value);
            if (parsedValue < min || parsedValue > max) {
                throw new IndexOutOfBoundsException();
            }
            this.newValues.replace((TrackedValue<Object>)trackie, parsedValue);
            this.invalidValues.remove(trackie);
            button.method_1868(-2039584);
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            this.invalidValues.add((TrackedValue<Object>)trackie);
            button.method_1868(-65536);
        }
    }
}

