/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.simpleupdatechecker;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import eu.pb4.simpleupdatechecker.FlexVerComparator;
import eu.pb4.simpleupdatechecker.ModpackConfig;
import eu.pb4.simpleupdatechecker.ModrinthModpackVersion;
import eu.pb4.simpleupdatechecker.PlaceholderSupport;
import eu.pb4.simpleupdatechecker.UserConfig;
import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_12090;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModInit
implements ModInitializer,
DedicatedServerModInitializer,
ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Simple Update Checker");
    private static final long timeout = Duration.ofMinutes(10L).toMillis();
    private static final long CLIENT_RECHECK_TIMEOUT = 20L * Duration.ofHours(1L).toSeconds();
    private static final long INITIAL_SERVER_RECHECK_TIMEOUT = 20L * Duration.ofHours(12L).toSeconds();
    private static final long MAX_SERVER_RECHECK_TIMEOUT = 20L * Duration.ofDays(14L).toSeconds();
    @Nullable
    public static Version updateVersion = null;
    public static boolean noVersionsAvailable = false;
    public static long lastUpdate = -1L;
    public static long tick;
    private static long serverRecheckTimeout;

    private static void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 access, class_2170.class_5364 env) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"simpleupdatechecker").requires(class_156.method_61200((Predicate)class_2170.method_71774((class_12090)class_2170.field_31840), x -> x.method_43737() && x.method_9211().method_19466(Objects.requireNonNull(x.method_44023()).method_72498())))).then(class_2170.method_9247((String)"check").executes(x -> {
            ModInit.checkUpdates(() -> ModInit.sentTextUpdate(arg_0 -> ((class_2168)((class_2168)x.getSource())).method_45068(arg_0), true));
            return 0;
        }))).then(class_2170.method_9247((String)"reload").executes(x -> {
            ModpackConfig.clear();
            UserConfig.clear();
            tick = 0L;
            lastUpdate = -1L;
            return 0;
        }))).then((ArgumentBuilder)class_156.method_654((Object)class_2170.method_9247((String)"settings"), l -> {
            for (UserConfig.Toggle field : UserConfig.getToggles()) {
                l.then(((LiteralArgumentBuilder)class_2170.method_9247((String)field.name()).executes(x -> {
                    ((class_2168)x.getSource()).method_45068((class_2561)class_2561.method_43469((String)"text.simpleupdatechecker.command.setting.current", (Object[])new Object[]{field.name(), String.valueOf(field.get().get())}));
                    return field.get().get() != false ? 1 : 0;
                })).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(x -> {
                    boolean arg = BoolArgumentType.getBool((CommandContext)x, (String)"value");
                    field.set().accept(arg);
                    ((class_2168)x.getSource()).method_45068((class_2561)class_2561.method_43469((String)"text.simpleupdatechecker.command.setting.changed", (Object[])new Object[]{field.name(), String.valueOf(arg)}));
                    return arg ? 1 : 0;
                })));
            }
        })));
    }

    public static void sentConsoleUpdate() {
        if (updateVersion != null) {
            LOGGER.info("=====================================================================");
            LOGGER.info("Modpack update available! Current version {}, latest {}.", (Object)ModpackConfig.get().getDisplayVersion(), (Object)updateVersion.displayVersion());
            LOGGER.info("Download it here: {}", (Object)ModInit.updateVersion.url);
            LOGGER.info("=====================================================================");
        }
    }

    public static void sentTextUpdate(Consumer<class_2561> textConsumer, boolean sentNoUpdates) {
        if (updateVersion != null) {
            textConsumer.accept((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43471((String)"text.simpleupdatechecker.update_available.title").method_27692(class_124.field_1065)).method_27693(" ").method_10852((class_2561)class_2561.method_43469((String)"text.simpleupdatechecker.update_available.version", (Object[])new Object[]{class_2561.method_43470((String)ModpackConfig.get().getDisplayVersion()).method_27692(class_124.field_1068), class_2561.method_43470((String)updateVersion.displayVersion()).method_27692(class_124.field_1068)}).method_27692(class_124.field_1054)));
            textConsumer.accept((class_2561)class_2561.method_43469((String)"text.simpleupdatechecker.update_available.download", (Object[])new Object[]{class_2561.method_43470((String)ModInit.updateVersion.url).method_10862(class_2583.field_24360.method_10977(class_124.field_1078).method_30938(Boolean.valueOf(true)).method_10958((class_2558)new class_2558.class_10608(URI.create(updateVersion.url()))))}).method_27692(class_124.field_1080));
        } else if (sentNoUpdates) {
            if (noVersionsAvailable) {
                textConsumer.accept((class_2561)class_2561.method_43471((String)"text.simpleupdatechecker.no_updates.error").method_27692(class_124.field_1061));
            } else {
                textConsumer.accept((class_2561)class_2561.method_43471((String)"text.simpleupdatechecker.no_updates.latest").method_27692(class_124.field_1060));
            }
        }
    }

    private static void checkUpdates(Runnable runnable) {
        if (UserConfig.get().disableUpdateChecking) {
            return;
        }
        if (System.currentTimeMillis() - lastUpdate < timeout) {
            runnable.run();
            return;
        }
        ModpackConfig config = ModpackConfig.get();
        ModrinthModpackVersion.getVersions().thenAccept(versions -> {
            Optional<Object> out;
            lastUpdate = System.currentTimeMillis();
            if (versions == null || versions.isEmpty()) {
                noVersionsAvailable = true;
                return;
            }
            noVersionsAvailable = false;
            tick = 0L;
            Stream<Object> stream = versions.stream();
            stream = stream.filter(x -> config.releaseType.contains(x.versionType));
            if (!config.maxExclusiveVersion.isEmpty()) {
                stream = stream.filter(x -> FlexVerComparator.compare(x.versionNumber, config.maxExclusiveVersion) < 0);
            }
            if ((out = (stream = stream.filter(x -> FlexVerComparator.compare(x.versionNumber, config.versionId) > 0)).findFirst()).isEmpty()) {
                updateVersion = null;
                return;
            }
            updateVersion = new Version(((ModrinthModpackVersion)out.get()).name, ((ModrinthModpackVersion)out.get()).versionNumber, config.versionPage(((ModrinthModpackVersion)out.get()).id, ((ModrinthModpackVersion)out.get()).versionNumber));
            runnable.run();
        });
    }

    public void onInitialize() {
        ModpackConfig.get();
        ModInit.checkUpdates(UserConfig.get().disableLogsFirstCheck ? () -> {} : ModInit::sentConsoleUpdate);
        if (FabricLoader.getInstance().isModLoaded("placeholder-api")) {
            PlaceholderSupport.register();
        }
        CommandRegistrationCallback.EVENT.register(ModInit::registerCommands);
    }

    public void onInitializeClient() {
        ClientTickEvents.END_CLIENT_TICK.register(x -> {
            if (tick++ > CLIENT_RECHECK_TIMEOUT) {
                tick = 0L;
                ModInit.checkUpdates(() -> {});
            }
        });
    }

    public void onInitializeServer() {
        if (!UserConfig.get().disableLogsServerStarted) {
            ServerLifecycleEvents.SERVER_STARTED.register(x -> ModInit.sentConsoleUpdate());
        }
        ServerTickEvents.END_SERVER_TICK.register(x -> {
            if (tick++ > serverRecheckTimeout) {
                tick = 0L;
                ModInit.checkUpdates(UserConfig.get().disableLogsLate ? () -> {} : ModInit::sentConsoleUpdate);
                serverRecheckTimeout = updateVersion != null ? Math.max(serverRecheckTimeout * 2L, MAX_SERVER_RECHECK_TIMEOUT) : INITIAL_SERVER_RECHECK_TIMEOUT;
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            if (class_2170.field_31840.method_75022(handler.field_14140.method_75004()) && !UserConfig.get().disableJoinOps) {
                ModInit.sentTextUpdate(arg_0 -> ((class_3222)handler.field_14140).method_64398(arg_0), false);
            }
        });
    }

    static {
        serverRecheckTimeout = INITIAL_SERVER_RECHECK_TIMEOUT;
    }

    public record Version(String name, String versionNumber, String url) {
        public String displayVersion() {
            return ModpackConfig.get().useVersionNumberForUpdateDisplay ? this.versionNumber : this.name;
        }
    }
}

