/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.simpleupdatechecker;

import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import eu.pb4.simpleupdatechecker.ModInit;
import eu.pb4.simpleupdatechecker.ModpackConfig;
import eu.pb4.simpleupdatechecker.SUCUtils;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class ModrinthModpackVersion {
    private static final TypeToken<List<ModrinthModpackVersion>> TYPE = new TypeToken<List<ModrinthModpackVersion>>(){};
    public String name = "";
    @SerializedName(value="version_number")
    public String versionNumber = "";
    @SerializedName(value="version_type")
    public String versionType = "";
    public String id = "";

    public static List<ModrinthModpackVersion> read(String s) {
        return (List)SUCUtils.GSON.fromJson(s, TYPE);
    }

    static CompletableFuture<List<ModrinthModpackVersion>> getVersions() {
        HttpClient client = SUCUtils.createHttpClient();
        try {
            CompletionStage completionStage = client.sendAsync(SUCUtils.createGetRequest(URI.create(ModpackConfig.get().versionSource())), HttpResponse.BodyHandlers.ofString()).thenApply(res -> {
                if (res.statusCode() != 200) {
                    ModInit.LOGGER.error("Failed to read Modrinth version list! Got status code {} with body '{}'", (Object)res.statusCode(), res.body());
                    return List.of();
                }
                return ModrinthModpackVersion.read((String)res.body());
            });
            if (client != null) {
                client.close();
            }
            return completionStage;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                ModInit.LOGGER.error("Exception thrown while getting version list!", e);
                return CompletableFuture.supplyAsync(List::of);
            }
        }
    }

    public static class File {
        public Map<String, String> hashes = new HashMap<String, String>();
        public long size = -1L;
        public URI url;
        public boolean primary = false;
    }
}

