/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.simpleupdatechecker;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_156;

public interface SUCUtils {
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().setLenient().create();
    public static final String USERAGENT = (String)class_156.method_656(() -> {
        ModContainer x = (ModContainer)FabricLoader.getInstance().getModContainer("simpleupdatechecker").get();
        return "Simple Update Checker v" + String.valueOf(x.getMetadata().getVersion()) + " (pb4.eu)";
    });

    public static HttpClient createHttpClient() {
        return HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).build();
    }

    public static HttpRequest createGetRequest(URI uri) {
        return HttpRequest.newBuilder(uri).setHeader("User-Agent", USERAGENT).GET().build();
    }

    public static Path configPath(String type) {
        return FabricLoader.getInstance().getConfigDir().resolve("simpleupdatechecker_" + type + ".json");
    }

    public static <T> T readConfig(String type, Class<T> clazz) {
        Path path = SUCUtils.configPath(type);
        Object instance = null;
        if (Files.exists(path, new LinkOption[0])) {
            try {
                instance = GSON.fromJson(Files.readString(path), clazz);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (instance == null) {
            try {
                instance = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }
        SUCUtils.writeConfig(type, instance);
        return (T)instance;
    }

    public static <T> void writeConfig(String type, T instance) {
        Path path = SUCUtils.configPath(type);
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            Files.writeString(path, (CharSequence)GSON.toJson(instance), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

