/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.simpleupdatechecker;

import com.google.gson.annotations.SerializedName;
import eu.pb4.simpleupdatechecker.SUCUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class UserConfig {
    private static UserConfig instance;
    @SerializedName(value="disable_update_checking")
    public boolean disableUpdateChecking = false;
    @SerializedName(value="disable_main_menu")
    public boolean disableMainMenu = false;
    @SerializedName(value="disable_logs_first_check")
    public boolean disableLogsFirstCheck = false;
    @SerializedName(value="disable_logs_server_started")
    public boolean disableLogsServerStarted = false;
    @SerializedName(value="disable_logs_late")
    public boolean disableLogsLate = false;
    @SerializedName(value="disable_join_ops")
    public boolean disableJoinOps = false;

    public static UserConfig get() {
        if (instance == null) {
            instance = SUCUtils.readConfig("user", UserConfig.class);
        }
        return instance;
    }

    public static List<Toggle> getToggles() {
        ArrayList<Toggle> list = new ArrayList<Toggle>();
        for (Field field : UserConfig.class.getFields()) {
            SerializedName name = field.getAnnotation(SerializedName.class);
            Class<?> type = field.getType();
            if (name == null || type != Boolean.TYPE) continue;
            list.add(new Toggle(name.value(), () -> {
                try {
                    return field.getBoolean(UserConfig.get());
                }
                catch (IllegalAccessException e) {
                    return false;
                }
            }, x -> {
                try {
                    field.setBoolean(UserConfig.get(), (boolean)x);
                    UserConfig.get().update();
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }));
        }
        return list;
    }

    public void update() {
        SUCUtils.writeConfig("user", this);
    }

    public static void clear() {
        instance = null;
    }

    public record Toggle(String name, Supplier<Boolean> get, Consumer<Boolean> set) {
    }
}

