/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay;

public enum ColourScheme {
    RED(new Colour(239, 50, 61), new Colour(255, 255, 255)),
    BLACK(new Colour(0, 0, 0), new Colour(255, 255, 255));

    private final Colour background;
    private final Colour foreground;

    private ColourScheme(Colour background, Colour foreground) {
        this.background = background;
        this.foreground = foreground;
    }

    public Colour background() {
        return this.background;
    }

    public Colour foreground() {
        return this.foreground;
    }

    public record Colour(int red, int green, int blue) {
        public float redf() {
            return (float)this.red / 255.0f;
        }

        public float greenf() {
            return (float)this.green / 255.0f;
        }

        public float bluef() {
            return (float)this.blue / 255.0f;
        }

        public int packedint(int a) {
            return (a & 0xFF) << 24 | (this.blue & 0xFF) << 16 | (this.green & 0xFF) << 8 | this.red & 0xFF;
        }
    }
}

