/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gui.widgets;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.caffeinemc.mods.sodium.client.config.ConfigManager;
import net.caffeinemc.mods.sodium.client.config.structure.ExternalPage;
import net.caffeinemc.mods.sodium.client.config.structure.ModOptions;
import net.caffeinemc.mods.sodium.client.config.structure.Option;
import net.caffeinemc.mods.sodium.client.config.structure.OptionGroup;
import net.caffeinemc.mods.sodium.client.config.structure.OptionPage;
import net.caffeinemc.mods.sodium.client.config.structure.Page;
import net.caffeinemc.mods.sodium.client.gui.ColorTheme;
import net.caffeinemc.mods.sodium.client.gui.VideoSettingsScreen;
import net.caffeinemc.mods.sodium.client.gui.options.control.AbstractOptionList;
import net.caffeinemc.mods.sodium.client.gui.options.control.Control;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlElement;
import net.caffeinemc.mods.sodium.client.gui.options.control.ExternalButtonControl;
import net.caffeinemc.mods.sodium.client.gui.widgets.AbstractWidget;
import net.caffeinemc.mods.sodium.client.gui.widgets.ScrollbarWidget;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class OptionListWidget
extends AbstractOptionList {
    private List<Option.OptionNameSource> filteredOptions = null;
    private final Reference2ReferenceMap<Page, SectionInfo> pageToSectionInfo = new Reference2ReferenceOpenHashMap();
    private final Consumer<Page> onPageFocused;
    private SectionInfo lastFocusedSection;
    private boolean ignoreNextScrollUpdate = false;
    private int entryHeight;

    public OptionListWidget(class_437 screen, Dim2i dim, Consumer<Page> onPageFocused) {
        super(dim.insetLeft(3));
        this.onPageFocused = onPageFocused;
        this.rebuild(screen);
    }

    public void setFilteredOptions(List<Option.OptionNameSource> filteredOptions) {
        this.filteredOptions = filteredOptions;
    }

    public void clearFilter() {
        this.filteredOptions = null;
    }

    public void rebuild(class_437 screen) {
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth() - 5 - 7;
        int height = this.getHeight();
        this.clearChildren();
        this.controls.clear();
        this.pageToSectionInfo.clear();
        this.scrollbar = this.addRenderableChild(new ScrollbarWidget(new Dim2i(x + width + 5, y, 7, height), this::updateSectionFocus));
        Objects.requireNonNull(this.font);
        this.entryHeight = 9 * 2;
        int listHeight = this.filteredOptions != null ? this.renderFilteredOptions(screen, x, y, width) : this.renderAllPages(screen, x, y, width);
        this.updateSectionFocus(this.scrollbar.getScrollAmount());
        this.scrollbar.setScrollbarContext(listHeight);
    }

    private int renderFilteredOptions(class_437 screen, int x, int y, int width) {
        int listHeight = -12;
        Option.OptionNameSource lastSource = null;
        for (Option.OptionNameSource source : this.filteredOptions) {
            Option option = source.getOption();
            Control control = option.getControl();
            ModOptions modOptions = source.getModOptions();
            OptionPage page = source.getPage();
            ColorTheme theme = modOptions.theme();
            if (lastSource == null || lastSource.getModOptions() != modOptions) {
                ModHeaderWidget modHeader = new ModHeaderWidget(this, new Dim2i(x, y + (listHeight += 12), width, this.entryHeight), modOptions.name(), theme, modOptions.icon(), modOptions.iconMonochrome());
                this.addRenderableChild(modHeader);
                listHeight += this.entryHeight;
            }
            if (lastSource == null || lastSource.getPage() != page) {
                PageHeaderWidget pageHeader = new PageHeaderWidget(this, new Dim2i(x, y + (listHeight += 6), width, this.entryHeight), page.name().getString(), theme);
                this.addRenderableChild(pageHeader);
                listHeight += this.entryHeight;
            }
            if (lastSource == null || lastSource.getOptionGroup() != source.getOptionGroup()) {
                listHeight += 3;
            }
            ControlElement element = control.createElement(screen, this, new Dim2i(x, y + listHeight, width, this.entryHeight).insetLeft(3), theme);
            this.addRenderableChild(element);
            this.controls.add(element);
            listHeight += this.entryHeight;
            lastSource = source;
        }
        return listHeight;
    }

    private int renderAllPages(class_437 screen, int x, int y, int width) {
        int listHeight = -12;
        for (ModOptions modOptions : ConfigManager.CONFIG.getModOptions()) {
            if (modOptions.pages().isEmpty()) continue;
            ColorTheme theme = modOptions.theme();
            int modHeaderStart = listHeight += 12;
            ModHeaderWidget modHeader = new ModHeaderWidget(this, new Dim2i(x, y + listHeight, width, this.entryHeight), modOptions.name(), theme, modOptions.icon(), modOptions.iconMonochrome());
            this.addRenderableChild(modHeader);
            listHeight += this.entryHeight;
            for (Page page : modOptions.pages()) {
                int pageStartY = listHeight;
                if (page instanceof OptionPage) {
                    PageHeaderWidget pageHeader = new PageHeaderWidget(this, new Dim2i(x, y + (listHeight += 6), width, this.entryHeight), page.name().getString(), theme);
                    this.addRenderableChild(pageHeader);
                    listHeight += this.entryHeight;
                    for (OptionGroup group : page.groups()) {
                        listHeight += 3;
                        if (group.name() != null) {
                            GroupHeaderWidget groupHeader = new GroupHeaderWidget(this, new Dim2i(x, y + listHeight, width, this.entryHeight).insetLeft(3), group.name().getString());
                            this.addRenderableChild(groupHeader);
                            listHeight += this.entryHeight;
                        }
                        for (Option option : group.options()) {
                            Control control = option.getControl();
                            ControlElement element = control.createElement(screen, this, new Dim2i(x, y + listHeight, width, this.entryHeight).insetLeft(3), theme);
                            this.addRenderableChild(element);
                            this.controls.add(element);
                            listHeight += this.entryHeight;
                        }
                    }
                } else if (page instanceof ExternalPage) {
                    ExternalPage externalPage = (ExternalPage)page;
                    ExternalPageWidget externalPageWidget = new ExternalPageWidget(screen, this, new Dim2i(x, y + (listHeight += 6), width, this.entryHeight), externalPage, theme);
                    this.addRenderableChild(externalPageWidget);
                    listHeight += this.entryHeight;
                } else {
                    throw new IllegalStateException("Unknown page type: " + String.valueOf(page.getClass()));
                }
                int scrollJumpTarget = pageStartY;
                if (modHeaderStart != -1) {
                    scrollJumpTarget = modHeaderStart;
                    modHeaderStart = -1;
                }
                SectionInfo sectionInfo = new SectionInfo(modOptions, page, pageStartY, listHeight, scrollJumpTarget);
                this.pageToSectionInfo.put((Object)page, (Object)sectionInfo);
            }
        }
        return listHeight;
    }

    public void jumpToPage(Page page) {
        SectionInfo sectionInfo = (SectionInfo)this.pageToSectionInfo.get((Object)page);
        if (sectionInfo != null) {
            this.ignoreNextScrollUpdate = true;
            this.scrollbar.scrollTo(sectionInfo.scrollJumpTarget);
        }
    }

    @Override
    public void method_25394(@NonNull class_332 graphics, int mouseX, int mouseY, float delta) {
        graphics.method_44379(this.getX(), this.getY(), this.getLimitX(), this.getLimitY());
        super.method_25394(graphics, mouseX, mouseY, delta);
        graphics.method_44380();
    }

    private void updateSectionFocus(int scrollAmount) {
        if (this.ignoreNextScrollUpdate) {
            this.ignoreNextScrollUpdate = false;
            return;
        }
        int highlightTarget = scrollAmount + this.getY() + Math.min(this.entryHeight * 3, this.getHeight() / 2);
        SectionInfo currentSection = null;
        for (SectionInfo section : this.pageToSectionInfo.values()) {
            if (highlightTarget < section.startY || highlightTarget > section.endY) continue;
            currentSection = section;
            break;
        }
        if (currentSection != null && currentSection != this.lastFocusedSection) {
            this.lastFocusedSection = currentSection;
            this.onPageFocused.accept(currentSection.page());
        }
    }

    private static class ModHeaderWidget
    extends HeaderWidget {
        final class_2960 icon;
        final boolean iconMonochrome;

        public ModHeaderWidget(AbstractOptionList list, Dim2i dim, String title, ColorTheme theme, class_2960 icon, boolean iconMonochrome) {
            super(list, dim, String.valueOf(class_124.field_1067) + title, theme.themeLighter, -1342177280);
            this.icon = icon;
            this.iconMonochrome = iconMonochrome;
        }

        @Override
        public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
            this.hovered = this.method_25405(mouseX, mouseY);
            this.drawRect(graphics, this.getX(), this.getY(), this.getLimitX(), this.getLimitY(), this.backgroundColor);
            int textOffset = 6;
            int textY = this.getCenterY() + -4;
            if (this.icon != null) {
                textOffset = VideoSettingsScreen.renderIconWithSpacing(graphics, this.icon, this.textColor, this.iconMonochrome, this.getX(), this.getY(), this.getHeight(), 4);
                textY = this.getCenterY() + -3;
            }
            this.drawString(graphics, this.truncateTextToFit(this.title, this.getWidth() - textOffset), this.getX() + textOffset, textY, this.textColor);
        }
    }

    private static class PageHeaderWidget
    extends HeaderWidget {
        public PageHeaderWidget(AbstractOptionList list, Dim2i dim, String title, ColorTheme theme) {
            this(list, dim, "\u25c6 ", title, theme);
        }

        PageHeaderWidget(AbstractOptionList list, Dim2i dim, String prefix, String title, ColorTheme theme) {
            super(list, dim, prefix + title, theme.theme, -1879048192);
        }
    }

    private static class GroupHeaderWidget
    extends HeaderWidget {
        public GroupHeaderWidget(AbstractOptionList list, Dim2i dim, String title) {
            super(list, dim, String.valueOf(class_124.field_1067) + title, -1, 0x60000000);
        }
    }

    private static class ExternalPageWidget
    extends PageHeaderWidget {
        private final class_437 screen;
        private final ExternalPage page;
        private final ColorTheme theme;

        public ExternalPageWidget(class_437 screen, AbstractOptionList list, Dim2i dim, ExternalPage page, ColorTheme theme) {
            super(list, dim, "\u25b6 ", page.name().getString(), theme);
            this.screen = screen;
            this.theme = theme;
            this.page = page;
        }

        @Override
        public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
            super.method_25394(graphics, mouseX, mouseY, delta);
            class_2561 buttonText = ExternalButtonControl.formatExternalButtonText(true, this.theme);
            this.drawString(graphics, buttonText, this.getLimitX() - 6 - this.font.method_27525((class_5348)buttonText), this.getCenterY() + -4, -1);
        }

        public boolean method_25402(class_11909 event, boolean doubleClick) {
            if (event.method_74245() == 0 && this.method_25405(event.comp_4798(), event.comp_4799())) {
                this.page.currentScreenConsumer().accept(this.screen);
                this.playClickSound();
                return true;
            }
            return false;
        }
    }

    private record SectionInfo(ModOptions modOptions, Page page, int startY, int endY, int scrollJumpTarget) {
    }

    private static abstract class HeaderWidget
    extends AbstractWidget {
        final AbstractOptionList list;
        final String title;
        final int textColor;
        final int backgroundColor;

        public HeaderWidget(AbstractOptionList list, Dim2i dim, String title, int textColor, int backgroundColor) {
            super(dim);
            this.list = list;
            this.title = title;
            this.textColor = textColor;
            this.backgroundColor = backgroundColor;
        }

        public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
            this.hovered = this.method_25405(mouseX, mouseY);
            this.drawRect(graphics, this.getX(), this.getY(), this.getLimitX(), this.getLimitY(), this.backgroundColor);
            this.drawString(graphics, this.truncateLabelToFit(this.title), this.getX() + 6, this.getCenterY() + -4, this.textColor);
        }

        protected String truncateLabelToFit(String name) {
            return this.truncateTextToFit(name, this.getWidth() - 12);
        }

        @Override
        public int getY() {
            return super.getY() - this.list.getScrollAmount();
        }

        @Override
        public @Nullable class_8016 method_48205(class_8023 event) {
            return null;
        }
    }
}

