/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.scoreboardoverhaul.common.hud;

import java.awt.Color;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import me.jfenn.scoreboardoverhaul.api.IDrawService;
import me.jfenn.scoreboardoverhaul.api.IHudCallback;
import me.jfenn.scoreboardoverhaul.api.IOptionsAccessor;
import me.jfenn.scoreboardoverhaul.common.config.Rect;
import me.jfenn.scoreboardoverhaul.common.config.ResourceFrame;
import me.jfenn.scoreboardoverhaul.common.config.ScoreboardConfig;
import me.jfenn.scoreboardoverhaul.common.data.ObjectiveInfo;
import me.jfenn.scoreboardoverhaul.common.data.ScoreInfo;
import me.jfenn.scoreboardoverhaul.common.hud.HudState;
import me.jfenn.scoreboardoverhaul.common.utils.ColorKt;
import me.jfenn.scoreboardoverhaul.common.utils.LerpKt;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2i;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 ?2\u00020\u0001:\u0001?B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J7\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ/\u0010#\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020 H\u0002\u00a2\u0006\u0004\b#\u0010$J/\u0010'\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010&\u001a\u00020%2\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b'\u0010(J\u0017\u0010)\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b)\u0010*J\r\u0010+\u001a\u00020\f\u00a2\u0006\u0004\b+\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010,R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010-R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010.R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010/R\u0016\u00101\u001a\u0002008\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b1\u00102R'\u0010:\u001a\u001503j\u0002`4\u00a2\u0006\f\b5\u0012\b\b6\u0012\u0004\b\t078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109R'\u0010<\u001a\u001503j\u0002`4\u00a2\u0006\f\b5\u0012\b\b6\u0012\u0004\b\t078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u00109R\u0014\u0010>\u001a\u0002038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u00109\u00a8\u0006@"}, d2={"Lme/jfenn/scoreboardoverhaul/common/hud/HudRenderer;", "", "Lme/jfenn/scoreboardoverhaul/common/config/ScoreboardConfig;", "config", "Lme/jfenn/scoreboardoverhaul/common/hud/HudState;", "state", "Lme/jfenn/scoreboardoverhaul/api/IOptionsAccessor;", "options", "Lme/jfenn/scoreboardoverhaul/api/IHudCallback;", "hudCallback", "<init>", "(Lme/jfenn/scoreboardoverhaul/common/config/ScoreboardConfig;Lme/jfenn/scoreboardoverhaul/common/hud/HudState;Lme/jfenn/scoreboardoverhaul/api/IOptionsAccessor;Lme/jfenn/scoreboardoverhaul/api/IHudCallback;)V", "", "updateVisibility", "()V", "", "shouldRenderFlicker", "()Z", "Lme/jfenn/scoreboardoverhaul/api/IDrawService;", "drawService", "Lme/jfenn/scoreboardoverhaul/common/data/ScoreInfo;", "score", "", "measureScoreWidth", "(Lme/jfenn/scoreboardoverhaul/api/IDrawService;Lme/jfenn/scoreboardoverhaul/common/data/ScoreInfo;)I", "x", "y", "hudWidth", "drawScoreEntry", "(Lme/jfenn/scoreboardoverhaul/api/IDrawService;Lme/jfenn/scoreboardoverhaul/common/data/ScoreInfo;III)V", "Lme/jfenn/scoreboardoverhaul/common/config/ResourceFrame;", "frame", "Lorg/joml/Vector2i;", "pos", "size", "drawFrame", "(Lme/jfenn/scoreboardoverhaul/api/IDrawService;Lme/jfenn/scoreboardoverhaul/common/config/ResourceFrame;Lorg/joml/Vector2i;Lorg/joml/Vector2i;)V", "Lme/jfenn/scoreboardoverhaul/common/data/ObjectiveInfo;", "objectiveInfo", "drawScoreTitle", "(Lme/jfenn/scoreboardoverhaul/api/IDrawService;Lme/jfenn/scoreboardoverhaul/common/data/ObjectiveInfo;II)V", "drawHud", "(Lme/jfenn/scoreboardoverhaul/api/IDrawService;)V", "init", "Lme/jfenn/scoreboardoverhaul/common/config/ScoreboardConfig;", "Lme/jfenn/scoreboardoverhaul/common/hud/HudState;", "Lme/jfenn/scoreboardoverhaul/api/IOptionsAccessor;", "Lme/jfenn/scoreboardoverhaul/api/IHudCallback;", "", "hudVisibility", "F", "Ljava/awt/Color;", "Lme/jfenn/scoreboardoverhaul/common/config/ColorType;", "Lkotlinx/serialization/Serializable;", "with", "Lme/jfenn/scoreboardoverhaul/common/config/ColorSerializer;", "getColorBackground", "()Ljava/awt/Color;", "colorBackground", "getColorUpdated", "colorUpdated", "getColorTransparent", "colorTransparent", "Companion", "scoreboardoverhaul"})
@SourceDebugExtension(value={"SMAP\nHudRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HudRenderer.kt\nme/jfenn/scoreboardoverhaul/common/hud/HudRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,244:1\n1#2:245\n1878#3,3:246\n*S KotlinDebug\n*F\n+ 1 HudRenderer.kt\nme/jfenn/scoreboardoverhaul/common/hud/HudRenderer\n*L\n220#1:246,3\n*E\n"})
public final class HudRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScoreboardConfig config;
    @NotNull
    private final HudState state;
    @NotNull
    private final IOptionsAccessor options;
    @NotNull
    private final IHudCallback hudCallback;
    private float hudVisibility;
    public static final int SIDEBAR_ENTRY_HEIGHT = 11;
    public static final int SIDEBAR_ENTRY_MARGIN = 4;
    private static final Duration UPDATE_HIGHLIGHT_TIME = Duration.ofSeconds(3L);

    public HudRenderer(@NotNull ScoreboardConfig config, @NotNull HudState state, @NotNull IOptionsAccessor options, @NotNull IHudCallback hudCallback) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)hudCallback, (String)"hudCallback");
        this.config = config;
        this.state = state;
        this.options = options;
        this.hudCallback = hudCallback;
        this.hudVisibility = 1.0f;
    }

    private final Color getColorBackground() {
        return this.config.getBackgroundColor();
    }

    private final Color getColorUpdated() {
        return this.config.getUpdateHighlightColor();
    }

    private final Color getColorTransparent() {
        return new Color(this.getColorUpdated().getRed(), this.getColorUpdated().getGreen(), this.getColorUpdated().getBlue(), 0);
    }

    private final void updateVisibility() {
        this.hudVisibility = LerpKt.lerpNumber(Float.valueOf(this.hudVisibility), Float.valueOf(this.state.isVisible() ? 1.0f : 0.0f), 0.25f);
        if (!(Math.abs(this.hudVisibility) <= Float.MAX_VALUE)) {
            this.hudVisibility = 0.0f;
        }
    }

    private final boolean shouldRenderFlicker() {
        return (int)(Instant.now().toEpochMilli() % 500L) < 100;
    }

    private final int measureScoreWidth(IDrawService drawService, ScoreInfo score) {
        class_2561 scoreValue = this.state.getRenderType().format(score.getValue(), this.state.isExpanded() || !this.config.getTruncateScoreValues());
        int scoreValueWidth = drawService.getFont().getTextWidth(scoreValue);
        int textWidth = drawService.getFont().getTextWidth(score.getDisplayName());
        return scoreValueWidth + textWidth + 12;
    }

    private final void drawScoreEntry(IDrawService drawService, ScoreInfo score, int x, int y, int hudWidth) {
        Duration timeSinceUpdated = Duration.between(score.getUpdatedAt(), Instant.now());
        float ratio = (float)timeSinceUpdated.toMillis() / (float)UPDATE_HIGHLIGHT_TIME.toMillis();
        if (ratio < 1.0f) {
            if (this.config.getUpdateHighlight()) {
                int fillColor = ColorKt.lerpTo(this.getColorUpdated(), this.getColorTransparent(), ratio).getRGB();
                drawService.fill(x, y, x + hudWidth, y + 11, fillColor);
            }
            if (this.config.getUpdateFlicker() && this.shouldRenderFlicker()) {
                return;
            }
        }
        class_2561 scoreValue = this.state.getRenderType().format(score.getValue(), this.state.isExpanded() || !this.config.getTruncateScoreValues());
        int scoreValueWidth = drawService.getFont().getTextWidth(scoreValue);
        drawService.drawText(scoreValue, x + hudWidth - 4 - scoreValueWidth, y + 1, -1, this.config.getTextShadow());
        int textWidth = drawService.getFont().getTextWidth(score.getDisplayName());
        int textWidthMax = hudWidth - 12 - scoreValueWidth;
        class_2561 text = textWidth > textWidthMax ? drawService.getFont().truncate(score.getDisplayName(), textWidthMax) : score.getDisplayName();
        drawService.drawText(text, x + 4, y + 1, -1, this.config.getTextShadow());
    }

    private final void drawFrame(IDrawService drawService, ResourceFrame frame, Vector2i pos, Vector2i size) {
        drawService.draw();
        drawService.setBlend(true);
        String string = frame.getTexture();
        if (string != null) {
            String frameTexture = string;
            boolean bl = false;
            drawService.drawNinePatch(frameTexture, pos, size, frame.getBorder().getVec(), frame.getWidth(), frame.getHeight());
        }
        if (this.state.getFrameColor().getAlpha() > 11 && frame.getColorMask() != null) {
            drawService.draw();
            drawService.setColorTint(this.state.getFrameColor());
            drawService.drawNinePatch(frame.getColorMask(), pos, size, frame.getBorder().getVec(), frame.getWidth(), frame.getHeight());
        }
        drawService.draw();
        Color color = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"WHITE");
        drawService.setColorTint(color);
        drawService.setBlend(false);
    }

    private final void drawScoreTitle(IDrawService drawService, ObjectiveInfo objectiveInfo, int x, int y) {
        int textWidth = drawService.getFont().getTextWidth(objectiveInfo.getDisplayName());
        int textHeight = drawService.getFont().getTextHeight();
        Rect titlePadding = this.state.getFrameResource().getTitle().getPadding();
        int titleX = x - textWidth / 2;
        int titleY = y - textHeight / 2;
        this.drawFrame(drawService, this.state.getFrameResource().getTitle(), new Vector2i(titleX - titlePadding.getLeft(), titleY - titlePadding.getTop()), new Vector2i(textWidth + titlePadding.getLeft() + titlePadding.getRight(), textHeight + titlePadding.getTop() + titlePadding.getBottom()));
        drawService.drawText(objectiveInfo.getDisplayName(), titleX, titleY, -1, this.config.getTextShadow());
    }

    /*
     * WARNING - void declaration
     */
    private final void drawHud(IDrawService drawService) {
        Object object;
        if (this.hudVisibility < 0.01f) {
            return;
        }
        ObjectiveInfo objectiveInfo = this.state.getObjectiveInfo();
        if (objectiveInfo == null) {
            return;
        }
        ObjectiveInfo objectiveInfo2 = objectiveInfo;
        if (this.options.isDebugEnabled()) {
            return;
        }
        drawService.getMatrices().push();
        drawService.getMatrices().scale(this.config.getScaleFloat(), this.config.getScaleFloat(), this.config.getScaleFloat());
        float windowWidth = (float)drawService.getWindow().getScaledWindowWidth() / this.config.getScaleFloat();
        float windowHeight = (float)drawService.getWindow().getScaledWindowHeight() / this.config.getScaleFloat();
        Rect titlePadding = this.state.getFrameResource().getTitle().getPadding();
        Rect scorePadding = this.state.getFrameResource().getFrame().getPadding();
        int titleWidth = drawService.getFont().getTextWidth(objectiveInfo2.getDisplayName()) + titlePadding.getLeft() + titlePadding.getRight();
        Iterator iterator = ((Iterable)this.state.getScores()).iterator();
        if (!iterator.hasNext()) {
            object = null;
        } else {
            Object it = (ScoreInfo)iterator.next();
            boolean bl = false;
            it = this.measureScoreWidth(drawService, (ScoreInfo)it);
            while (iterator.hasNext()) {
                Object it2 = (ScoreInfo)iterator.next();
                $i$a$-maxOfOrNull-HudRenderer$drawHud$scoreWidthMax$1 = false;
                if (it.compareTo(it2 = (Comparable)Integer.valueOf(this.measureScoreWidth(drawService, (ScoreInfo)it2))) >= 0) continue;
                it = it2;
            }
            object = it;
        }
        Integer n = (Integer)object;
        int scoreWidthMax = n != null ? n : titleWidth;
        int hudWidth = scorePadding.getLeft() + scorePadding.getRight() + Math.max(titleWidth, this.state.isExpanded() || !this.config.getTruncateScoreNames() ? Math.max(this.config.getMinWidth(), scoreWidthMax) : Math.min(this.config.getMaxWidth(), scoreWidthMax));
        int hudHeight = this.state.getScores().size() * 11 + scorePadding.getTop() + scorePadding.getBottom() + 8;
        float positionX = RangesKt.coerceIn((float)((float)this.config.getPositionX() / 100.0f * windowWidth - (float)(hudWidth / 2)), (float)scorePadding.getLeft(), (float)(windowWidth - (float)hudWidth - (float)scorePadding.getRight()));
        float positionY = RangesKt.coerceIn((float)((float)this.config.getPositionY() / 100.0f * windowHeight - (float)(hudHeight / 2)), (float)((float)scorePadding.getTop() + (float)12), (float)(windowHeight - (float)hudHeight - (float)scorePadding.getBottom()));
        Integer offScreenX = this.config.getPositionX() > 50 ? (Number)Float.valueOf(windowWidth + (float)hudWidth) : (Number)(-hudWidth);
        int hudX = MathKt.roundToInt((float)LerpKt.lerpNumber(offScreenX, Float.valueOf(positionX), this.hudVisibility));
        int hudY = (int)positionY;
        int hudBgInset = 4;
        drawService.fill(hudX + hudBgInset, hudY + hudBgInset, hudX + hudWidth - hudBgInset, hudY + hudHeight - hudBgInset, this.getColorBackground().getRGB());
        this.drawFrame(drawService, this.state.getFrameResource().getFrame(), new Vector2i(hudX, hudY), new Vector2i(hudWidth, hudHeight));
        Iterable $this$forEachIndexed$iv = this.state.getScores();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void score;
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ScoreInfo scoreInfo = (ScoreInfo)item$iv;
            int i = n2;
            boolean bl = false;
            this.drawScoreEntry(drawService, (ScoreInfo)score, hudX + scorePadding.getLeft(), hudY + scorePadding.getTop() + 4 + i * 11, hudWidth - scorePadding.getLeft() - scorePadding.getRight());
        }
        this.drawScoreTitle(drawService, objectiveInfo2, hudX + hudWidth / 2, hudY);
        drawService.draw();
        drawService.getMatrices().pop();
    }

    public final void init() {
        this.hudCallback.getOnRender().invoke((Function1<IHudCallback.RenderEvent, Unit>)((Function1)arg_0 -> HudRenderer.init$lambda$3(this, arg_0)));
    }

    private static final Unit init$lambda$3(HudRenderer this$0, IHudCallback.RenderEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!this$0.config.isEnabled()) {
            return Unit.INSTANCE;
        }
        if (this$0.options.isHudHidden()) {
            return Unit.INSTANCE;
        }
        this$0.updateVisibility();
        this$0.drawHud(it.getDrawService());
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u001f\u0010\n\u001a\n \t*\u0004\u0018\u00010\b0\b8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lme/jfenn/scoreboardoverhaul/common/hud/HudRenderer$Companion;", "", "<init>", "()V", "", "SIDEBAR_ENTRY_HEIGHT", "I", "SIDEBAR_ENTRY_MARGIN", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "UPDATE_HIGHLIGHT_TIME", "Ljava/time/Duration;", "getUPDATE_HIGHLIGHT_TIME", "()Ljava/time/Duration;", "scoreboardoverhaul"})
    public static final class Companion {
        private Companion() {
        }

        public final Duration getUPDATE_HIGHLIGHT_TIME() {
            return UPDATE_HIGHLIGHT_TIME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

