/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.scoreboardoverhaul.common.hud;

import java.awt.Color;
import java.io.Closeable;
import java.io.InputStream;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JvmStreamsKt;
import me.jfenn.scoreboardoverhaul.api.IClientSoundManager;
import me.jfenn.scoreboardoverhaul.api.IKeyBinding;
import me.jfenn.scoreboardoverhaul.api.IKeyBindingManager;
import me.jfenn.scoreboardoverhaul.api.IOptionsAccessor;
import me.jfenn.scoreboardoverhaul.api.IScoreboardAccessor;
import me.jfenn.scoreboardoverhaul.common.MainKt;
import me.jfenn.scoreboardoverhaul.common.config.ResourceEntry;
import me.jfenn.scoreboardoverhaul.common.config.ScoreboardConfig;
import me.jfenn.scoreboardoverhaul.common.data.ObjectiveInfo;
import me.jfenn.scoreboardoverhaul.common.data.ScoreInfo;
import me.jfenn.scoreboardoverhaul.common.data.ScoreRenderType;
import me.jfenn.scoreboardoverhaul.common.hud.HudState;
import me.jfenn.scoreboardoverhaul.common.utils.FrequencySampler;
import me.jfenn.scoreboardoverhaul.common.utils.JsonKt;
import me.jfenn.scoreboardoverhaul.common.utils.TextKt;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013JC\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ7\u0010\u001c\u001a\u00020\u001b2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u0013J\r\u0010\u001f\u001a\u00020\u0011\u00a2\u0006\u0004\b\u001f\u0010\u0013R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010 R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010!R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\"R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010#R\u001c\u0010&\u001a\n %*\u0004\u0018\u00010$0$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0014\u0010)\u001a\u00020(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R\"\u0010+\u001a\u00020\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b+\u0010,\u001a\u0004\b+\u0010-\"\u0004\b.\u0010/R\"\u00100\u001a\u00020\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b0\u0010,\u001a\u0004\b0\u0010-\"\u0004\b1\u0010/R$\u00103\u001a\u0004\u0018\u0001028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b3\u00104\u001a\u0004\b5\u00106\"\u0004\b7\u00108R.\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b9\u0010:\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\"\u0010@\u001a\u00020?8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b@\u0010A\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER\"\u0010F\u001a\u00020?8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bF\u0010A\u001a\u0004\bG\u0010C\"\u0004\bH\u0010ER(\u0010K\u001a\b\u0012\u0004\u0012\u00020J0I8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bK\u0010L\u001a\u0004\bM\u0010N\"\u0004\bO\u0010PR\"\u0010Q\u001a\u00020J8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bQ\u0010R\u001a\u0004\bS\u0010T\"\u0004\bU\u0010VR\"\u0010X\u001a\u00020W8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bX\u0010Y\u001a\u0004\bZ\u0010[\"\u0004\b\\\u0010]R\u0014\u0010_\u001a\u00020^8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b_\u0010`R\u0014\u0010b\u001a\u00020a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bb\u0010cR\u0014\u0010d\u001a\u00020a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bd\u0010cR\"\u0010e\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00148\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\be\u0010:R\u0018\u0010f\u001a\u0004\u0018\u00010?8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bf\u0010AR\u001e\u0010h\u001a\n %*\u0004\u0018\u00010g0g8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bh\u0010iR\u001c\u0010l\u001a\n %*\u0004\u0018\u00010g0g8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bj\u0010kR\u0017\u0010n\u001a\b\u0012\u0004\u0012\u00020\u00160I8F\u00a2\u0006\u0006\u001a\u0004\bm\u0010N\u00a8\u0006o"}, d2={"Lme/jfenn/scoreboardoverhaul/common/hud/HudState;", "", "Lme/jfenn/scoreboardoverhaul/common/config/ScoreboardConfig;", "config", "Lme/jfenn/scoreboardoverhaul/api/IScoreboardAccessor;", "scoreboardAccessor", "Lme/jfenn/scoreboardoverhaul/api/IClientSoundManager;", "soundManager", "Lme/jfenn/scoreboardoverhaul/api/IOptionsAccessor;", "optionsAccessor", "Lme/jfenn/scoreboardoverhaul/api/IKeyBindingManager;", "keyBindingManager", "<init>", "(Lme/jfenn/scoreboardoverhaul/common/config/ScoreboardConfig;Lme/jfenn/scoreboardoverhaul/api/IScoreboardAccessor;Lme/jfenn/scoreboardoverhaul/api/IClientSoundManager;Lme/jfenn/scoreboardoverhaul/api/IOptionsAccessor;Lme/jfenn/scoreboardoverhaul/api/IKeyBindingManager;)V", "Lme/jfenn/scoreboardoverhaul/common/data/ScoreRenderType;", "getRenderType", "()Lme/jfenn/scoreboardoverhaul/common/data/ScoreRenderType;", "", "updateVisibility", "()V", "", "", "Lme/jfenn/scoreboardoverhaul/common/data/ScoreInfo;", "previousEntries", "newEntries", "dedupeScores", "(Ljava/util/Map;Ljava/util/Map;)Ljava/util/Map;", "", "compareEntries", "(Ljava/util/Map;Ljava/util/Map;)Z", "updateState", "init", "Lme/jfenn/scoreboardoverhaul/common/config/ScoreboardConfig;", "Lme/jfenn/scoreboardoverhaul/api/IScoreboardAccessor;", "Lme/jfenn/scoreboardoverhaul/api/IClientSoundManager;", "Lme/jfenn/scoreboardoverhaul/api/IOptionsAccessor;", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "log", "Lorg/slf4j/Logger;", "Lme/jfenn/scoreboardoverhaul/api/IKeyBinding;", "scoreboardExpandKey", "Lme/jfenn/scoreboardoverhaul/api/IKeyBinding;", "isVisible", "Z", "()Z", "setVisible", "(Z)V", "isExpanded", "setExpanded", "Lme/jfenn/scoreboardoverhaul/common/data/ObjectiveInfo;", "objectiveInfo", "Lme/jfenn/scoreboardoverhaul/common/data/ObjectiveInfo;", "getObjectiveInfo", "()Lme/jfenn/scoreboardoverhaul/common/data/ObjectiveInfo;", "setObjectiveInfo", "(Lme/jfenn/scoreboardoverhaul/common/data/ObjectiveInfo;)V", "entries", "Ljava/util/Map;", "getEntries", "()Ljava/util/Map;", "setEntries", "(Ljava/util/Map;)V", "Ljava/time/Instant;", "updatedAt", "Ljava/time/Instant;", "getUpdatedAt", "()Ljava/time/Instant;", "setUpdatedAt", "(Ljava/time/Instant;)V", "changedAt", "getChangedAt", "setChangedAt", "", "Lme/jfenn/scoreboardoverhaul/common/config/ResourceEntry;", "frameResourceConfig", "Ljava/util/List;", "getFrameResourceConfig", "()Ljava/util/List;", "setFrameResourceConfig", "(Ljava/util/List;)V", "frameResource", "Lme/jfenn/scoreboardoverhaul/common/config/ResourceEntry;", "getFrameResource", "()Lme/jfenn/scoreboardoverhaul/common/config/ResourceEntry;", "setFrameResource", "(Lme/jfenn/scoreboardoverhaul/common/config/ResourceEntry;)V", "Ljava/awt/Color;", "frameColor", "Ljava/awt/Color;", "getFrameColor", "()Ljava/awt/Color;", "setFrameColor", "(Ljava/awt/Color;)V", "", "frequencyThreshold", "F", "Lme/jfenn/scoreboardoverhaul/common/utils/FrequencySampler;", "frequencyById", "Lme/jfenn/scoreboardoverhaul/common/utils/FrequencySampler;", "frequencyByScore", "debounceEntries", "debounceTime", "Ljava/time/Duration;", "debounceDuration", "Ljava/time/Duration;", "getUpdateVisibleTime", "()Ljava/time/Duration;", "updateVisibleTime", "getScores", "scores", "scoreboardoverhaul"})
@SourceDebugExtension(value={"SMAP\nHudState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HudState.kt\nme/jfenn/scoreboardoverhaul/common/hud/HudState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,344:1\n1068#2:345\n1563#2:346\n1634#2,3:347\n1761#2,3:350\n827#2:353\n855#2,2:354\n1252#2,4:358\n1208#2,2:385\n1236#2,4:387\n774#2:391\n865#2,2:392\n2756#2:394\n2756#2:396\n465#3:356\n415#3:357\n538#3:362\n523#3,6:363\n538#3:369\n523#3,6:370\n538#3:376\n523#3,6:377\n1#4:383\n1#4:395\n1#4:397\n622#5:384\n*S KotlinDebug\n*F\n+ 1 HudState.kt\nme/jfenn/scoreboardoverhaul/common/hud/HudState\n*L\n70#1:345\n77#1:346\n77#1:347,3\n85#1:350,3\n94#1:353\n94#1:354,2\n135#1:358,4\n240#1:385,2\n240#1:387,4\n245#1:391\n245#1:392,2\n246#1:394\n259#1:396\n135#1:356\n135#1:357\n180#1:362\n180#1:363,6\n181#1:369\n181#1:370,6\n184#1:376\n184#1:377,6\n246#1:395\n259#1:397\n234#1:384\n*E\n"})
public final class HudState {
    @NotNull
    private final ScoreboardConfig config;
    @NotNull
    private final IScoreboardAccessor scoreboardAccessor;
    @NotNull
    private final IClientSoundManager soundManager;
    @NotNull
    private final IOptionsAccessor optionsAccessor;
    private final Logger log;
    @NotNull
    private final IKeyBinding scoreboardExpandKey;
    private boolean isVisible;
    private boolean isExpanded;
    @Nullable
    private ObjectiveInfo objectiveInfo;
    @NotNull
    private Map<String, ScoreInfo> entries;
    @NotNull
    private Instant updatedAt;
    @NotNull
    private Instant changedAt;
    @NotNull
    private List<ResourceEntry> frameResourceConfig;
    @NotNull
    private ResourceEntry frameResource;
    @NotNull
    private Color frameColor;
    private final float frequencyThreshold;
    @NotNull
    private final FrequencySampler frequencyById;
    @NotNull
    private final FrequencySampler frequencyByScore;
    @NotNull
    private Map<String, ScoreInfo> debounceEntries;
    @Nullable
    private Instant debounceTime;
    private Duration debounceDuration;

    public HudState(@NotNull ScoreboardConfig config, @NotNull IScoreboardAccessor scoreboardAccessor, @NotNull IClientSoundManager soundManager, @NotNull IOptionsAccessor optionsAccessor, @NotNull IKeyBindingManager keyBindingManager) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)scoreboardAccessor, (String)"scoreboardAccessor");
        Intrinsics.checkNotNullParameter((Object)soundManager, (String)"soundManager");
        Intrinsics.checkNotNullParameter((Object)optionsAccessor, (String)"optionsAccessor");
        Intrinsics.checkNotNullParameter((Object)keyBindingManager, (String)"keyBindingManager");
        this.config = config;
        this.scoreboardAccessor = scoreboardAccessor;
        this.soundManager = soundManager;
        this.optionsAccessor = optionsAccessor;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.scoreboardExpandKey = keyBindingManager.registerKey("key.scoreboard-overhaul.expand", -1, "category.scoreboard-overhaul");
        this.isVisible = true;
        this.entries = MapsKt.emptyMap();
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        this.updatedAt = instant;
        Instant instant2 = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
        this.changedAt = instant2;
        this.frameResourceConfig = CollectionsKt.emptyList();
        this.frameResource = ResourceEntry.Companion.getDEFAULT();
        Color color = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"WHITE");
        this.frameColor = color;
        this.frequencyThreshold = 0.04f;
        this.frequencyById = new FrequencySampler(200);
        this.frequencyByScore = new FrequencySampler(200);
        this.debounceEntries = MapsKt.emptyMap();
        this.debounceDuration = Duration.ofMillis(500L);
    }

    public final boolean isVisible() {
        return this.isVisible;
    }

    public final void setVisible(boolean bl) {
        this.isVisible = bl;
    }

    public final boolean isExpanded() {
        return this.isExpanded;
    }

    public final void setExpanded(boolean bl) {
        this.isExpanded = bl;
    }

    @Nullable
    public final ObjectiveInfo getObjectiveInfo() {
        return this.objectiveInfo;
    }

    public final void setObjectiveInfo(@Nullable ObjectiveInfo objectiveInfo) {
        this.objectiveInfo = objectiveInfo;
    }

    @NotNull
    public final Map<String, ScoreInfo> getEntries() {
        return this.entries;
    }

    public final void setEntries(@NotNull Map<String, ScoreInfo> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.entries = map;
    }

    @NotNull
    public final Instant getUpdatedAt() {
        return this.updatedAt;
    }

    public final void setUpdatedAt(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
        this.updatedAt = instant;
    }

    @NotNull
    public final Instant getChangedAt() {
        return this.changedAt;
    }

    public final void setChangedAt(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
        this.changedAt = instant;
    }

    @NotNull
    public final List<ResourceEntry> getFrameResourceConfig() {
        return this.frameResourceConfig;
    }

    public final void setFrameResourceConfig(@NotNull List<ResourceEntry> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.frameResourceConfig = list;
    }

    @NotNull
    public final ResourceEntry getFrameResource() {
        return this.frameResource;
    }

    public final void setFrameResource(@NotNull ResourceEntry resourceEntry) {
        Intrinsics.checkNotNullParameter((Object)resourceEntry, (String)"<set-?>");
        this.frameResource = resourceEntry;
    }

    @NotNull
    public final Color getFrameColor() {
        return this.frameColor;
    }

    public final void setFrameColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.frameColor = color;
    }

    private final Duration getUpdateVisibleTime() {
        return Duration.ofSeconds(this.config.getShowDuration());
    }

    @NotNull
    public final List<ScoreInfo> getScores() {
        Iterable $this$sortedByDescending$iv = this.entries.values();
        boolean $i$f$sortedByDescending = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ScoreInfo it = (ScoreInfo)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getValue());
                it = (ScoreInfo)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getValue()));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScoreRenderType getRenderType() {
        Object object;
        void $this$mapTo$iv$iv;
        if (this.config.getShowScoreValues() == ScoreboardConfig.ShowScores.Never) {
            return ScoreRenderType.Blank.INSTANCE;
        }
        Iterable $this$map$iv = this.entries.values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ScoreInfo scoreInfo = (ScoreInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getValue());
        }
        List scoreNumbers = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        Integer scoreMin = (Integer)CollectionsKt.firstOrNull((List)scoreNumbers);
        if (this.config.getShowScoreValues() == ScoreboardConfig.ShowScores.Auto) {
            ObjectiveInfo objectiveInfo = this.objectiveInfo;
            if ((objectiveInfo != null ? objectiveInfo.getRenderType() : null) instanceof ScoreRenderType.Number) {
                boolean bl;
                Iterable $this$any$iv;
                block12: {
                    $this$any$iv = this.getScores();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            ScoreInfo it = (ScoreInfo)element$iv;
                            boolean bl2 = false;
                            if (!TextKt.isBlank(it.getDisplayName())) continue;
                            bl = true;
                            break block12;
                        }
                        bl = false;
                    }
                }
                if (bl && this.getScores().size() > 1) {
                    $this$any$iv = new IntRange(0, 1);
                    if (scoreMin != null && $this$any$iv.contains(scoreMin)) {
                        void $this$filterNotTo$iv$iv;
                        Iterable $this$filterNot$iv = CollectionsKt.drop((Iterable)CollectionsKt.withIndex((Iterable)scoreNumbers), (int)1);
                        boolean $i$f$filterNot = false;
                        destination$iv$iv = $this$filterNot$iv;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$filterNotTo = false;
                        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                            IndexedValue indexedValue = (IndexedValue)element$iv$iv;
                            boolean bl3 = false;
                            int i = indexedValue.component1();
                            int value = ((Number)indexedValue.component2()).intValue();
                            if (((Number)scoreNumbers.get(i - 1)).intValue() + 1 == value) continue;
                            destination$iv$iv2.add(element$iv$iv);
                        }
                        if (((List)destination$iv$iv2).size() < 2) {
                            return ScoreRenderType.Blank.INSTANCE;
                        }
                    }
                }
            }
        }
        if ((object = this.objectiveInfo) == null || (object = ((ObjectiveInfo)object).getRenderType()) == null) {
            object = new ScoreRenderType.Number(null, null, 3, null);
        }
        return object;
    }

    private final void updateVisibility() {
        boolean isManuallyOpened;
        if (this.objectiveInfo == null || MainKt.getClient().field_1687 == null) {
            this.isVisible = false;
            return;
        }
        this.isExpanded = isManuallyOpened = this.scoreboardExpandKey.isPressed() || this.optionsAccessor.isPlayerListPressed();
        if (isManuallyOpened || this.config.isAlwaysVisible()) {
            this.isVisible = true;
            return;
        }
        Duration timeSinceUpdated = Duration.between(this.changedAt, Instant.now());
        boolean isVisible = timeSinceUpdated.compareTo(this.getUpdateVisibleTime()) < 0;
        if (isVisible && !this.isVisible) {
            IClientSoundManager.DefaultImpls.play$default(this.soundManager, this.soundManager.getUiToastIn(), this.config.getShowVolume(), 0.0f, 4, null);
        } else if (!isVisible && this.isVisible) {
            IClientSoundManager.DefaultImpls.play$default(this.soundManager, this.soundManager.getUiToastOut(), this.config.getShowVolume(), 0.0f, 4, null);
        }
        this.isVisible = isVisible;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, ScoreInfo> dedupeScores(Map<String, ScoreInfo> previousEntries, Map<String, ScoreInfo> newEntries) {
        void $this$mapValuesTo$iv$iv;
        Map<String, ScoreInfo> $this$mapValues$iv = newEntries;
        boolean $i$f$mapValues = false;
        Map<String, ScoreInfo> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            ScoreInfo score = (ScoreInfo)entry2.getValue();
            ScoreInfo scoreInfo = ScoreInfo.copy$default(score, null, null, 0, null, 15, null);
            map3.put(k, scoreInfo);
        }
        Map ret = destination$iv$iv;
        for (ScoreInfo score : ret.values()) {
            ScoreInfo prevScore = previousEntries.get(score.getId());
            if (prevScore == null || !TextKt.equalsIgnoringFormatting(prevScore.getDisplayName(), score.getDisplayName()) || !Intrinsics.areEqual((Object)this.getRenderType(), (Object)ScoreRenderType.Blank.INSTANCE) && prevScore.getValue() != score.getValue()) continue;
            score.setUpdatedAt(prevScore.getUpdatedAt());
        }
        return ret;
    }

    private final boolean compareEntries(Map<String, ScoreInfo> previousEntries, Map<String, ScoreInfo> newEntries) {
        boolean isScoreRemoved;
        ScoreInfo entry;
        Map.Entry entry2;
        boolean bl;
        Map.Entry element$iv$iv;
        Map $this$filterTo$iv$iv;
        boolean isDirty = false;
        for (ScoreInfo scoreInfo : newEntries.values()) {
            ScoreInfo prevScore = previousEntries.get(scoreInfo.getId());
            if (prevScore != null && TextKt.equalsIgnoringFormatting(prevScore.getDisplayName(), scoreInfo.getDisplayName()) && (Intrinsics.areEqual((Object)this.getRenderType(), (Object)ScoreRenderType.Blank.INSTANCE) || prevScore.getValue() == scoreInfo.getValue()) || this.frequencyById.isAboveThreshold(scoreInfo.getId(), this.frequencyThreshold) || this.frequencyByScore.isAboveThreshold(String.valueOf(scoreInfo.getValue()), this.frequencyThreshold)) continue;
            isDirty = true;
        }
        Map<String, ScoreInfo> map = previousEntries;
        boolean $i$f$filter = false;
        Map<String, ScoreInfo> map2 = map;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry it = element$iv$iv = iterator.next();
            bl = false;
            if (!(!newEntries.containsKey(it.getKey()))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map map3 = destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = map3;
        destination$iv$iv = new LinkedHashMap();
        $i$f$filterTo = false;
        iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry2 = element$iv$iv = iterator.next();
            bl = false;
            entry = (ScoreInfo)entry2.getValue();
            if (!(!this.frequencyById.isAboveThreshold(entry.getId(), this.frequencyThreshold))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map map4 = destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = map4;
        destination$iv$iv = new LinkedHashMap();
        $i$f$filterTo = false;
        iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry2 = element$iv$iv = iterator.next();
            bl = false;
            entry = (ScoreInfo)entry2.getValue();
            if (!(!this.frequencyByScore.isAboveThreshold(String.valueOf(entry.getValue()), this.frequencyThreshold))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        boolean bl2 = isScoreRemoved = !destination$iv$iv.isEmpty();
        if (isScoreRemoved) {
            isDirty = true;
        }
        return isDirty;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateState() {
        Iterable $this$sortedByDescending$iv;
        Color color;
        Object object;
        this.frequencyById.tick();
        this.frequencyByScore.tick();
        ObjectiveInfo objectiveInfo = this.scoreboardAccessor.getSidebarObjective();
        boolean isDirty = false;
        if (!Intrinsics.areEqual((Object)objectiveInfo, (Object)this.objectiveInfo)) {
            this.frequencyById.clear();
            this.frequencyByScore.clear();
            this.objectiveInfo = objectiveInfo;
            isDirty = true;
        }
        HudState hudState = this;
        switch (WhenMappings.$EnumSwitchMapping$0[this.config.getFrameColorBehavior().ordinal()]) {
            case 1: {
                Integer n;
                class_124 class_1242 = this.scoreboardAccessor.getTeamColor();
                if (class_1242 != null && (n = class_1242.method_532()) != null) {
                    void it;
                    int n2 = ((Number)n).intValue();
                    object = hudState;
                    boolean bl = false;
                    color = new Color((int)it, false);
                    hudState = object;
                    break;
                }
                color = new Color(0, true);
                break;
            }
            case 2: {
                color = this.config.getFrameColorValue();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        hudState.frameColor = color;
        Sequence sequence = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.frameResourceConfig), arg_0 -> HudState.updateState$lambda$9(this, arg_0)), arg_0 -> HudState.updateState$lambda$10(this, arg_0)), arg_0 -> HudState.updateState$lambda$11(objectiveInfo, arg_0));
        boolean $i$f$sortedByDescending = false;
        ResourceEntry resourceEntry = (ResourceEntry)SequencesKt.firstOrNull((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ResourceEntry it = (ResourceEntry)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getPriority());
                it = (ResourceEntry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPriority()));
            }
        }));
        if (resourceEntry == null) {
            resourceEntry = this.frameResource = ResourceEntry.Companion.getDEFAULT();
        }
        if (objectiveInfo != null) {
            ScoreInfo score;
            void $this$onEach$iv;
            void var6_9;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$associateByTo$iv$iv;
            Iterable $this$associateBy$iv;
            $this$sortedByDescending$iv = this.scoreboardAccessor.getScoreList(objectiveInfo);
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            void var7_17 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                ScoreInfo scoreInfo = (ScoreInfo)element$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.put(it.getId(), element$iv$iv);
            }
            Map it = destination$iv$iv;
            boolean $i$a$-let-HudState$updateState$newEntries$32 = false;
            Map<String, ScoreInfo> newEntries = this.dedupeScores(this.entries, it);
            $this$associateBy$iv = newEntries.values();
            boolean $i$f$filter = false;
            void $i$a$-let-HudState$updateState$newEntries$32 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ScoreInfo it2 = (ScoreInfo)element$iv$iv;
                boolean bl = false;
                if (!(it2.getUpdatedAt().compareTo(this.updatedAt) > 0)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$onEach = false;
            void $this$onEach_u24lambda_u2418$iv = var6_9 = $this$onEach$iv;
            boolean bl = false;
            for (Object element$iv : $this$onEach_u24lambda_u2418$iv) {
                score = (ScoreInfo)element$iv;
                boolean bl2 = false;
                if (!this.frequencyById.isAboveThreshold(score.getId(), this.frequencyThreshold) && !this.frequencyByScore.isAboveThreshold(String.valueOf(score.getValue()), this.frequencyThreshold)) continue;
                Object object2 = this.entries.get(score.getId());
                if (object2 == null || (object2 = ((ScoreInfo)object2).getUpdatedAt()) == null) {
                    Object v4;
                    block22: {
                        Iterable iterable = this.getScores();
                        for (Object t : iterable) {
                            ScoreInfo it3 = (ScoreInfo)t;
                            boolean bl3 = false;
                            if (!(it3.getValue() == score.getValue())) continue;
                            v4 = t;
                            break block22;
                        }
                        v4 = null;
                    }
                    ScoreInfo scoreInfo = v4;
                    object2 = scoreInfo != null ? scoreInfo.getUpdatedAt() : score.getUpdatedAt().minus(Duration.ofMinutes(1L));
                }
                Object updatedAt = object2;
                score.setUpdatedAt((Instant)updatedAt);
            }
            $this$onEach$iv = var6_9;
            $i$f$onEach = false;
            $this$onEach_u24lambda_u2418$iv = var6_9 = $this$onEach$iv;
            bl = false;
            for (Object element$iv : $this$onEach_u24lambda_u2418$iv) {
                score = (ScoreInfo)element$iv;
                boolean bl4 = false;
                this.frequencyById.addHit(score.getId());
                this.frequencyByScore.addHit(String.valueOf(score.getValue()));
            }
            boolean isChanged = this.compareEntries(this.debounceEntries, newEntries);
            if (isChanged) {
                boolean bl5;
                if (this.debounceTime == null) {
                    this.debounceTime = Instant.now();
                }
                Instant instant = this.debounceTime;
                if (instant != null) {
                    Instant it4 = instant;
                    boolean bl6 = false;
                    bl5 = Duration.between(it4, Instant.now()).compareTo(this.debounceDuration) > 0;
                } else {
                    bl5 = false;
                }
                if (bl5) {
                    if (this.config.getShowOnUpdate()) {
                        isDirty = true;
                    }
                    this.debounceEntries = newEntries;
                    this.debounceTime = null;
                }
            } else {
                this.debounceEntries = newEntries;
                this.debounceTime = null;
            }
            this.entries = newEntries;
        }
        this.updatedAt = Instant.now();
        if (isDirty) {
            this.changedAt = Instant.now();
        }
    }

    public final void init() {
        ClientTickEvents.END_CLIENT_TICK.register(arg_0 -> HudState.init$lambda$20(this, arg_0));
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(this){
            final /* synthetic */ HudState this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void method_14491(class_3300 manager) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
                Iterable iterable = manager.method_41265("scoreboard-overhaul/rules", init.2::reload$lambda$0).values();
                HudState hudState = this.this$0;
                HudState hudState2 = this.this$0;
                boolean $i$f$mapNotNull = false;
                void var5_6 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Closeable it$iv$iv;
                    Object object;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    List it = (List)element$iv$iv;
                    boolean bl2 = false;
                    try {
                        ResourceEntry resourceEntry;
                        Intrinsics.checkNotNull((Object)it);
                        object = ((class_3298)CollectionsKt.last((List)it)).method_14482();
                        Throwable throwable = null;
                        try {
                            void $this$decodeFromStream$iv;
                            InputStream it2 = (InputStream)object;
                            boolean bl3 = false;
                            Json json = JsonKt.getJson();
                            Intrinsics.checkNotNull((Object)it2);
                            InputStream stream$iv = it2;
                            boolean $i$f$decodeFromStream = false;
                            $this$decodeFromStream$iv.getSerializersModule();
                            resourceEntry = (ResourceEntry)JvmStreamsKt.decodeFromStream((Json)$this$decodeFromStream$iv, (DeserializationStrategy)((DeserializationStrategy)ResourceEntry.Companion.serializer()), (InputStream)stream$iv);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                        }
                        object = resourceEntry;
                    }
                    catch (Throwable e) {
                        HudState.access$getLog$p(hudState).error("Error reading scoreboard_rules.json", e);
                        object = null;
                    }
                    if (object == null) continue;
                    boolean bl4 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                hudState2.setFrameResourceConfig((List)destination$iv$iv);
            }

            public class_2960 getFabricId() {
                class_2960 class_29602 = class_2960.method_43902((String)"scoreboard-overhaul", (String)"hud");
                Intrinsics.checkNotNull((Object)class_29602);
                return class_29602;
            }

            private static final boolean reload$lambda$0(class_2960 it) {
                return true;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean updateState$lambda$9(HudState this$0, ResourceEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.getMatchTeamColor() == null) return true;
        class_124 class_1242 = this$0.scoreboardAccessor.getTeamColor();
        Object object = class_1242;
        if (class_1242 == null) return false;
        String string = object.name();
        object = string;
        if (string == null) return false;
        if (!StringsKt.equals((String)object, (String)it.getMatchTeamColor(), (boolean)true)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean updateState$lambda$10(HudState this$0, ResourceEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.getMatchTeamName() == null) return true;
        String string = this$0.scoreboardAccessor.getTeamName();
        if (string == null) return false;
        if (!StringsKt.equals((String)string, (String)it.getMatchTeamName(), (boolean)true)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean updateState$lambda$11(ObjectiveInfo $objectiveInfo, ResourceEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.getMatchTitleRegex() == null) return true;
        ObjectiveInfo objectiveInfo = $objectiveInfo;
        Object object = objectiveInfo;
        if (objectiveInfo == null) return false;
        class_2561 class_25612 = ((ObjectiveInfo)object).getDisplayName();
        object = class_25612;
        if (class_25612 == null) return false;
        String string = object.getString();
        object = string;
        if (string == null) return false;
        CharSequence charSequence = (CharSequence)object;
        if (!it.getMatchTitleRegex().matches(charSequence)) return false;
        return true;
    }

    private static final void init$lambda$20(HudState this$0, class_310 it) {
        if (!this$0.config.isEnabled() || it.method_1493()) {
            return;
        }
        this$0.updateState();
        this$0.updateVisibility();
    }

    public static final /* synthetic */ Logger access$getLog$p(HudState $this) {
        return $this.log;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ScoreboardConfig.FrameColorBehavior.values().length];
            try {
                nArray[ScoreboardConfig.FrameColorBehavior.Auto.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScoreboardConfig.FrameColorBehavior.Manual.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

