/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.rendering.fluid;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRendering;
import net.fabricmc.fabric.impl.client.rendering.fluid.FluidRenderHandlerInfo;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3610;
import net.minecraft.class_4588;
import net.minecraft.class_775;

@Environment(value=EnvType.CLIENT)
public class FluidRenderingImpl {
    private static final ThreadLocal<FluidRendering.DefaultRenderer> CURRENT_DEFAULT_RENDERER = new ThreadLocal();
    private static final ThreadLocal<FluidRenderHandlerInfo> CURRENT_INFO = ThreadLocal.withInitial(FluidRenderHandlerInfo::new);
    private static class_775 vanillaRenderer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void render(FluidRenderHandler handler, class_1920 world, class_2338 pos, class_4588 vertexConsumer, class_2680 blockState, class_3610 fluidState, FluidRendering.DefaultRenderer defaultRenderer) {
        CURRENT_DEFAULT_RENDERER.set(defaultRenderer);
        try {
            handler.renderFluid(pos, world, vertexConsumer, blockState, fluidState);
        }
        finally {
            CURRENT_DEFAULT_RENDERER.remove();
        }
    }

    public static void renderDefault(FluidRenderHandler handler, class_1920 world, class_2338 pos, class_4588 vertexConsumer, class_2680 blockState, class_3610 fluidState) {
        FluidRendering.DefaultRenderer renderer = CURRENT_DEFAULT_RENDERER.get();
        if (renderer != null) {
            renderer.render(handler, world, pos, vertexConsumer, blockState, fluidState);
        } else {
            FluidRenderingImpl.renderVanillaDefault(handler, world, pos, vertexConsumer, blockState, fluidState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderVanillaDefault(FluidRenderHandler handler, class_1920 world, class_2338 pos, class_4588 vertexConsumer, class_2680 blockState, class_3610 fluidState) {
        FluidRenderHandlerInfo info = CURRENT_INFO.get();
        info.setup(handler, world, pos, fluidState);
        try {
            vanillaRenderer.method_3347(world, pos, vertexConsumer, blockState, fluidState);
        }
        finally {
            info.clear();
        }
    }

    public static void setVanillaRenderer(class_775 vanillaRenderer) {
        FluidRenderingImpl.vanillaRenderer = vanillaRenderer;
    }

    public static FluidRenderHandlerInfo getCurrentInfo() {
        return CURRENT_INFO.get();
    }
}

