/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.notickvd.common;

import com.ishland.c2me.base.common.GlobalExecutors;
import com.ishland.c2me.notickvd.common.PlayerNoTickLoader;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1923;
import net.minecraft.class_3898;

public class NoTickSystem {
    private final PlayerNoTickLoader playerNoTickLoader;
    private final ConcurrentLinkedQueue<Runnable> pendingActionsOnScheduler = new ConcurrentLinkedQueue();
    final ConcurrentLinkedQueue<Runnable> mainBeforeTicketTicks = new ConcurrentLinkedQueue();
    final ConcurrentLinkedQueue<Runnable> mainAfterTicketTicks = new ConcurrentLinkedQueue();
    private final AtomicBoolean isTicking = new AtomicBoolean();
    final Executor executor = GlobalExecutors.asyncScheduler;

    public NoTickSystem(class_3898 tacs) {
        this.playerNoTickLoader = new PlayerNoTickLoader(tacs, this);
    }

    public void addPlayerSource(class_1923 chunkPos) {
        this.pendingActionsOnScheduler.add(() -> this.playerNoTickLoader.addSource(chunkPos));
    }

    public void removePlayerSource(class_1923 chunkPos) {
        this.pendingActionsOnScheduler.add(() -> this.playerNoTickLoader.removeSource(chunkPos));
    }

    public void setNoTickViewDistance(int viewDistance) {
        this.pendingActionsOnScheduler.add(() -> this.playerNoTickLoader.setViewDistance(viewDistance));
    }

    public void beforeTicketTicks() {
        this.drainQueue(this.mainBeforeTicketTicks);
    }

    public void afterTicketTicks() {
        this.drainQueue(this.mainAfterTicketTicks);
    }

    public void tick() {
        this.scheduleTick();
    }

    private void scheduleTick() {
        if (!this.pendingActionsOnScheduler.isEmpty() && this.isTicking.compareAndSet(false, true)) {
            Runnable r;
            ArrayList<Runnable> tasks = new ArrayList<Runnable>(this.pendingActionsOnScheduler.size() + 3);
            while ((r = this.pendingActionsOnScheduler.poll()) != null) {
                tasks.add(r);
            }
            this.executor.execute(() -> {
                try {
                    for (Runnable task : tasks) {
                        try {
                            task.run();
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                    this.playerNoTickLoader.tick();
                    if (!this.pendingActionsOnScheduler.isEmpty() || !tasks.isEmpty()) {
                        this.scheduleTick();
                    }
                }
                finally {
                    this.isTicking.set(false);
                }
            });
        }
    }

    private void drainQueue(ConcurrentLinkedQueue<Runnable> queue) {
        Runnable runnable;
        while ((runnable = queue.poll()) != null) {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public long getPendingLoadsCount() {
        return this.playerNoTickLoader.getPendingLoadsCount();
    }

    public void close() {
        this.playerNoTickLoader.close();
        this.executor.execute(() -> {
            try {
                this.playerNoTickLoader.tick();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        });
    }
}

