/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.phys.Vec3;

public class GuardianModel
extends HierarchicalModel<Guardian> {
    private static final float[] SPIKE_X_ROT = new float[]{1.75f, 0.25f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f, 0.5f, 1.25f, 0.75f, 0.0f, 0.0f};
    private static final float[] SPIKE_Y_ROT = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.25f, 1.75f, 1.25f, 0.75f, 0.0f, 0.0f, 0.0f, 0.0f};
    private static final float[] SPIKE_Z_ROT = new float[]{0.0f, 0.0f, 0.25f, 1.75f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.75f, 1.25f};
    private static final float[] SPIKE_X = new float[]{0.0f, 0.0f, 8.0f, -8.0f, -8.0f, 8.0f, 8.0f, -8.0f, 0.0f, 0.0f, 8.0f, -8.0f};
    private static final float[] SPIKE_Y = new float[]{-8.0f, -8.0f, -8.0f, -8.0f, 0.0f, 0.0f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f};
    private static final float[] SPIKE_Z = new float[]{8.0f, -8.0f, 0.0f, 0.0f, -8.0f, -8.0f, 8.0f, 8.0f, 8.0f, -8.0f, 0.0f, 0.0f};
    private static final String EYE = "eye";
    private static final String TAIL_0 = "tail0";
    private static final String TAIL_1 = "tail1";
    private static final String TAIL_2 = "tail2";
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart eye;
    private final ModelPart[] spikeParts;
    private final ModelPart[] tailParts;

    public GuardianModel(ModelPart p_170600_) {
        this.root = p_170600_;
        this.spikeParts = new ModelPart[12];
        this.head = p_170600_.getChild("head");
        for (int $$1 = 0; $$1 < this.spikeParts.length; ++$$1) {
            this.spikeParts[$$1] = this.head.getChild(GuardianModel.createSpikeName($$1));
        }
        this.eye = this.head.getChild(EYE);
        this.tailParts = new ModelPart[3];
        this.tailParts[0] = this.head.getChild(TAIL_0);
        this.tailParts[1] = this.tailParts[0].getChild(TAIL_1);
        this.tailParts[2] = this.tailParts[1].getChild(TAIL_2);
    }

    private static String createSpikeName(int p_170603_) {
        return "spike" + p_170603_;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition $$0 = new MeshDefinition();
        PartDefinition $$1 = $$0.getRoot();
        PartDefinition $$2 = $$1.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, 10.0f, -8.0f, 12.0f, 12.0f, 16.0f).texOffs(0, 28).addBox(-8.0f, 10.0f, -6.0f, 2.0f, 12.0f, 12.0f).texOffs(0, 28).addBox(6.0f, 10.0f, -6.0f, 2.0f, 12.0f, 12.0f, true).texOffs(16, 40).addBox(-6.0f, 8.0f, -6.0f, 12.0f, 2.0f, 12.0f).texOffs(16, 40).addBox(-6.0f, 22.0f, -6.0f, 12.0f, 2.0f, 12.0f), PartPose.ZERO);
        CubeListBuilder $$3 = CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -4.5f, -1.0f, 2.0f, 9.0f, 2.0f);
        for (int $$4 = 0; $$4 < 12; ++$$4) {
            float $$5 = GuardianModel.getSpikeX($$4, 0.0f, 0.0f);
            float $$6 = GuardianModel.getSpikeY($$4, 0.0f, 0.0f);
            float $$7 = GuardianModel.getSpikeZ($$4, 0.0f, 0.0f);
            float $$8 = (float)Math.PI * SPIKE_X_ROT[$$4];
            float $$9 = (float)Math.PI * SPIKE_Y_ROT[$$4];
            float $$10 = (float)Math.PI * SPIKE_Z_ROT[$$4];
            $$2.addOrReplaceChild(GuardianModel.createSpikeName($$4), $$3, PartPose.offsetAndRotation($$5, $$6, $$7, $$8, $$9, $$10));
        }
        $$2.addOrReplaceChild(EYE, CubeListBuilder.create().texOffs(8, 0).addBox(-1.0f, 15.0f, 0.0f, 2.0f, 2.0f, 1.0f), PartPose.offset(0.0f, 0.0f, -8.25f));
        PartDefinition $$11 = $$2.addOrReplaceChild(TAIL_0, CubeListBuilder.create().texOffs(40, 0).addBox(-2.0f, 14.0f, 7.0f, 4.0f, 4.0f, 8.0f), PartPose.ZERO);
        PartDefinition $$12 = $$11.addOrReplaceChild(TAIL_1, CubeListBuilder.create().texOffs(0, 54).addBox(0.0f, 14.0f, 0.0f, 3.0f, 3.0f, 7.0f), PartPose.offset(-1.5f, 0.5f, 14.0f));
        $$12.addOrReplaceChild(TAIL_2, CubeListBuilder.create().texOffs(41, 32).addBox(0.0f, 14.0f, 0.0f, 2.0f, 2.0f, 6.0f).texOffs(25, 19).addBox(1.0f, 10.5f, 3.0f, 1.0f, 9.0f, 9.0f), PartPose.offset(0.5f, 0.5f, 6.0f));
        return LayerDefinition.create($$0, 64, 64);
    }

    @Override
    public ModelPart root() {
        return this.root;
    }

    @Override
    public void setupAnim(Guardian p_102719_, float p_102720_, float p_102721_, float p_102722_, float p_102723_, float p_102724_) {
        float $$6 = p_102722_ - (float)p_102719_.tickCount;
        this.head.yRot = p_102723_ * ((float)Math.PI / 180);
        this.head.xRot = p_102724_ * ((float)Math.PI / 180);
        float $$7 = (1.0f - p_102719_.getSpikesAnimation($$6)) * 0.55f;
        this.setupSpikes(p_102722_, $$7);
        Entity $$8 = Minecraft.getInstance().getCameraEntity();
        if (p_102719_.hasActiveAttackTarget()) {
            $$8 = p_102719_.getActiveAttackTarget();
        }
        if ($$8 != null) {
            Vec3 $$9 = $$8.getEyePosition(0.0f);
            Vec3 $$10 = p_102719_.getEyePosition(0.0f);
            double $$11 = $$9.y - $$10.y;
            this.eye.y = $$11 > 0.0 ? 0.0f : 1.0f;
            Vec3 $$12 = p_102719_.getViewVector(0.0f);
            $$12 = new Vec3($$12.x, 0.0, $$12.z);
            Vec3 $$13 = new Vec3($$10.x - $$9.x, 0.0, $$10.z - $$9.z).normalize().yRot(1.5707964f);
            double $$14 = $$12.dot($$13);
            this.eye.x = Mth.sqrt((float)Math.abs($$14)) * 2.0f * (float)Math.signum($$14);
        }
        this.eye.visible = true;
        float $$15 = p_102719_.getTailAnimation($$6);
        this.tailParts[0].yRot = Mth.sin($$15) * (float)Math.PI * 0.05f;
        this.tailParts[1].yRot = Mth.sin($$15) * (float)Math.PI * 0.1f;
        this.tailParts[2].yRot = Mth.sin($$15) * (float)Math.PI * 0.15f;
    }

    private void setupSpikes(float p_102709_, float p_102710_) {
        for (int $$2 = 0; $$2 < 12; ++$$2) {
            this.spikeParts[$$2].x = GuardianModel.getSpikeX($$2, p_102709_, p_102710_);
            this.spikeParts[$$2].y = GuardianModel.getSpikeY($$2, p_102709_, p_102710_);
            this.spikeParts[$$2].z = GuardianModel.getSpikeZ($$2, p_102709_, p_102710_);
        }
    }

    private static float getSpikeOffset(int p_170605_, float p_170606_, float p_170607_) {
        return 1.0f + Mth.cos(p_170606_ * 1.5f + (float)p_170605_) * 0.01f - p_170607_;
    }

    private static float getSpikeX(int p_170610_, float p_170611_, float p_170612_) {
        return SPIKE_X[p_170610_] * GuardianModel.getSpikeOffset(p_170610_, p_170611_, p_170612_);
    }

    private static float getSpikeY(int p_170614_, float p_170615_, float p_170616_) {
        return 16.0f + SPIKE_Y[p_170614_] * GuardianModel.getSpikeOffset(p_170614_, p_170615_, p_170616_);
    }

    private static float getSpikeZ(int p_170618_, float p_170619_, float p_170620_) {
        return SPIKE_Z[p_170618_] * GuardianModel.getSpikeOffset(p_170618_, p_170619_, p_170620_);
    }
}

