/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.Boat;

public class RaftModel
extends ListModel<Boat> {
    private static final String LEFT_PADDLE = "left_paddle";
    private static final String RIGHT_PADDLE = "right_paddle";
    private static final String BOTTOM = "bottom";
    private final ModelPart leftPaddle;
    private final ModelPart rightPaddle;
    private final ImmutableList<ModelPart> parts;

    public RaftModel(ModelPart p_251383_) {
        this.leftPaddle = p_251383_.getChild(LEFT_PADDLE);
        this.rightPaddle = p_251383_.getChild(RIGHT_PADDLE);
        this.parts = this.createPartsBuilder(p_251383_).build();
    }

    protected ImmutableList.Builder<ModelPart> createPartsBuilder(ModelPart p_250773_) {
        ImmutableList.Builder $$1 = new ImmutableList.Builder();
        $$1.add((Object[])new ModelPart[]{p_250773_.getChild(BOTTOM), this.leftPaddle, this.rightPaddle});
        return $$1;
    }

    public static void createChildren(PartDefinition p_250262_) {
        p_250262_.addOrReplaceChild(BOTTOM, CubeListBuilder.create().texOffs(0, 0).addBox(-14.0f, -11.0f, -4.0f, 28.0f, 20.0f, 4.0f).texOffs(0, 0).addBox(-14.0f, -9.0f, -8.0f, 28.0f, 16.0f, 4.0f), PartPose.offsetAndRotation(0.0f, -2.1f, 1.0f, 1.5708f, 0.0f, 0.0f));
        int $$1 = 20;
        int $$2 = 7;
        int $$3 = 6;
        float $$4 = -5.0f;
        p_250262_.addOrReplaceChild(LEFT_PADDLE, CubeListBuilder.create().texOffs(0, 24).addBox(-1.0f, 0.0f, -5.0f, 2.0f, 2.0f, 18.0f).addBox(-1.001f, -3.0f, 8.0f, 1.0f, 6.0f, 7.0f), PartPose.offsetAndRotation(3.0f, -4.0f, 9.0f, 0.0f, 0.0f, 0.19634955f));
        p_250262_.addOrReplaceChild(RIGHT_PADDLE, CubeListBuilder.create().texOffs(40, 24).addBox(-1.0f, 0.0f, -5.0f, 2.0f, 2.0f, 18.0f).addBox(0.001f, -3.0f, 8.0f, 1.0f, 6.0f, 7.0f), PartPose.offsetAndRotation(3.0f, -4.0f, -9.0f, 0.0f, (float)Math.PI, 0.19634955f));
    }

    public static LayerDefinition createBodyModel() {
        MeshDefinition $$0 = new MeshDefinition();
        PartDefinition $$1 = $$0.getRoot();
        RaftModel.createChildren($$1);
        return LayerDefinition.create($$0, 128, 64);
    }

    @Override
    public void setupAnim(Boat p_249733_, float p_249202_, float p_252219_, float p_249366_, float p_249759_, float p_250286_) {
        RaftModel.animatePaddle(p_249733_, 0, this.leftPaddle, p_249202_);
        RaftModel.animatePaddle(p_249733_, 1, this.rightPaddle, p_249202_);
    }

    public ImmutableList<ModelPart> parts() {
        return this.parts;
    }

    private static void animatePaddle(Boat p_250792_, int p_249947_, ModelPart p_248943_, float p_251990_) {
        float $$4 = p_250792_.getRowingTime(p_249947_, p_251990_);
        p_248943_.xRot = Mth.clampedLerp(-1.0471976f, -0.2617994f, (Mth.sin(-$$4) + 1.0f) / 2.0f);
        p_248943_.yRot = Mth.clampedLerp(-0.7853982f, 0.7853982f, (Mth.sin(-$$4 + 1.0f) + 1.0f) / 2.0f);
        if (p_249947_ == 1) {
            p_248943_.yRot = (float)Math.PI - p_248943_.yRot;
        }
    }

    @Override
    public /* synthetic */ Iterable parts() {
        return this.parts();
    }
}

