/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.logging.LogUtils;
import com.mojang.math.Transformation;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.BlockStateModelLoader;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;

public class ModelBakery {
    public static final Material FIRE_0 = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace("block/fire_0"));
    public static final Material FIRE_1 = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace("block/fire_1"));
    public static final Material LAVA_FLOW = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace("block/lava_flow"));
    public static final Material WATER_FLOW = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace("block/water_flow"));
    public static final Material WATER_OVERLAY = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace("block/water_overlay"));
    public static final Material BANNER_BASE = new Material(Sheets.BANNER_SHEET, ResourceLocation.withDefaultNamespace("entity/banner_base"));
    public static final Material SHIELD_BASE = new Material(Sheets.SHIELD_SHEET, ResourceLocation.withDefaultNamespace("entity/shield_base"));
    public static final Material NO_PATTERN_SHIELD = new Material(Sheets.SHIELD_SHEET, ResourceLocation.withDefaultNamespace("entity/shield_base_nopattern"));
    public static final int DESTROY_STAGE_COUNT = 10;
    public static final List<ResourceLocation> DESTROY_STAGES = IntStream.range(0, 10).mapToObj(p_349912_ -> ResourceLocation.withDefaultNamespace("block/destroy_stage_" + p_349912_)).collect(Collectors.toList());
    public static final List<ResourceLocation> BREAKING_LOCATIONS = DESTROY_STAGES.stream().map(p_349910_ -> p_349910_.withPath(p_349911_ -> "textures/" + p_349911_ + ".png")).collect(Collectors.toList());
    public static final List<RenderType> DESTROY_TYPES = BREAKING_LOCATIONS.stream().map(RenderType::crumbling).collect(Collectors.toList());
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String BUILTIN_SLASH = "builtin/";
    private static final String BUILTIN_SLASH_GENERATED = "builtin/generated";
    private static final String BUILTIN_BLOCK_ENTITY = "builtin/entity";
    private static final String MISSING_MODEL_NAME = "missing";
    public static final ResourceLocation MISSING_MODEL_LOCATION = ResourceLocation.withDefaultNamespace("builtin/missing");
    public static final ModelResourceLocation MISSING_MODEL_VARIANT = new ModelResourceLocation(MISSING_MODEL_LOCATION, "missing");
    public static final FileToIdConverter MODEL_LISTER = FileToIdConverter.json("models");
    @VisibleForTesting
    public static final String MISSING_MODEL_MESH = ("{    'textures': {       'particle': '" + MissingTextureAtlasSprite.getLocation().getPath() + "',       'missingno': '" + MissingTextureAtlasSprite.getLocation().getPath() + "'    },    'elements': [         {  'from': [ 0, 0, 0 ],            'to': [ 16, 16, 16 ],            'faces': {                'down':  { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'down',  'texture': '#missingno' },                'up':    { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'up',    'texture': '#missingno' },                'north': { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'north', 'texture': '#missingno' },                'south': { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'south', 'texture': '#missingno' },                'west':  { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'west',  'texture': '#missingno' },                'east':  { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'east',  'texture': '#missingno' }            }        }    ]}").replace('\'', '\"');
    private static final Map<String, String> BUILTIN_MODELS = Map.of("missing", MISSING_MODEL_MESH);
    public static final BlockModel GENERATION_MARKER = Util.make(BlockModel.fromString("{\"gui_light\": \"front\"}"), p_119359_ -> {
        p_119359_.name = "generation marker";
    });
    public static final BlockModel BLOCK_ENTITY_MARKER = Util.make(BlockModel.fromString("{\"gui_light\": \"side\"}"), p_119297_ -> {
        p_119297_.name = "block entity marker";
    });
    static final ItemModelGenerator ITEM_MODEL_GENERATOR = new ItemModelGenerator();
    private final Map<ResourceLocation, BlockModel> modelResources;
    private final Set<ResourceLocation> loadingStack = new HashSet<ResourceLocation>();
    private final Map<ResourceLocation, UnbakedModel> unbakedCache = new HashMap<ResourceLocation, UnbakedModel>();
    final Map<BakedCacheKey, BakedModel> bakedCache = new HashMap<BakedCacheKey, BakedModel>();
    private final Map<ModelResourceLocation, UnbakedModel> topLevelModels = new HashMap<ModelResourceLocation, UnbakedModel>();
    private final Map<ModelResourceLocation, BakedModel> bakedTopLevelModels = new HashMap<ModelResourceLocation, BakedModel>();
    private final UnbakedModel missingModel;
    private final Object2IntMap<BlockState> modelGroups;

    public ModelBakery(BlockColors p_249183_, ProfilerFiller p_252014_, Map<ResourceLocation, BlockModel> p_251087_, Map<ResourceLocation, List<BlockStateModelLoader.LoadedJson>> p_250416_) {
        this.modelResources = p_251087_;
        p_252014_.push("missing_model");
        try {
            this.missingModel = this.loadBlockModel(MISSING_MODEL_LOCATION);
            this.registerModel(MISSING_MODEL_VARIANT, this.missingModel);
        }
        catch (IOException $$4) {
            LOGGER.error("Error loading missing model, should never happen :(", (Throwable)$$4);
            throw new RuntimeException($$4);
        }
        BlockStateModelLoader $$5 = new BlockStateModelLoader(p_250416_, p_252014_, this.missingModel, p_249183_, this::registerModelAndLoadDependencies);
        $$5.loadAllBlockStates();
        this.modelGroups = $$5.getModelGroups();
        p_252014_.popPush("items");
        for (ResourceLocation $$6 : BuiltInRegistries.ITEM.keySet()) {
            this.loadItemModelAndDependencies($$6);
        }
        p_252014_.popPush("special");
        this.loadSpecialItemModelAndDependencies(ItemRenderer.TRIDENT_IN_HAND_MODEL);
        this.loadSpecialItemModelAndDependencies(ItemRenderer.SPYGLASS_IN_HAND_MODEL);
        this.topLevelModels.values().forEach(p_247954_ -> p_247954_.resolveParents(this::getModel));
        p_252014_.pop();
    }

    public void bakeModels(TextureGetter p_352431_) {
        this.topLevelModels.forEach((p_351687_, p_351688_) -> {
            BakedModel $$3 = null;
            try {
                $$3 = new ModelBakerImpl(p_352431_, (ModelResourceLocation)p_351687_).bakeUncached((UnbakedModel)p_351688_, BlockModelRotation.X0_Y0);
            }
            catch (Exception $$4) {
                LOGGER.warn("Unable to bake model: '{}': {}", p_351687_, (Object)$$4);
            }
            if ($$3 != null) {
                this.bakedTopLevelModels.put((ModelResourceLocation)p_351687_, $$3);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UnbakedModel getModel(ResourceLocation p_119342_) {
        if (this.unbakedCache.containsKey(p_119342_)) {
            return this.unbakedCache.get(p_119342_);
        }
        if (this.loadingStack.contains(p_119342_)) {
            throw new IllegalStateException("Circular reference while loading " + String.valueOf(p_119342_));
        }
        this.loadingStack.add(p_119342_);
        while (!this.loadingStack.isEmpty()) {
            ResourceLocation $$1 = this.loadingStack.iterator().next();
            try {
                if (this.unbakedCache.containsKey($$1)) continue;
                BlockModel $$2 = this.loadBlockModel($$1);
                this.unbakedCache.put($$1, $$2);
                this.loadingStack.addAll($$2.getDependencies());
            }
            catch (Exception $$3) {
                LOGGER.warn("Unable to load model: '{}' referenced from: {}: {}", new Object[]{$$1, p_119342_, $$3});
                this.unbakedCache.put($$1, this.missingModel);
            }
            finally {
                this.loadingStack.remove($$1);
            }
        }
        return this.unbakedCache.getOrDefault(p_119342_, this.missingModel);
    }

    private void loadItemModelAndDependencies(ResourceLocation p_352200_) {
        ModelResourceLocation $$1 = ModelResourceLocation.inventory(p_352200_);
        ResourceLocation $$2 = p_352200_.withPrefix("item/");
        UnbakedModel $$3 = this.getModel($$2);
        this.registerModelAndLoadDependencies($$1, $$3);
    }

    private void loadSpecialItemModelAndDependencies(ModelResourceLocation p_352247_) {
        ResourceLocation $$1 = p_352247_.id().withPrefix("item/");
        UnbakedModel $$2 = this.getModel($$1);
        this.registerModelAndLoadDependencies(p_352247_, $$2);
    }

    private void registerModelAndLoadDependencies(ModelResourceLocation p_352435_, UnbakedModel p_352250_) {
        for (ResourceLocation $$2 : p_352250_.getDependencies()) {
            this.getModel($$2);
        }
        this.registerModel(p_352435_, p_352250_);
    }

    private void registerModel(ModelResourceLocation p_352067_, UnbakedModel p_352146_) {
        this.topLevelModels.put(p_352067_, p_352146_);
    }

    private BlockModel loadBlockModel(ResourceLocation p_119365_) throws IOException {
        String $$1 = p_119365_.getPath();
        if (BUILTIN_SLASH_GENERATED.equals($$1)) {
            return GENERATION_MARKER;
        }
        if (BUILTIN_BLOCK_ENTITY.equals($$1)) {
            return BLOCK_ENTITY_MARKER;
        }
        if ($$1.startsWith(BUILTIN_SLASH)) {
            String $$2 = $$1.substring(BUILTIN_SLASH.length());
            String $$3 = BUILTIN_MODELS.get($$2);
            if ($$3 == null) {
                throw new FileNotFoundException(p_119365_.toString());
            }
            StringReader $$4 = new StringReader($$3);
            BlockModel $$5 = BlockModel.fromStream($$4);
            $$5.name = p_119365_.toString();
            return $$5;
        }
        ResourceLocation $$6 = MODEL_LISTER.idToFile(p_119365_);
        BlockModel $$7 = this.modelResources.get($$6);
        if ($$7 == null) {
            throw new FileNotFoundException($$6.toString());
        }
        $$7.name = p_119365_.toString();
        return $$7;
    }

    public Map<ModelResourceLocation, BakedModel> getBakedTopLevelModels() {
        return this.bakedTopLevelModels;
    }

    public Object2IntMap<BlockState> getModelGroups() {
        return this.modelGroups;
    }

    @FunctionalInterface
    public static interface TextureGetter {
        public TextureAtlasSprite get(ModelResourceLocation var1, Material var2);
    }

    class ModelBakerImpl
    implements ModelBaker {
        private final Function<Material, TextureAtlasSprite> modelTextureGetter = p_351691_ -> p_352124_.get(p_352126_, (Material)p_351691_);

        ModelBakerImpl(TextureGetter p_352124_, ModelResourceLocation p_352126_) {
        }

        @Override
        public UnbakedModel getModel(ResourceLocation p_248568_) {
            return ModelBakery.this.getModel(p_248568_);
        }

        @Override
        public BakedModel bake(ResourceLocation p_252176_, ModelState p_249765_) {
            BakedCacheKey $$2 = new BakedCacheKey(p_252176_, p_249765_.getRotation(), p_249765_.isUvLocked());
            BakedModel $$3 = ModelBakery.this.bakedCache.get($$2);
            if ($$3 != null) {
                return $$3;
            }
            UnbakedModel $$4 = this.getModel(p_252176_);
            BakedModel $$5 = this.bakeUncached($$4, p_249765_);
            ModelBakery.this.bakedCache.put($$2, $$5);
            return $$5;
        }

        @Nullable
        BakedModel bakeUncached(UnbakedModel p_352386_, ModelState p_352194_) {
            BlockModel $$2;
            if (p_352386_ instanceof BlockModel && ($$2 = (BlockModel)p_352386_).getRootModel() == GENERATION_MARKER) {
                return ITEM_MODEL_GENERATOR.generateBlockModel(this.modelTextureGetter, $$2).bake(this, $$2, this.modelTextureGetter, p_352194_, false);
            }
            return p_352386_.bake(this, this.modelTextureGetter, p_352194_);
        }
    }

    record BakedCacheKey(ResourceLocation id, Transformation transformation, boolean isUvLocked) {
    }
}

