/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockState;

public interface SignalGetter
extends BlockGetter {
    public static final Direction[] DIRECTIONS = Direction.values();

    default public int getDirectSignal(BlockPos p_277954_, Direction p_277342_) {
        return this.getBlockState(p_277954_).getDirectSignal(this, p_277954_, p_277342_);
    }

    default public int getDirectSignalTo(BlockPos p_277959_) {
        int $$1 = 0;
        if (($$1 = Math.max($$1, this.getDirectSignal(p_277959_.below(), Direction.DOWN))) >= 15) {
            return $$1;
        }
        if (($$1 = Math.max($$1, this.getDirectSignal(p_277959_.above(), Direction.UP))) >= 15) {
            return $$1;
        }
        if (($$1 = Math.max($$1, this.getDirectSignal(p_277959_.north(), Direction.NORTH))) >= 15) {
            return $$1;
        }
        if (($$1 = Math.max($$1, this.getDirectSignal(p_277959_.south(), Direction.SOUTH))) >= 15) {
            return $$1;
        }
        if (($$1 = Math.max($$1, this.getDirectSignal(p_277959_.west(), Direction.WEST))) >= 15) {
            return $$1;
        }
        if (($$1 = Math.max($$1, this.getDirectSignal(p_277959_.east(), Direction.EAST))) >= 15) {
            return $$1;
        }
        return $$1;
    }

    default public int getControlInputSignal(BlockPos p_277757_, Direction p_278104_, boolean p_277707_) {
        BlockState $$3 = this.getBlockState(p_277757_);
        if (p_277707_) {
            return DiodeBlock.isDiode($$3) ? this.getDirectSignal(p_277757_, p_278104_) : 0;
        }
        if ($$3.is(Blocks.REDSTONE_BLOCK)) {
            return 15;
        }
        if ($$3.is(Blocks.REDSTONE_WIRE)) {
            return $$3.getValue(RedStoneWireBlock.POWER);
        }
        if ($$3.isSignalSource()) {
            return this.getDirectSignal(p_277757_, p_278104_);
        }
        return 0;
    }

    default public boolean hasSignal(BlockPos p_277371_, Direction p_277391_) {
        return this.getSignal(p_277371_, p_277391_) > 0;
    }

    default public int getSignal(BlockPos p_277961_, Direction p_277351_) {
        BlockState $$2 = this.getBlockState(p_277961_);
        int $$3 = $$2.getSignal(this, p_277961_, p_277351_);
        if ($$2.isRedstoneConductor(this, p_277961_)) {
            return Math.max($$3, this.getDirectSignalTo(p_277961_));
        }
        return $$3;
    }

    default public boolean hasNeighborSignal(BlockPos p_277626_) {
        if (this.getSignal(p_277626_.below(), Direction.DOWN) > 0) {
            return true;
        }
        if (this.getSignal(p_277626_.above(), Direction.UP) > 0) {
            return true;
        }
        if (this.getSignal(p_277626_.north(), Direction.NORTH) > 0) {
            return true;
        }
        if (this.getSignal(p_277626_.south(), Direction.SOUTH) > 0) {
            return true;
        }
        if (this.getSignal(p_277626_.west(), Direction.WEST) > 0) {
            return true;
        }
        return this.getSignal(p_277626_.east(), Direction.EAST) > 0;
    }

    default public int getBestNeighborSignal(BlockPos p_277977_) {
        int $$1 = 0;
        for (Direction $$2 : DIRECTIONS) {
            int $$3 = this.getSignal(p_277977_.relative($$2), $$2);
            if ($$3 >= 15) {
                return 15;
            }
            if ($$3 <= $$1) continue;
            $$1 = $$3;
        }
        return $$1;
    }
}

