/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;

public class ChorusPlantBlock
extends PipeBlock {
    public static final MapCodec<ChorusPlantBlock> CODEC = ChorusPlantBlock.simpleCodec(ChorusPlantBlock::new);

    public MapCodec<ChorusPlantBlock> codec() {
        return CODEC;
    }

    protected ChorusPlantBlock(BlockBehaviour.Properties p_51707_) {
        super(0.3125f, p_51707_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(NORTH, false)).setValue(EAST, false)).setValue(SOUTH, false)).setValue(WEST, false)).setValue(UP, false)).setValue(DOWN, false));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext p_51709_) {
        return ChorusPlantBlock.getStateWithConnections(p_51709_.getLevel(), p_51709_.getClickedPos(), this.defaultBlockState());
    }

    public static BlockState getStateWithConnections(BlockGetter p_51711_, BlockPos p_51712_, BlockState p_304771_) {
        BlockState $$3 = p_51711_.getBlockState(p_51712_.below());
        BlockState $$4 = p_51711_.getBlockState(p_51712_.above());
        BlockState $$5 = p_51711_.getBlockState(p_51712_.north());
        BlockState $$6 = p_51711_.getBlockState(p_51712_.east());
        BlockState $$7 = p_51711_.getBlockState(p_51712_.south());
        BlockState $$8 = p_51711_.getBlockState(p_51712_.west());
        Block $$9 = p_304771_.getBlock();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)p_304771_.trySetValue(DOWN, $$3.is($$9) || $$3.is(Blocks.CHORUS_FLOWER) || $$3.is(Blocks.END_STONE))).trySetValue(UP, $$4.is($$9) || $$4.is(Blocks.CHORUS_FLOWER))).trySetValue(NORTH, $$5.is($$9) || $$5.is(Blocks.CHORUS_FLOWER))).trySetValue(EAST, $$6.is($$9) || $$6.is(Blocks.CHORUS_FLOWER))).trySetValue(SOUTH, $$7.is($$9) || $$7.is(Blocks.CHORUS_FLOWER))).trySetValue(WEST, $$8.is($$9) || $$8.is(Blocks.CHORUS_FLOWER));
    }

    @Override
    protected BlockState updateShape(BlockState p_51728_, Direction p_51729_, BlockState p_51730_, LevelAccessor p_51731_, BlockPos p_51732_, BlockPos p_51733_) {
        if (!p_51728_.canSurvive(p_51731_, p_51732_)) {
            p_51731_.scheduleTick(p_51732_, this, 1);
            return super.updateShape(p_51728_, p_51729_, p_51730_, p_51731_, p_51732_, p_51733_);
        }
        boolean $$6 = p_51730_.is(this) || p_51730_.is(Blocks.CHORUS_FLOWER) || p_51729_ == Direction.DOWN && p_51730_.is(Blocks.END_STONE);
        return (BlockState)p_51728_.setValue((Property)PROPERTY_BY_DIRECTION.get(p_51729_), $$6);
    }

    @Override
    protected void tick(BlockState p_220985_, ServerLevel p_220986_, BlockPos p_220987_, RandomSource p_220988_) {
        if (!p_220985_.canSurvive(p_220986_, p_220987_)) {
            p_220986_.destroyBlock(p_220987_, true);
        }
    }

    @Override
    protected boolean canSurvive(BlockState p_51724_, LevelReader p_51725_, BlockPos p_51726_) {
        BlockState $$3 = p_51725_.getBlockState(p_51726_.below());
        boolean $$4 = !p_51725_.getBlockState(p_51726_.above()).isAir() && !$$3.isAir();
        for (Direction $$5 : Direction.Plane.HORIZONTAL) {
            BlockPos $$6 = p_51726_.relative($$5);
            BlockState $$7 = p_51725_.getBlockState($$6);
            if (!$$7.is(this)) continue;
            if ($$4) {
                return false;
            }
            BlockState $$8 = p_51725_.getBlockState($$6.below());
            if (!$$8.is(this) && !$$8.is(Blocks.END_STONE)) continue;
            return true;
        }
        return $$3.is(this) || $$3.is(Blocks.END_STONE);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_51735_) {
        p_51735_.add(NORTH, EAST, SOUTH, WEST, UP, DOWN);
    }

    @Override
    protected boolean isPathfindable(BlockState p_51719_, PathComputationType p_51722_) {
        return false;
    }
}

