/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntries;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntry;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import org.apache.commons.lang3.mutable.MutableInt;

public class LootPool {
    public static final Codec<LootPool> CODEC = RecordCodecBuilder.create(p_344669_ -> p_344669_.group((App)LootPoolEntries.CODEC.listOf().fieldOf("entries").forGetter(p_297995_ -> p_297995_.entries), (App)LootItemCondition.DIRECT_CODEC.listOf().optionalFieldOf("conditions", List.of()).forGetter(p_297992_ -> p_297992_.conditions), (App)LootItemFunctions.ROOT_CODEC.listOf().optionalFieldOf("functions", List.of()).forGetter(p_297994_ -> p_297994_.functions), (App)NumberProviders.CODEC.fieldOf("rolls").forGetter(p_297993_ -> p_297993_.rolls), (App)NumberProviders.CODEC.fieldOf("bonus_rolls").orElse((Object)ConstantValue.exactly(0.0f)).forGetter(p_297997_ -> p_297997_.bonusRolls)).apply((Applicative)p_344669_, LootPool::new));
    private final List<LootPoolEntryContainer> entries;
    private final List<LootItemCondition> conditions;
    private final Predicate<LootContext> compositeCondition;
    private final List<LootItemFunction> functions;
    private final BiFunction<ItemStack, LootContext, ItemStack> compositeFunction;
    private final NumberProvider rolls;
    private final NumberProvider bonusRolls;

    LootPool(List<LootPoolEntryContainer> p_298764_, List<LootItemCondition> p_299316_, List<LootItemFunction> p_298954_, NumberProvider p_165131_, NumberProvider p_165132_) {
        this.entries = p_298764_;
        this.conditions = p_299316_;
        this.compositeCondition = Util.allOf(p_299316_);
        this.functions = p_298954_;
        this.compositeFunction = LootItemFunctions.compose(p_298954_);
        this.rolls = p_165131_;
        this.bonusRolls = p_165132_;
    }

    private void addRandomItem(Consumer<ItemStack> p_79059_, LootContext p_79060_) {
        RandomSource $$2 = p_79060_.getRandom();
        ArrayList $$3 = Lists.newArrayList();
        MutableInt $$4 = new MutableInt();
        for (LootPoolEntryContainer $$5 : this.entries) {
            $$5.expand(p_79060_, p_79048_ -> {
                int $$4 = p_79048_.getWeight(p_79060_.getLuck());
                if ($$4 > 0) {
                    $$3.add(p_79048_);
                    $$4.add($$4);
                }
            });
        }
        int $$6 = $$3.size();
        if ($$4.intValue() == 0 || $$6 == 0) {
            return;
        }
        if ($$6 == 1) {
            ((LootPoolEntry)$$3.get(0)).createItemStack(p_79059_, p_79060_);
            return;
        }
        int $$7 = $$2.nextInt($$4.intValue());
        for (LootPoolEntry $$8 : $$3) {
            if (($$7 -= $$8.getWeight(p_79060_.getLuck())) >= 0) continue;
            $$8.createItemStack(p_79059_, p_79060_);
            return;
        }
    }

    public void addRandomItems(Consumer<ItemStack> p_79054_, LootContext p_79055_) {
        if (!this.compositeCondition.test(p_79055_)) {
            return;
        }
        Consumer<ItemStack> $$2 = LootItemFunction.decorate(this.compositeFunction, p_79054_, p_79055_);
        int $$3 = this.rolls.getInt(p_79055_) + Mth.floor(this.bonusRolls.getFloat(p_79055_) * p_79055_.getLuck());
        for (int $$4 = 0; $$4 < $$3; ++$$4) {
            this.addRandomItem($$2, p_79055_);
        }
    }

    public void validate(ValidationContext p_79052_) {
        for (int $$1 = 0; $$1 < this.conditions.size(); ++$$1) {
            this.conditions.get($$1).validate(p_79052_.forChild(".condition[" + $$1 + "]"));
        }
        for (int $$2 = 0; $$2 < this.functions.size(); ++$$2) {
            this.functions.get($$2).validate(p_79052_.forChild(".functions[" + $$2 + "]"));
        }
        for (int $$3 = 0; $$3 < this.entries.size(); ++$$3) {
            this.entries.get($$3).validate(p_79052_.forChild(".entries[" + $$3 + "]"));
        }
        this.rolls.validate(p_79052_.forChild(".rolls"));
        this.bonusRolls.validate(p_79052_.forChild(".bonusRolls"));
    }

    public static Builder lootPool() {
        return new Builder();
    }

    public static class Builder
    implements FunctionUserBuilder<Builder>,
    ConditionUserBuilder<Builder> {
        private final ImmutableList.Builder<LootPoolEntryContainer> entries = ImmutableList.builder();
        private final ImmutableList.Builder<LootItemCondition> conditions = ImmutableList.builder();
        private final ImmutableList.Builder<LootItemFunction> functions = ImmutableList.builder();
        private NumberProvider rolls = ConstantValue.exactly(1.0f);
        private NumberProvider bonusRolls = ConstantValue.exactly(0.0f);

        public Builder setRolls(NumberProvider p_165134_) {
            this.rolls = p_165134_;
            return this;
        }

        @Override
        public Builder unwrap() {
            return this;
        }

        public Builder setBonusRolls(NumberProvider p_165136_) {
            this.bonusRolls = p_165136_;
            return this;
        }

        public Builder add(LootPoolEntryContainer.Builder<?> p_79077_) {
            this.entries.add((Object)p_79077_.build());
            return this;
        }

        @Override
        public Builder when(LootItemCondition.Builder p_79081_) {
            this.conditions.add((Object)p_79081_.build());
            return this;
        }

        @Override
        public Builder apply(LootItemFunction.Builder p_79079_) {
            this.functions.add((Object)p_79079_.build());
            return this;
        }

        public LootPool build() {
            return new LootPool((List<LootPoolEntryContainer>)this.entries.build(), (List<LootItemCondition>)this.conditions.build(), (List<LootItemFunction>)this.functions.build(), this.rolls, this.bonusRolls);
        }

        @Override
        public /* synthetic */ FunctionUserBuilder unwrap() {
            return this.unwrap();
        }

        @Override
        public /* synthetic */ FunctionUserBuilder apply(LootItemFunction.Builder builder) {
            return this.apply(builder);
        }

        @Override
        public /* synthetic */ ConditionUserBuilder unwrap() {
            return this.unwrap();
        }

        @Override
        public /* synthetic */ ConditionUserBuilder when(LootItemCondition.Builder builder) {
            return this.when(builder);
        }
    }
}

