/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.validation;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.level.validation.ForbiddenSymlinkInfo;

public class DirectoryValidator {
    private final PathMatcher symlinkTargetAllowList;

    public DirectoryValidator(PathMatcher p_294971_) {
        this.symlinkTargetAllowList = p_294971_;
    }

    public void validateSymlink(Path p_289934_, List<ForbiddenSymlinkInfo> p_289972_) throws IOException {
        Path $$2 = Files.readSymbolicLink(p_289934_);
        if (!this.symlinkTargetAllowList.matches($$2)) {
            p_289972_.add(new ForbiddenSymlinkInfo(p_289934_, $$2));
        }
    }

    public List<ForbiddenSymlinkInfo> validateSymlink(Path p_295438_) throws IOException {
        ArrayList<ForbiddenSymlinkInfo> $$1 = new ArrayList<ForbiddenSymlinkInfo>();
        this.validateSymlink(p_295438_, $$1);
        return $$1;
    }

    /*
     * WARNING - void declaration
     */
    public List<ForbiddenSymlinkInfo> validateDirectory(Path p_294195_, boolean p_295763_) throws IOException {
        void $$5;
        ArrayList<ForbiddenSymlinkInfo> $$2 = new ArrayList<ForbiddenSymlinkInfo>();
        try {
            BasicFileAttributes $$3 = Files.readAttributes(p_294195_, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
        }
        catch (NoSuchFileException $$4) {
            return $$2;
        }
        if ($$5.isRegularFile()) {
            throw new IOException("Path " + String.valueOf(p_294195_) + " is not a directory");
        }
        if ($$5.isSymbolicLink()) {
            if (p_295763_) {
                p_294195_ = Files.readSymbolicLink(p_294195_);
            } else {
                this.validateSymlink(p_294195_, $$2);
                return $$2;
            }
        }
        this.validateKnownDirectory(p_294195_, $$2);
        return $$2;
    }

    public void validateKnownDirectory(Path p_294739_, final List<ForbiddenSymlinkInfo> p_295266_) throws IOException {
        Files.walkFileTree(p_294739_, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            private void validateSymlink(Path p_289935_, BasicFileAttributes p_289941_) throws IOException {
                if (p_289941_.isSymbolicLink()) {
                    DirectoryValidator.this.validateSymlink(p_289935_, p_295266_);
                }
            }

            @Override
            public FileVisitResult preVisitDirectory(Path p_289946_, BasicFileAttributes p_289950_) throws IOException {
                this.validateSymlink(p_289946_, p_289950_);
                return super.preVisitDirectory(p_289946_, p_289950_);
            }

            @Override
            public FileVisitResult visitFile(Path p_289986_, BasicFileAttributes p_289991_) throws IOException {
                this.validateSymlink(p_289986_, p_289991_);
                return super.visitFile(p_289986_, p_289991_);
            }

            @Override
            public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                return this.visitFile((Path)object, basicFileAttributes);
            }

            @Override
            public /* synthetic */ FileVisitResult preVisitDirectory(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                return this.preVisitDirectory((Path)object, basicFileAttributes);
            }
        });
    }
}

