/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.gametest.framework.StructureUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StructureBlockRenderer
implements BlockEntityRenderer<StructureBlockEntity> {
    public StructureBlockRenderer(BlockEntityRendererProvider.Context p_173675_) {
    }

    @Override
    public void render(StructureBlockEntity p_112583_, float p_112584_, PoseStack p_112585_, MultiBufferSource p_112586_, int p_112587_, int p_112588_) {
        if (Minecraft.getInstance().player.canUseGameMasterBlocks() || Minecraft.getInstance().player.isSpectator()) {
            BlockPos blockpos = p_112583_.getStructurePos();
            Vec3i vec3i = p_112583_.getStructureSize();
            if (vec3i.getX() >= 1 && vec3i.getY() >= 1 && vec3i.getZ() >= 1 && (p_112583_.getMode() == StructureMode.SAVE || p_112583_.getMode() == StructureMode.LOAD)) {
                double d7;
                double d6;
                double d4;
                double d2;
                double d0 = blockpos.getX();
                double d1 = blockpos.getZ();
                double d5 = blockpos.getY();
                double d8 = d5 + (double)vec3i.getY();
                double d3 = switch (p_112583_.getMirror()) {
                    case Mirror.LEFT_RIGHT -> {
                        d2 = vec3i.getX();
                        yield -vec3i.getZ();
                    }
                    case Mirror.FRONT_BACK -> {
                        d2 = -vec3i.getX();
                        yield vec3i.getZ();
                    }
                    default -> {
                        d2 = vec3i.getX();
                        yield vec3i.getZ();
                    }
                };
                double d9 = switch (p_112583_.getRotation()) {
                    case Rotation.CLOCKWISE_90 -> {
                        d4 = d3 < 0.0 ? d0 : d0 + 1.0;
                        d6 = d2 < 0.0 ? d1 + 1.0 : d1;
                        d7 = d4 - d3;
                        yield d6 + d2;
                    }
                    case Rotation.CLOCKWISE_180 -> {
                        d4 = d2 < 0.0 ? d0 : d0 + 1.0;
                        d6 = d3 < 0.0 ? d1 : d1 + 1.0;
                        d7 = d4 - d2;
                        yield d6 - d3;
                    }
                    case Rotation.COUNTERCLOCKWISE_90 -> {
                        d4 = d3 < 0.0 ? d0 + 1.0 : d0;
                        d6 = d2 < 0.0 ? d1 : d1 + 1.0;
                        d7 = d4 + d3;
                        yield d6 - d2;
                    }
                    default -> {
                        d4 = d2 < 0.0 ? d0 + 1.0 : d0;
                        d6 = d3 < 0.0 ? d1 + 1.0 : d1;
                        d7 = d4 + d2;
                        yield d6 + d3;
                    }
                };
                float f = 1.0f;
                float f1 = 0.9f;
                float f2 = 0.5f;
                if (p_112583_.getMode() == StructureMode.SAVE || p_112583_.getShowBoundingBox()) {
                    VertexConsumer vertexconsumer = p_112586_.getBuffer(RenderType.lines());
                    LevelRenderer.renderLineBox(p_112585_, vertexconsumer, d4, d5, d6, d7, d8, d9, 0.9f, 0.9f, 0.9f, 1.0f, 0.5f, 0.5f, 0.5f);
                }
                if (p_112583_.getMode() == StructureMode.SAVE && p_112583_.getShowAir()) {
                    this.renderInvisibleBlocks(p_112583_, p_112586_, p_112585_);
                }
            }
        }
    }

    private void renderInvisibleBlocks(StructureBlockEntity p_173677_, MultiBufferSource p_352319_, PoseStack p_173680_) {
        Level blockgetter = p_173677_.getLevel();
        VertexConsumer vertexconsumer = p_352319_.getBuffer(RenderType.lines());
        BlockPos blockpos = p_173677_.getBlockPos();
        BlockPos blockpos1 = StructureUtils.getStructureOrigin((StructureBlockEntity)p_173677_);
        for (BlockPos blockpos2 : BlockPos.betweenClosed((BlockPos)blockpos1, (BlockPos)blockpos1.offset(p_173677_.getStructureSize()).offset(-1, -1, -1))) {
            boolean flag4;
            BlockState blockstate = blockgetter.getBlockState(blockpos2);
            boolean flag = blockstate.isAir();
            boolean flag1 = blockstate.is(Blocks.STRUCTURE_VOID);
            boolean flag2 = blockstate.is(Blocks.BARRIER);
            boolean flag3 = blockstate.is(Blocks.LIGHT);
            boolean bl = flag4 = flag1 || flag2 || flag3;
            if (!flag && !flag4) continue;
            float f = flag ? 0.05f : 0.0f;
            double d0 = (float)(blockpos2.getX() - blockpos.getX()) + 0.45f - f;
            double d1 = (float)(blockpos2.getY() - blockpos.getY()) + 0.45f - f;
            double d2 = (float)(blockpos2.getZ() - blockpos.getZ()) + 0.45f - f;
            double d3 = (float)(blockpos2.getX() - blockpos.getX()) + 0.55f + f;
            double d4 = (float)(blockpos2.getY() - blockpos.getY()) + 0.55f + f;
            double d5 = (float)(blockpos2.getZ() - blockpos.getZ()) + 0.55f + f;
            if (flag) {
                LevelRenderer.renderLineBox(p_173680_, vertexconsumer, d0, d1, d2, d3, d4, d5, 0.5f, 0.5f, 1.0f, 1.0f, 0.5f, 0.5f, 1.0f);
                continue;
            }
            if (flag1) {
                LevelRenderer.renderLineBox(p_173680_, vertexconsumer, d0, d1, d2, d3, d4, d5, 1.0f, 0.75f, 0.75f, 1.0f, 1.0f, 0.75f, 0.75f);
                continue;
            }
            if (flag2) {
                LevelRenderer.renderLineBox(p_173680_, vertexconsumer, d0, d1, d2, d3, d4, d5, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f);
                continue;
            }
            if (!flag3) continue;
            LevelRenderer.renderLineBox(p_173680_, vertexconsumer, d0, d1, d2, d3, d4, d5, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        }
    }

    private void renderStructureVoids(StructureBlockEntity p_352299_, VertexConsumer p_352113_, PoseStack p_352426_) {
        Level blockgetter = p_352299_.getLevel();
        if (blockgetter != null) {
            BlockPos blockpos = p_352299_.getBlockPos();
            BlockPos blockpos1 = StructureUtils.getStructureOrigin((StructureBlockEntity)p_352299_);
            Vec3i vec3i = p_352299_.getStructureSize();
            BitSetDiscreteVoxelShape discretevoxelshape = new BitSetDiscreteVoxelShape(vec3i.getX(), vec3i.getY(), vec3i.getZ());
            for (BlockPos blockpos2 : BlockPos.betweenClosed((BlockPos)blockpos1, (BlockPos)blockpos1.offset(vec3i).offset(-1, -1, -1))) {
                if (!blockgetter.getBlockState(blockpos2).is(Blocks.STRUCTURE_VOID)) continue;
                discretevoxelshape.fill(blockpos2.getX() - blockpos1.getX(), blockpos2.getY() - blockpos1.getY(), blockpos2.getZ() - blockpos1.getZ());
            }
            discretevoxelshape.forAllFaces((p_352285_, p_352347_, p_352290_, p_352166_) -> {
                float f = 0.48f;
                float f1 = (float)(p_352347_ + blockpos1.getX() - blockpos.getX()) + 0.5f - 0.48f;
                float f2 = (float)(p_352290_ + blockpos1.getY() - blockpos.getY()) + 0.5f - 0.48f;
                float f3 = (float)(p_352166_ + blockpos1.getZ() - blockpos.getZ()) + 0.5f - 0.48f;
                float f4 = (float)(p_352347_ + blockpos1.getX() - blockpos.getX()) + 0.5f + 0.48f;
                float f5 = (float)(p_352290_ + blockpos1.getY() - blockpos.getY()) + 0.5f + 0.48f;
                float f6 = (float)(p_352166_ + blockpos1.getZ() - blockpos.getZ()) + 0.5f + 0.48f;
                LevelRenderer.renderFace(p_352426_, p_352113_, p_352285_, f1, f2, f3, f4, f5, f6, 0.75f, 0.75f, 1.0f, 0.2f);
            });
        }
    }

    @Override
    public boolean shouldRenderOffScreen(StructureBlockEntity p_112581_) {
        return true;
    }

    @Override
    public int getViewDistance() {
        return 96;
    }

    public AABB getRenderBoundingBox(StructureBlockEntity blockEntity) {
        return AABB.INFINITE;
    }
}

