/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.CrashReportDetail;
import net.minecraft.ReportType;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.redstone.CollectingNeighborUpdater;
import net.minecraft.world.level.redstone.NeighborUpdater;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Scoreboard;
import net.neoforged.neoforge.attachment.AttachmentHolder;
import net.neoforged.neoforge.common.NeoForgeConfig;
import net.neoforged.neoforge.common.extensions.IBlockEntityExtension;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.server.timings.TimeTracker;
import org.jetbrains.annotations.ApiStatus;

public abstract class Level
extends AttachmentHolder
implements LevelAccessor,
AutoCloseable,
ILevelExtension {
    public static final Codec<ResourceKey<Level>> RESOURCE_KEY_CODEC = ResourceKey.codec(Registries.DIMENSION);
    public static final ResourceKey<Level> OVERWORLD = ResourceKey.create(Registries.DIMENSION, ResourceLocation.withDefaultNamespace("overworld"));
    public static final ResourceKey<Level> NETHER = ResourceKey.create(Registries.DIMENSION, ResourceLocation.withDefaultNamespace("the_nether"));
    public static final ResourceKey<Level> END = ResourceKey.create(Registries.DIMENSION, ResourceLocation.withDefaultNamespace("the_end"));
    public static final int MAX_LEVEL_SIZE = 30000000;
    public static final int LONG_PARTICLE_CLIP_RANGE = 512;
    public static final int SHORT_PARTICLE_CLIP_RANGE = 32;
    public static final int MAX_BRIGHTNESS = 15;
    public static final int TICKS_PER_DAY = 24000;
    public static final int MAX_ENTITY_SPAWN_Y = 20000000;
    public static final int MIN_ENTITY_SPAWN_Y = -20000000;
    protected final List<TickingBlockEntity> blockEntityTickers = Lists.newArrayList();
    protected final NeighborUpdater neighborUpdater;
    private final List<TickingBlockEntity> pendingBlockEntityTickers = Lists.newArrayList();
    private boolean tickingBlockEntities;
    private final Thread thread;
    private final boolean isDebug;
    private int skyDarken;
    protected int randValue = RandomSource.create().nextInt();
    protected final int addend = 1013904223;
    public float oRainLevel;
    public float rainLevel;
    public float oThunderLevel;
    public float thunderLevel;
    public final RandomSource random = RandomSource.create();
    @Deprecated
    private final RandomSource threadSafeRandom = RandomSource.createThreadSafe();
    private final Holder<DimensionType> dimensionTypeRegistration;
    protected final WritableLevelData levelData;
    private final Supplier<ProfilerFiller> profiler;
    public final boolean isClientSide;
    private final WorldBorder worldBorder;
    private final BiomeManager biomeManager;
    private final ResourceKey<Level> dimension;
    private final RegistryAccess registryAccess;
    private final DamageSources damageSources;
    private long subTickCount;
    public boolean restoringBlockSnapshots = false;
    public boolean captureBlockSnapshots = false;
    public ArrayList<BlockSnapshot> capturedBlockSnapshots = new ArrayList();
    private final ArrayList<BlockEntity> freshBlockEntities = new ArrayList();
    private final ArrayList<BlockEntity> pendingFreshBlockEntities = new ArrayList();
    private double maxEntityRadius = 2.0;

    protected Level(WritableLevelData p_270739_, ResourceKey<Level> p_270683_, RegistryAccess p_270200_, Holder<DimensionType> p_270240_, Supplier<ProfilerFiller> p_270692_, boolean p_270904_, boolean p_270470_, long p_270248_, int p_270466_) {
        this.profiler = p_270692_;
        this.levelData = p_270739_;
        this.dimensionTypeRegistration = p_270240_;
        final DimensionType dimensiontype = p_270240_.value();
        this.dimension = p_270683_;
        this.isClientSide = p_270904_;
        this.worldBorder = dimensiontype.coordinateScale() != 1.0 ? new WorldBorder(this){

            public double getCenterX() {
                return super.getCenterX() / dimensiontype.coordinateScale();
            }

            public double getCenterZ() {
                return super.getCenterZ() / dimensiontype.coordinateScale();
            }
        } : new WorldBorder();
        this.thread = Thread.currentThread();
        this.biomeManager = new BiomeManager((BiomeManager.NoiseBiomeSource)this, p_270248_);
        this.isDebug = p_270470_;
        this.neighborUpdater = new CollectingNeighborUpdater(this, p_270466_);
        this.registryAccess = p_270200_;
        this.damageSources = new DamageSources(p_270200_);
    }

    public boolean isClientSide() {
        return this.isClientSide;
    }

    @Nullable
    public MinecraftServer getServer() {
        return null;
    }

    public boolean isInWorldBounds(BlockPos p_46740_) {
        return !this.isOutsideBuildHeight(p_46740_) && Level.isInWorldBoundsHorizontal(p_46740_);
    }

    public static boolean isInSpawnableBounds(BlockPos p_46742_) {
        return !Level.isOutsideSpawnableHeight(p_46742_.getY()) && Level.isInWorldBoundsHorizontal(p_46742_);
    }

    private static boolean isInWorldBoundsHorizontal(BlockPos p_46458_) {
        return p_46458_.getX() >= -30000000 && p_46458_.getZ() >= -30000000 && p_46458_.getX() < 30000000 && p_46458_.getZ() < 30000000;
    }

    private static boolean isOutsideSpawnableHeight(int p_46725_) {
        return p_46725_ < -20000000 || p_46725_ >= 20000000;
    }

    public LevelChunk getChunkAt(BlockPos p_46746_) {
        return this.getChunk(SectionPos.blockToSectionCoord((int)p_46746_.getX()), SectionPos.blockToSectionCoord((int)p_46746_.getZ()));
    }

    public LevelChunk getChunk(int p_46727_, int p_46728_) {
        return (LevelChunk)this.getChunk(p_46727_, p_46728_, ChunkStatus.FULL);
    }

    @Nullable
    public ChunkAccess getChunk(int p_46502_, int p_46503_, ChunkStatus p_331611_, boolean p_46505_) {
        ChunkAccess chunkaccess = this.getChunkSource().getChunk(p_46502_, p_46503_, p_331611_, p_46505_);
        if (chunkaccess == null && p_46505_) {
            throw new IllegalStateException("Should always be able to create a chunk!");
        }
        return chunkaccess;
    }

    public boolean setBlock(BlockPos p_46601_, BlockState p_46602_, int p_46603_) {
        return this.setBlock(p_46601_, p_46602_, p_46603_, 512);
    }

    public boolean setBlock(BlockPos p_46605_, BlockState p_46606_, int p_46607_, int p_46608_) {
        if (this.isOutsideBuildHeight(p_46605_)) {
            return false;
        }
        if (!this.isClientSide && this.isDebug()) {
            return false;
        }
        LevelChunk levelchunk = this.getChunkAt(p_46605_);
        Block block = p_46606_.getBlock();
        p_46605_ = p_46605_.immutable();
        BlockSnapshot blockSnapshot = null;
        if (this.captureBlockSnapshots && !this.isClientSide) {
            blockSnapshot = BlockSnapshot.create(this.dimension, (LevelAccessor)this, (BlockPos)p_46605_, (int)p_46607_);
            this.capturedBlockSnapshots.add(blockSnapshot);
        }
        BlockState old = this.getBlockState(p_46605_);
        int oldLight = old.getLightEmission((BlockGetter)((Object)this), p_46605_);
        int oldOpacity = old.getLightBlock((BlockGetter)((Object)this), p_46605_);
        BlockState blockstate = levelchunk.setBlockState(p_46605_, p_46606_, (p_46607_ & 0x40) != 0);
        if (blockstate == null) {
            if (blockSnapshot != null) {
                this.capturedBlockSnapshots.remove(blockSnapshot);
            }
            return false;
        }
        BlockState blockstate1 = this.getBlockState(p_46605_);
        if (blockSnapshot == null) {
            this.markAndNotifyBlock(p_46605_, levelchunk, blockstate, p_46606_, p_46607_, p_46608_);
        }
        return true;
    }

    public void markAndNotifyBlock(BlockPos p_46605_, @Nullable LevelChunk levelchunk, BlockState blockstate, BlockState p_46606_, int p_46607_, int p_46608_) {
        Block block = p_46606_.getBlock();
        BlockState blockstate1 = this.getBlockState(p_46605_);
        if (blockstate1 == p_46606_) {
            if (blockstate != blockstate1) {
                this.setBlocksDirty(p_46605_, blockstate, blockstate1);
            }
            if ((p_46607_ & 2) != 0 && (!this.isClientSide || (p_46607_ & 4) == 0) && (this.isClientSide || levelchunk.getFullStatus() != null && levelchunk.getFullStatus().isOrAfter(FullChunkStatus.BLOCK_TICKING))) {
                this.sendBlockUpdated(p_46605_, blockstate, p_46606_, p_46607_);
            }
            if ((p_46607_ & 1) != 0) {
                this.blockUpdated(p_46605_, blockstate.getBlock());
                if (!this.isClientSide && p_46606_.hasAnalogOutputSignal()) {
                    this.updateNeighbourForOutputSignal(p_46605_, block);
                }
            }
            if ((p_46607_ & 0x10) == 0 && p_46608_ > 0) {
                int i = p_46607_ & 0xFFFFFFDE;
                blockstate.updateIndirectNeighbourShapes(this, p_46605_, i, p_46608_ - 1);
                p_46606_.updateNeighbourShapes(this, p_46605_, i, p_46608_ - 1);
                p_46606_.updateIndirectNeighbourShapes(this, p_46605_, i, p_46608_ - 1);
            }
            this.onBlockStateChange(p_46605_, blockstate, blockstate1);
            p_46606_.onBlockStateChange((LevelReader)((Object)this), p_46605_, blockstate);
        }
    }

    public void onBlockStateChange(BlockPos p_46609_, BlockState p_46610_, BlockState p_46611_) {
    }

    public boolean removeBlock(BlockPos p_46623_, boolean p_46624_) {
        FluidState fluidstate = this.getFluidState(p_46623_);
        return this.setBlock(p_46623_, fluidstate.createLegacyBlock(), 3 | (p_46624_ ? 64 : 0));
    }

    public boolean destroyBlock(BlockPos p_46626_, boolean p_46627_, @Nullable Entity p_46628_, int p_46629_) {
        boolean flag;
        BlockState blockstate = this.getBlockState(p_46626_);
        if (blockstate.isAir()) {
            return false;
        }
        FluidState fluidstate = this.getFluidState(p_46626_);
        if (!(blockstate.getBlock() instanceof BaseFireBlock)) {
            this.levelEvent(2001, p_46626_, Block.getId(blockstate));
        }
        if (p_46627_) {
            BlockEntity blockentity = blockstate.hasBlockEntity() ? this.getBlockEntity(p_46626_) : null;
            Block.dropResources(blockstate, this, p_46626_, blockentity, p_46628_, ItemStack.EMPTY);
        }
        if (flag = this.setBlock(p_46626_, fluidstate.createLegacyBlock(), 3, p_46629_)) {
            this.gameEvent(GameEvent.BLOCK_DESTROY, p_46626_, GameEvent.Context.of((Entity)p_46628_, (BlockState)blockstate));
        }
        return flag;
    }

    public void addDestroyBlockEffect(BlockPos p_151531_, BlockState p_151532_) {
    }

    public boolean setBlockAndUpdate(BlockPos p_46598_, BlockState p_46599_) {
        return this.setBlock(p_46598_, p_46599_, 3);
    }

    public abstract void sendBlockUpdated(BlockPos var1, BlockState var2, BlockState var3, int var4);

    public void setBlocksDirty(BlockPos p_46678_, BlockState p_46679_, BlockState p_46680_) {
    }

    public void updateNeighborsAt(BlockPos p_46673_, Block p_46674_) {
        EventHooks.onNeighborNotify((Level)this, (BlockPos)p_46673_, (BlockState)this.getBlockState(p_46673_), EnumSet.allOf(Direction.class), (boolean)false).isCanceled();
    }

    public void updateNeighborsAtExceptFromFacing(BlockPos p_46591_, Block p_46592_, Direction p_46593_) {
    }

    public void neighborChanged(BlockPos p_46587_, Block p_46588_, BlockPos p_46589_) {
    }

    public void neighborChanged(BlockState p_220379_, BlockPos p_220380_, Block p_220381_, BlockPos p_220382_, boolean p_220383_) {
    }

    public void neighborShapeChanged(Direction p_220385_, BlockState p_220386_, BlockPos p_220387_, BlockPos p_220388_, int p_220389_, int p_220390_) {
        this.neighborUpdater.shapeUpdate(p_220385_, p_220386_, p_220387_, p_220388_, p_220389_, p_220390_);
    }

    public int getHeight(Heightmap.Types p_46571_, int p_46572_, int p_46573_) {
        int i = p_46572_ >= -30000000 && p_46573_ >= -30000000 && p_46572_ < 30000000 && p_46573_ < 30000000 ? (this.hasChunk(SectionPos.blockToSectionCoord((int)p_46572_), SectionPos.blockToSectionCoord((int)p_46573_)) ? this.getChunk(SectionPos.blockToSectionCoord((int)p_46572_), SectionPos.blockToSectionCoord((int)p_46573_)).getHeight(p_46571_, p_46572_ & 0xF, p_46573_ & 0xF) + 1 : this.getMinBuildHeight()) : this.getSeaLevel() + 1;
        return i;
    }

    public LevelLightEngine getLightEngine() {
        return this.getChunkSource().getLightEngine();
    }

    public BlockState getBlockState(BlockPos p_46732_) {
        if (this.isOutsideBuildHeight(p_46732_)) {
            return Blocks.VOID_AIR.defaultBlockState();
        }
        LevelChunk levelchunk = this.getChunk(SectionPos.blockToSectionCoord((int)p_46732_.getX()), SectionPos.blockToSectionCoord((int)p_46732_.getZ()));
        return levelchunk.getBlockState(p_46732_);
    }

    public FluidState getFluidState(BlockPos p_46671_) {
        if (this.isOutsideBuildHeight(p_46671_)) {
            return Fluids.EMPTY.defaultFluidState();
        }
        LevelChunk levelchunk = this.getChunkAt(p_46671_);
        return levelchunk.getFluidState(p_46671_);
    }

    public boolean isDay() {
        return !this.dimensionType().hasFixedTime() && this.skyDarken < 4;
    }

    public boolean isNight() {
        return !this.dimensionType().hasFixedTime() && !this.isDay();
    }

    public void playSound(@Nullable Entity p_252137_, BlockPos p_251749_, SoundEvent p_248842_, SoundSource p_251104_, float p_249531_, float p_250763_) {
        Player player;
        this.playSound(p_252137_ instanceof Player ? (player = (Player)p_252137_) : null, p_251749_, p_248842_, p_251104_, p_249531_, p_250763_);
    }

    public void playSound(@Nullable Player p_46560_, BlockPos p_46561_, SoundEvent p_46562_, SoundSource p_46563_, float p_46564_, float p_46565_) {
        this.playSound(p_46560_, (double)p_46561_.getX() + 0.5, (double)p_46561_.getY() + 0.5, (double)p_46561_.getZ() + 0.5, p_46562_, p_46563_, p_46564_, p_46565_);
    }

    public abstract void playSeededSound(@Nullable Player var1, double var2, double var4, double var6, Holder<SoundEvent> var8, SoundSource var9, float var10, float var11, long var12);

    public void playSeededSound(@Nullable Player p_220363_, double p_220364_, double p_220365_, double p_220366_, SoundEvent p_220367_, SoundSource p_220368_, float p_220369_, float p_220370_, long p_220371_) {
        this.playSeededSound(p_220363_, p_220364_, p_220365_, p_220366_, BuiltInRegistries.SOUND_EVENT.wrapAsHolder(p_220367_), p_220368_, p_220369_, p_220370_, p_220371_);
    }

    public abstract void playSeededSound(@Nullable Player var1, Entity var2, Holder<SoundEvent> var3, SoundSource var4, float var5, float var6, long var7);

    public void playSound(@Nullable Player p_309201_, double p_308925_, double p_309072_, double p_308916_, SoundEvent p_308917_, SoundSource p_308902_) {
        this.playSound(p_309201_, p_308925_, p_309072_, p_308916_, p_308917_, p_308902_, 1.0f, 1.0f);
    }

    public void playSound(@Nullable Player p_46543_, double p_46544_, double p_46545_, double p_46546_, SoundEvent p_46547_, SoundSource p_46548_, float p_46549_, float p_46550_) {
        this.playSeededSound(p_46543_, p_46544_, p_46545_, p_46546_, p_46547_, p_46548_, p_46549_, p_46550_, this.threadSafeRandom.nextLong());
    }

    public void playSound(@Nullable Player p_347719_, double p_347460_, double p_347457_, double p_347558_, Holder<SoundEvent> p_347499_, SoundSource p_347522_, float p_347447_, float p_347667_) {
        this.playSeededSound(p_347719_, p_347460_, p_347457_, p_347558_, p_347499_, p_347522_, p_347447_, p_347667_, this.threadSafeRandom.nextLong());
    }

    public void playSound(@Nullable Player p_46551_, Entity p_46552_, SoundEvent p_46553_, SoundSource p_46554_, float p_46555_, float p_46556_) {
        this.playSeededSound(p_46551_, p_46552_, BuiltInRegistries.SOUND_EVENT.wrapAsHolder(p_46553_), p_46554_, p_46555_, p_46556_, this.threadSafeRandom.nextLong());
    }

    public void playLocalSound(BlockPos p_250938_, SoundEvent p_252209_, SoundSource p_249161_, float p_249980_, float p_250277_, boolean p_250151_) {
        this.playLocalSound((double)p_250938_.getX() + 0.5, (double)p_250938_.getY() + 0.5, (double)p_250938_.getZ() + 0.5, p_252209_, p_249161_, p_249980_, p_250277_, p_250151_);
    }

    public void playLocalSound(Entity p_312189_, SoundEvent p_312080_, SoundSource p_312905_, float p_312914_, float p_312831_) {
    }

    public void playLocalSound(double p_46482_, double p_46483_, double p_46484_, SoundEvent p_46485_, SoundSource p_46486_, float p_46487_, float p_46488_, boolean p_46489_) {
    }

    public void addParticle(ParticleOptions p_46631_, double p_46632_, double p_46633_, double p_46634_, double p_46635_, double p_46636_, double p_46637_) {
    }

    public void addParticle(ParticleOptions p_46638_, boolean p_46639_, double p_46640_, double p_46641_, double p_46642_, double p_46643_, double p_46644_, double p_46645_) {
    }

    public void addAlwaysVisibleParticle(ParticleOptions p_46684_, double p_46685_, double p_46686_, double p_46687_, double p_46688_, double p_46689_, double p_46690_) {
    }

    public void addAlwaysVisibleParticle(ParticleOptions p_46691_, boolean p_46692_, double p_46693_, double p_46694_, double p_46695_, double p_46696_, double p_46697_, double p_46698_) {
    }

    public float getSunAngle(float p_46491_) {
        float f = this.getTimeOfDay(p_46491_);
        return f * ((float)Math.PI * 2);
    }

    public void addBlockEntityTicker(TickingBlockEntity p_151526_) {
        (this.tickingBlockEntities ? this.pendingBlockEntityTickers : this.blockEntityTickers).add(p_151526_);
    }

    public void addFreshBlockEntities(Collection<BlockEntity> beList) {
        if (this.tickingBlockEntities) {
            this.pendingFreshBlockEntities.addAll(beList);
        } else {
            this.freshBlockEntities.addAll(beList);
        }
    }

    protected void tickBlockEntities() {
        ProfilerFiller profilerfiller = this.getProfiler();
        profilerfiller.push("blockEntities");
        if (!this.pendingFreshBlockEntities.isEmpty()) {
            this.freshBlockEntities.addAll(this.pendingFreshBlockEntities);
            this.pendingFreshBlockEntities.clear();
        }
        this.tickingBlockEntities = true;
        if (!this.freshBlockEntities.isEmpty()) {
            this.freshBlockEntities.forEach(IBlockEntityExtension::onLoad);
            this.freshBlockEntities.clear();
        }
        if (!this.pendingBlockEntityTickers.isEmpty()) {
            this.blockEntityTickers.addAll(this.pendingBlockEntityTickers);
            this.pendingBlockEntityTickers.clear();
        }
        Iterator<TickingBlockEntity> iterator = this.blockEntityTickers.iterator();
        boolean flag = this.tickRateManager().runsNormally();
        while (iterator.hasNext()) {
            TickingBlockEntity tickingblockentity = iterator.next();
            if (tickingblockentity.isRemoved()) {
                iterator.remove();
                continue;
            }
            if (!flag || !this.shouldTickBlocksAt(tickingblockentity.getPos())) continue;
            tickingblockentity.tick();
        }
        this.tickingBlockEntities = false;
        profilerfiller.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Entity> void guardEntityTick(Consumer<T> p_46654_, T p_46655_) {
        block6: {
            try {
                TimeTracker.ENTITY_UPDATE.trackStart(p_46655_);
                p_46654_.accept(p_46655_);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.forThrowable(throwable, "Ticking entity");
                CrashReportCategory crashreportcategory = crashreport.addCategory("Entity being ticked");
                p_46655_.fillCrashReportCategory(crashreportcategory);
                if (((Boolean)NeoForgeConfig.SERVER.removeErroringEntities.get()).booleanValue()) {
                    LogUtils.getLogger().error("{}", (Object)crashreport.getFriendlyReport(ReportType.CRASH));
                    p_46655_.discard();
                    break block6;
                }
                throw new ReportedException(crashreport);
            }
            finally {
                TimeTracker.ENTITY_UPDATE.trackEnd(p_46655_);
            }
        }
    }

    public boolean shouldTickDeath(Entity p_186458_) {
        return true;
    }

    public boolean shouldTickBlocksAt(long p_186456_) {
        return true;
    }

    public boolean shouldTickBlocksAt(BlockPos p_220394_) {
        return this.shouldTickBlocksAt(ChunkPos.asLong((BlockPos)p_220394_));
    }

    public Explosion explode(@Nullable Entity p_256599_, double p_255914_, double p_255684_, double p_255843_, float p_256310_, ExplosionInteraction p_256178_) {
        return this.explode(p_256599_, Explosion.getDefaultDamageSource(this, p_256599_), null, p_255914_, p_255684_, p_255843_, p_256310_, false, p_256178_, (ParticleOptions)ParticleTypes.EXPLOSION, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, SoundEvents.GENERIC_EXPLODE);
    }

    public Explosion explode(@Nullable Entity p_255682_, double p_255803_, double p_256403_, double p_256538_, float p_255674_, boolean p_256634_, ExplosionInteraction p_256111_) {
        return this.explode(p_255682_, Explosion.getDefaultDamageSource(this, p_255682_), null, p_255803_, p_256403_, p_256538_, p_255674_, p_256634_, p_256111_, (ParticleOptions)ParticleTypes.EXPLOSION, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, SoundEvents.GENERIC_EXPLODE);
    }

    public Explosion explode(@Nullable Entity p_255653_, @Nullable DamageSource p_256558_, @Nullable ExplosionDamageCalculator p_255929_, Vec3 p_256001_, float p_255963_, boolean p_256099_, ExplosionInteraction p_256371_) {
        return this.explode(p_255653_, p_256558_, p_255929_, p_256001_.x(), p_256001_.y(), p_256001_.z(), p_255963_, p_256099_, p_256371_, (ParticleOptions)ParticleTypes.EXPLOSION, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, SoundEvents.GENERIC_EXPLODE);
    }

    public Explosion explode(@Nullable Entity p_256145_, @Nullable DamageSource p_256004_, @Nullable ExplosionDamageCalculator p_255696_, double p_256208_, double p_256036_, double p_255746_, float p_256647_, boolean p_256098_, ExplosionInteraction p_256104_) {
        return this.explode(p_256145_, p_256004_, p_255696_, p_256208_, p_256036_, p_255746_, p_256647_, p_256098_, p_256104_, (ParticleOptions)ParticleTypes.EXPLOSION, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, SoundEvents.GENERIC_EXPLODE);
    }

    public Explosion explode(@Nullable Entity p_256233_, @Nullable DamageSource p_255861_, @Nullable ExplosionDamageCalculator p_255867_, double p_256447_, double p_255732_, double p_255717_, float p_256013_, boolean p_256228_, ExplosionInteraction p_255784_, ParticleOptions p_311886_, ParticleOptions p_311887_, Holder<SoundEvent> p_320084_) {
        return this.explode(p_256233_, p_255861_, p_255867_, p_256447_, p_255732_, p_255717_, p_256013_, p_256228_, p_255784_, true, p_311886_, p_311887_, p_320084_);
    }

    public Explosion explode(@Nullable Entity p_311934_, @Nullable DamageSource p_312790_, @Nullable ExplosionDamageCalculator p_311975_, double p_312493_, double p_312456_, double p_312719_, float p_312292_, boolean p_312144_, ExplosionInteraction p_312265_, boolean p_312145_, ParticleOptions p_312842_, ParticleOptions p_312060_, Holder<SoundEvent> p_320283_) {
        Explosion.BlockInteraction explosion$blockinteraction = switch (p_312265_.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Explosion.BlockInteraction.KEEP;
            case 1 -> this.getDestroyType((GameRules.Key<GameRules.BooleanValue>)GameRules.RULE_BLOCK_EXPLOSION_DROP_DECAY);
            case 2 -> {
                if (EventHooks.canEntityGrief((Level)this, (Entity)p_311934_)) {
                    yield this.getDestroyType((GameRules.Key<GameRules.BooleanValue>)GameRules.RULE_MOB_EXPLOSION_DROP_DECAY);
                }
                yield Explosion.BlockInteraction.KEEP;
            }
            case 3 -> this.getDestroyType((GameRules.Key<GameRules.BooleanValue>)GameRules.RULE_TNT_EXPLOSION_DROP_DECAY);
            case 4 -> Explosion.BlockInteraction.TRIGGER_BLOCK;
        };
        Explosion explosion = new Explosion(this, p_311934_, p_312790_, p_311975_, p_312493_, p_312456_, p_312719_, p_312292_, p_312144_, explosion$blockinteraction, p_312842_, p_312060_, p_320283_);
        if (EventHooks.onExplosionStart((Level)this, (Explosion)explosion)) {
            return explosion;
        }
        explosion.explode();
        explosion.finalizeExplosion(p_312145_);
        return explosion;
    }

    private Explosion.BlockInteraction getDestroyType(GameRules.Key<GameRules.BooleanValue> p_256250_) {
        return this.getGameRules().getBoolean(p_256250_) ? Explosion.BlockInteraction.DESTROY_WITH_DECAY : Explosion.BlockInteraction.DESTROY;
    }

    public abstract String gatherChunkSourceStats();

    @Nullable
    public BlockEntity getBlockEntity(BlockPos p_46716_) {
        if (this.isOutsideBuildHeight(p_46716_)) {
            return null;
        }
        return !this.isClientSide && Thread.currentThread() != this.thread ? null : this.getChunkAt(p_46716_).getBlockEntity(p_46716_, LevelChunk.EntityCreationType.IMMEDIATE);
    }

    public void setBlockEntity(BlockEntity p_151524_) {
        BlockPos blockpos = p_151524_.getBlockPos();
        if (!this.isOutsideBuildHeight(blockpos)) {
            this.getChunkAt(blockpos).addAndRegisterBlockEntity(p_151524_);
        }
    }

    public void removeBlockEntity(BlockPos p_46748_) {
        if (!this.isOutsideBuildHeight(p_46748_)) {
            this.getChunkAt(p_46748_).removeBlockEntity(p_46748_);
        }
        this.updateNeighbourForOutputSignal(p_46748_, this.getBlockState(p_46748_).getBlock());
    }

    public boolean isLoaded(BlockPos p_46750_) {
        return this.isOutsideBuildHeight(p_46750_) ? false : this.getChunkSource().hasChunk(SectionPos.blockToSectionCoord((int)p_46750_.getX()), SectionPos.blockToSectionCoord((int)p_46750_.getZ()));
    }

    public boolean loadedAndEntityCanStandOnFace(BlockPos p_46579_, Entity p_46580_, Direction p_46581_) {
        if (this.isOutsideBuildHeight(p_46579_)) {
            return false;
        }
        ChunkAccess chunkaccess = this.getChunk(SectionPos.blockToSectionCoord((int)p_46579_.getX()), SectionPos.blockToSectionCoord((int)p_46579_.getZ()), ChunkStatus.FULL, false);
        return chunkaccess == null ? false : chunkaccess.getBlockState(p_46579_).entityCanStandOnFace((BlockGetter)((Object)this), p_46579_, p_46580_, p_46581_);
    }

    public boolean loadedAndEntityCanStandOn(BlockPos p_46576_, Entity p_46577_) {
        return this.loadedAndEntityCanStandOnFace(p_46576_, p_46577_, Direction.UP);
    }

    public void updateSkyBrightness() {
        double d0 = 1.0 - (double)(this.getRainLevel(1.0f) * 5.0f) / 16.0;
        double d1 = 1.0 - (double)(this.getThunderLevel(1.0f) * 5.0f) / 16.0;
        double d2 = 0.5 + 2.0 * Mth.clamp((double)Mth.cos((float)(this.getTimeOfDay(1.0f) * ((float)Math.PI * 2))), (double)-0.25, (double)0.25);
        this.skyDarken = (int)((1.0 - d2 * d0 * d1) * 11.0);
    }

    public void setSpawnSettings(boolean p_46704_, boolean p_46705_) {
        this.getChunkSource().setSpawnSettings(p_46704_, p_46705_);
    }

    public BlockPos getSharedSpawnPos() {
        BlockPos blockpos = this.levelData.getSpawnPos();
        if (!this.getWorldBorder().isWithinBounds(blockpos)) {
            blockpos = this.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, BlockPos.containing((double)this.getWorldBorder().getCenterX(), (double)0.0, (double)this.getWorldBorder().getCenterZ()));
        }
        return blockpos;
    }

    public float getSharedSpawnAngle() {
        return this.levelData.getSpawnAngle();
    }

    protected void prepareWeather() {
        if (this.levelData.isRaining()) {
            this.rainLevel = 1.0f;
            if (this.levelData.isThundering()) {
                this.thunderLevel = 1.0f;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.getChunkSource().close();
    }

    @Nullable
    public BlockGetter getChunkForCollisions(int p_46711_, int p_46712_) {
        return this.getChunk(p_46711_, p_46712_, ChunkStatus.FULL, false);
    }

    public List<Entity> getEntities(@Nullable Entity p_46536_, AABB p_46537_, Predicate<? super Entity> p_46538_) {
        this.getProfiler().incrementCounter("getEntities");
        ArrayList list = Lists.newArrayList();
        this.getEntities().get(p_46537_, p_151522_ -> {
            if (p_151522_ != p_46536_ && p_46538_.test((Entity)((Object)p_151522_))) {
                list.add(p_151522_);
            }
        });
        for (PartEntity p : this.getPartEntities()) {
            if (p == p_46536_ || !p.getBoundingBox().intersects(p_46537_) || !p_46538_.test((Entity)p)) continue;
            list.add(p);
        }
        return list;
    }

    public <T extends Entity> List<T> getEntities(EntityTypeTest<Entity, T> p_151528_, AABB p_151529_, Predicate<? super T> p_151530_) {
        ArrayList list = Lists.newArrayList();
        this.getEntities(p_151528_, p_151529_, p_151530_, list);
        return list;
    }

    public <T extends Entity> void getEntities(EntityTypeTest<Entity, T> p_261899_, AABB p_261837_, Predicate<? super T> p_261519_, List<? super T> p_262046_) {
        this.getEntities(p_261899_, p_261837_, p_261519_, p_262046_, Integer.MAX_VALUE);
    }

    public <T extends Entity> void getEntities(EntityTypeTest<Entity, T> p_261885_, AABB p_262086_, Predicate<? super T> p_261688_, List<? super T> p_262071_, int p_261858_) {
        this.getProfiler().incrementCounter("getEntities");
        this.getEntities().get(p_261885_, p_262086_, p_261454_ -> {
            if (p_261688_.test((Entity)((Object)p_261454_))) {
                p_262071_.add(p_261454_);
                if (p_262071_.size() >= p_261858_) {
                    return AbortableIterationConsumer.Continuation.ABORT;
                }
            }
            return AbortableIterationConsumer.Continuation.CONTINUE;
        });
        for (PartEntity p : this.getPartEntities()) {
            Entity t = (Entity)((Object)p_261885_.tryCast((Object)p));
            if (t == null || !t.getBoundingBox().intersects(p_262086_) || !p_261688_.test(t)) continue;
            p_262071_.add((T)((Object)t));
            if (p_262071_.size() < p_261858_) continue;
            break;
        }
    }

    @Nullable
    public abstract Entity getEntity(int var1);

    public void blockEntityChanged(BlockPos p_151544_) {
        if (this.hasChunkAt(p_151544_)) {
            this.getChunkAt(p_151544_).setUnsaved(true);
        }
    }

    public int getSeaLevel() {
        return 63;
    }

    public void disconnect() {
    }

    public long getGameTime() {
        return this.levelData.getGameTime();
    }

    public long getDayTime() {
        return this.levelData.getDayTime();
    }

    public boolean mayInteract(Player p_46557_, BlockPos p_46558_) {
        return true;
    }

    public void broadcastEntityEvent(Entity p_46509_, byte p_46510_) {
    }

    public void broadcastDamageEvent(Entity p_270831_, DamageSource p_270361_) {
    }

    public void blockEvent(BlockPos p_46582_, Block p_46583_, int p_46584_, int p_46585_) {
        this.getBlockState(p_46582_).triggerEvent(this, p_46582_, p_46584_, p_46585_);
    }

    public LevelData getLevelData() {
        return this.levelData;
    }

    public GameRules getGameRules() {
        return this.levelData.getGameRules();
    }

    public abstract TickRateManager tickRateManager();

    public float getThunderLevel(float p_46662_) {
        return Mth.lerp((float)p_46662_, (float)this.oThunderLevel, (float)this.thunderLevel) * this.getRainLevel(p_46662_);
    }

    public void setThunderLevel(float p_46708_) {
        float f;
        this.oThunderLevel = f = Mth.clamp((float)p_46708_, (float)0.0f, (float)1.0f);
        this.thunderLevel = f;
    }

    public float getRainLevel(float p_46723_) {
        return Mth.lerp((float)p_46723_, (float)this.oRainLevel, (float)this.rainLevel);
    }

    public void setRainLevel(float p_46735_) {
        float f;
        this.oRainLevel = f = Mth.clamp((float)p_46735_, (float)0.0f, (float)1.0f);
        this.rainLevel = f;
    }

    public boolean isThundering() {
        return this.dimensionType().hasSkyLight() && !this.dimensionType().hasCeiling() ? (double)this.getThunderLevel(1.0f) > 0.9 : false;
    }

    public boolean isRaining() {
        return (double)this.getRainLevel(1.0f) > 0.2;
    }

    public boolean isRainingAt(BlockPos p_46759_) {
        if (!this.isRaining()) {
            return false;
        }
        if (!this.canSeeSky(p_46759_)) {
            return false;
        }
        if (this.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, p_46759_).getY() > p_46759_.getY()) {
            return false;
        }
        Biome biome = (Biome)this.getBiome(p_46759_).value();
        return biome.getPrecipitationAt(p_46759_) == Biome.Precipitation.RAIN;
    }

    @Nullable
    public abstract MapItemSavedData getMapData(MapId var1);

    public abstract void setMapData(MapId var1, MapItemSavedData var2);

    public abstract MapId getFreeMapId();

    public void globalLevelEvent(int p_46665_, BlockPos p_46666_, int p_46667_) {
    }

    public CrashReportCategory fillReportDetails(CrashReport p_46656_) {
        CrashReportCategory crashreportcategory = p_46656_.addCategory("Affected level", 1);
        crashreportcategory.setDetail("All players", (CrashReportDetail<String>)((CrashReportDetail)() -> this.players().size() + " total; " + String.valueOf(this.players())));
        crashreportcategory.setDetail("Chunk stats", (CrashReportDetail<String>)((CrashReportDetail)() -> ((ChunkSource)this.getChunkSource()).gatherStats()));
        crashreportcategory.setDetail("Level dimension", (CrashReportDetail<String>)((CrashReportDetail)() -> this.dimension().location().toString()));
        try {
            this.levelData.fillCrashReportCategory(crashreportcategory, (LevelHeightAccessor)this);
        }
        catch (Throwable throwable) {
            crashreportcategory.setDetailError("Level Data Unobtainable", throwable);
        }
        return crashreportcategory;
    }

    public abstract void destroyBlockProgress(int var1, BlockPos var2, int var3);

    public void createFireworks(double p_46475_, double p_46476_, double p_46477_, double p_46478_, double p_46479_, double p_46480_, List<FireworkExplosion> p_332050_) {
    }

    public abstract Scoreboard getScoreboard();

    public void updateNeighbourForOutputSignal(BlockPos p_46718_, Block p_46719_) {
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = p_46718_.relative(direction);
            if (!this.hasChunkAt(blockpos)) continue;
            BlockState blockstate = this.getBlockState(blockpos);
            blockstate.onNeighborChange((LevelReader)((Object)this), blockpos, p_46718_);
            if (!blockstate.isRedstoneConductor((BlockGetter)((Object)this), blockpos) || !(blockstate = this.getBlockState(blockpos = blockpos.relative(direction))).getWeakChanges((LevelReader)((Object)this), blockpos)) continue;
            this.neighborChanged(blockstate, blockpos, p_46719_, p_46718_, false);
        }
    }

    public DifficultyInstance getCurrentDifficultyAt(BlockPos p_46730_) {
        long i = 0L;
        float f = 0.0f;
        if (this.hasChunkAt(p_46730_)) {
            f = this.getMoonBrightness();
            i = this.getChunkAt(p_46730_).getInhabitedTime();
        }
        return new DifficultyInstance(this.getDifficulty(), this.getDayTime(), i, f);
    }

    public int getSkyDarken() {
        return this.skyDarken;
    }

    public void setSkyFlashTime(int p_46709_) {
    }

    public WorldBorder getWorldBorder() {
        return this.worldBorder;
    }

    public void sendPacketToServer(Packet<?> p_46657_) {
        throw new UnsupportedOperationException("Can't send packets to server unless you're on the client.");
    }

    public DimensionType dimensionType() {
        return this.dimensionTypeRegistration.value();
    }

    public Holder<DimensionType> dimensionTypeRegistration() {
        return this.dimensionTypeRegistration;
    }

    public ResourceKey<Level> dimension() {
        return this.dimension;
    }

    public RandomSource getRandom() {
        return this.random;
    }

    public boolean isStateAtPosition(BlockPos p_46620_, Predicate<BlockState> p_46621_) {
        return p_46621_.test(this.getBlockState(p_46620_));
    }

    public boolean isFluidAtPosition(BlockPos p_151541_, Predicate<FluidState> p_151542_) {
        return p_151542_.test(this.getFluidState(p_151541_));
    }

    public abstract RecipeManager getRecipeManager();

    public BlockPos getBlockRandomPos(int p_46497_, int p_46498_, int p_46499_, int p_46500_) {
        this.randValue = this.randValue * 3 + 1013904223;
        int i = this.randValue >> 2;
        return new BlockPos(p_46497_ + (i & 0xF), p_46498_ + (i >> 16 & p_46500_), p_46499_ + (i >> 8 & 0xF));
    }

    public boolean noSave() {
        return false;
    }

    public ProfilerFiller getProfiler() {
        return this.profiler.get();
    }

    public Supplier<ProfilerFiller> getProfilerSupplier() {
        return this.profiler;
    }

    public BiomeManager getBiomeManager() {
        return this.biomeManager;
    }

    public double getMaxEntityRadius() {
        return this.maxEntityRadius;
    }

    public double increaseMaxEntityRadius(double value) {
        if (value > this.maxEntityRadius) {
            this.maxEntityRadius = value;
        }
        return this.maxEntityRadius;
    }

    public final boolean isDebug() {
        return this.isDebug;
    }

    protected abstract LevelEntityGetter<Entity> getEntities();

    public long nextSubTickCount() {
        return this.subTickCount++;
    }

    public RegistryAccess registryAccess() {
        return this.registryAccess;
    }

    public DamageSources damageSources() {
        return this.damageSources;
    }

    public abstract PotionBrewing potionBrewing();

    @ApiStatus.Internal
    public abstract void setDayTimeFraction(float var1);

    @ApiStatus.Internal
    public abstract float getDayTimeFraction();

    public abstract float getDayTimePerTick();

    public abstract void setDayTimePerTick(float var1);

    @ApiStatus.Internal
    protected long advanceDaytime() {
        if (this.getDayTimePerTick() < 0.0f) {
            return 1L;
        }
        float dayTimeStep = this.getDayTimeFraction() + this.getDayTimePerTick();
        long result = (long)dayTimeStep;
        this.setDayTimeFraction(dayTimeStep - (float)result);
        return result;
    }

    public static enum ExplosionInteraction implements StringRepresentable
    {
        NONE("none"),
        BLOCK("block"),
        MOB("mob"),
        TNT("tnt"),
        TRIGGER("trigger");

        public static final Codec<ExplosionInteraction> CODEC;
        private final String id;

        private ExplosionInteraction(String p_346300_) {
            this.id = p_346300_;
        }

        public String getSerializedName() {
            return this.id;
        }

        static {
            CODEC = StringRepresentable.fromEnum(ExplosionInteraction::values);
        }
    }
}

