/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.api.data;

import com.mojang.serialization.Codec;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7924;

public abstract class LightSourceDataProvider<L, C extends Context>
implements class_2405 {
    private final class_7784.class_7489 pathProvider;
    private final CompletableFuture<class_7225.class_7874> registryProvider;
    private final String defaultNamespace;
    private final String subPath;
    private final Codec<L> codec;

    public LightSourceDataProvider(class_7784 packOutput, CompletableFuture<class_7225.class_7874> registryProvider, String defaultNamespace, String subPath, Codec<L> codec) {
        this.registryProvider = registryProvider;
        this.defaultNamespace = defaultNamespace;
        this.pathProvider = packOutput.method_45973(class_7784.class_7490.field_39368, "dynamiclights/" + subPath);
        this.subPath = subPath;
        this.codec = codec;
    }

    public String defaultNamespace() {
        return this.defaultNamespace;
    }

    protected abstract C createContext(class_7225.class_7874 var1);

    protected abstract void generate(C var1);

    public CompletableFuture<?> method_10319(class_7403 cachedOutput) {
        return this.registryProvider.thenCompose(provider -> {
            C context = this.createContext((class_7225.class_7874)provider);
            this.generate(context);
            return CompletableFuture.allOf((CompletableFuture[])((Context)context).sources.entrySet().stream().map(entry -> class_2405.method_53496((class_7403)cachedOutput, (class_7225.class_7874)provider, this.codec, entry.getValue(), (Path)this.pathProvider.method_44107((class_2960)entry.getKey()))).toArray(CompletableFuture[]::new));
        });
    }

    public String method_10321() {
        return this.subPath + " Light Sources Provider";
    }

    protected abstract class Context {
        private final class_7225.class_7874 lookupProvider;
        private final class_7225<class_1792> itemLookup;
        private final class_7225<class_1299<?>> entityTypeLookup;
        protected final Map<class_2960, L> sources = new HashMap();

        protected Context(class_7225.class_7874 lookupProvider) {
            this.lookupProvider = lookupProvider;
            this.itemLookup = this.lookupProvider.method_46762(class_7924.field_41197);
            this.entityTypeLookup = this.lookupProvider.method_46762(class_7924.field_41266);
        }

        public class_7225.class_7874 lookupProvider() {
            return this.lookupProvider;
        }

        public class_7225<class_1792> itemLookup() {
            return this.itemLookup;
        }

        public class_7225<class_1299<?>> entityTypeLookup() {
            return this.entityTypeLookup;
        }

        public class_2960 idOf(String path) {
            return class_2960.method_60655((String)LightSourceDataProvider.this.defaultNamespace, (String)path);
        }

        public class_2960 deriveId(class_2960 originalId) {
            class_2960 id = originalId;
            if (!id.method_12836().equals(LightSourceDataProvider.this.defaultNamespace())) {
                id = this.idOf(originalId.method_12832());
                if (!originalId.method_12836().equals("minecraft")) {
                    id = id.method_45138(originalId.method_12836() + "/");
                }
            }
            return id;
        }

        public void add(class_2960 id, L source) {
            this.sources.put(id, source);
        }

        public void add(String key, L source) {
            this.add(this.idOf(key), source);
        }

        public Map<class_2960, L> sources() {
            return this.sources;
        }
    }
}

