/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.api.entity.luminance;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lambdaurora.lambdynlights.api.entity.luminance.EntityLuminance;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSourceManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Range;

public record WaterSensitiveEntityLuminance(List<EntityLuminance> outOfWater, List<EntityLuminance> inWater) implements EntityLuminance
{
    public static final MapCodec<WaterSensitiveEntityLuminance> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EntityLuminance.LIST_CODEC.optionalFieldOf("out_of_water", List.of()).forGetter(WaterSensitiveEntityLuminance::outOfWater), (App)EntityLuminance.LIST_CODEC.optionalFieldOf("in_water", List.of()).forGetter(WaterSensitiveEntityLuminance::inWater)).apply((Applicative)instance, WaterSensitiveEntityLuminance::new));

    @Override
    public EntityLuminance.Type type() {
        return EntityLuminance.Type.WATER_SENSITIVE;
    }

    @Override
    public @Range(from=0L, to=15L) int getLuminance(ItemLightSourceManager itemLightSourceManager, class_1297 entity) {
        boolean submergedInWater = entity.method_5869();
        if (submergedInWater) {
            return EntityLuminance.getLuminance(itemLightSourceManager, entity, this.inWater);
        }
        return EntityLuminance.getLuminance(itemLightSourceManager, entity, this.outOfWater);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<EntityLuminance> outOfWater = new ArrayList<EntityLuminance>();
        private final List<EntityLuminance> inWater = new ArrayList<EntityLuminance>();

        @Contract(value="_ -> this")
        public Builder outOfWater(EntityLuminance ... luminances) {
            this.outOfWater.addAll(List.of(luminances));
            return this;
        }

        @Contract(value="_ -> this")
        public Builder outOfWater(List<EntityLuminance> luminances) {
            this.outOfWater.addAll(luminances);
            return this;
        }

        @Contract(value="_ -> this")
        public Builder inWater(EntityLuminance ... luminances) {
            this.inWater.addAll(List.of(luminances));
            return this;
        }

        @Contract(value="_ -> this")
        public Builder inWater(List<EntityLuminance> luminances) {
            this.inWater.addAll(luminances);
            return this;
        }

        public WaterSensitiveEntityLuminance build() {
            return new WaterSensitiveEntityLuminance(List.copyOf(this.outOfWater), List.copyOf(this.inWater));
        }
    }
}

