/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.vertex;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_11541;
import net.minecraft.class_6177;
import org.jspecify.annotations.Nullable;

@class_6177
public class VertexFormat {
    public static final int UNKNOWN_ELEMENT = -1;
    private final List<VertexFormatElement> elements;
    private final List<String> names;
    private final int vertexSize;
    private final int elementsMask;
    private final int[] offsetsByElement = new int[32];
    private @Nullable GpuBuffer immediateDrawVertexBuffer;
    private @Nullable GpuBuffer immediateDrawIndexBuffer;

    VertexFormat(List<VertexFormatElement> $$02, List<String> $$12, IntList $$2, int $$3) {
        this.elements = $$02;
        this.names = $$12;
        this.vertexSize = $$3;
        this.elementsMask = $$02.stream().mapToInt(VertexFormatElement::mask).reduce(0, ($$0, $$1) -> $$0 | $$1);
        for (int $$4 = 0; $$4 < this.offsetsByElement.length; ++$$4) {
            VertexFormatElement $$5 = VertexFormatElement.byId($$4);
            int $$6 = $$5 != null ? $$02.indexOf($$5) : -1;
            this.offsetsByElement[$$4] = $$6 != -1 ? $$2.getInt($$6) : -1;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "VertexFormat" + String.valueOf(this.names);
    }

    public int getVertexSize() {
        return this.vertexSize;
    }

    public List<VertexFormatElement> getElements() {
        return this.elements;
    }

    public List<String> getElementAttributeNames() {
        return this.names;
    }

    public int[] getOffsetsByElement() {
        return this.offsetsByElement;
    }

    public int getOffset(VertexFormatElement $$0) {
        return this.offsetsByElement[$$0.id()];
    }

    public boolean contains(VertexFormatElement $$0) {
        return (this.elementsMask & $$0.mask()) != 0;
    }

    public int getElementsMask() {
        return this.elementsMask;
    }

    public String getElementName(VertexFormatElement $$0) {
        int $$1 = this.elements.indexOf($$0);
        if ($$1 == -1) {
            throw new IllegalArgumentException(String.valueOf($$0) + " is not contained in format");
        }
        return this.names.get($$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object $$0) {
        if (this == $$0) {
            return true;
        }
        if (!($$0 instanceof VertexFormat)) return false;
        VertexFormat $$1 = (VertexFormat)$$0;
        if (this.elementsMask != $$1.elementsMask) return false;
        if (this.vertexSize != $$1.vertexSize) return false;
        if (!this.names.equals($$1.names)) return false;
        if (!Arrays.equals(this.offsetsByElement, $$1.offsetsByElement)) return false;
        return true;
    }

    public int hashCode() {
        return this.elementsMask * 31 + Arrays.hashCode(this.offsetsByElement);
    }

    private static GpuBuffer uploadToBuffer(@Nullable GpuBuffer $$0, ByteBuffer $$1, @GpuBuffer.class_12113 int $$2, Supplier<String> $$3) {
        GpuDevice $$4 = RenderSystem.getDevice();
        if (class_11541.method_72243($$4).method_72242()) {
            if ($$0 != null) {
                $$0.close();
            }
            return $$4.createBuffer($$3, $$2, $$1);
        }
        if ($$0 == null) {
            $$0 = $$4.createBuffer($$3, $$2, $$1);
        } else {
            CommandEncoder $$5 = $$4.createCommandEncoder();
            if ($$0.size() < (long)$$1.remaining()) {
                $$0.close();
                $$0 = $$4.createBuffer($$3, $$2, $$1);
            } else {
                $$5.writeToBuffer($$0.slice(), $$1);
            }
        }
        return $$0;
    }

    public GpuBuffer uploadImmediateVertexBuffer(ByteBuffer $$0) {
        this.immediateDrawVertexBuffer = VertexFormat.uploadToBuffer(this.immediateDrawVertexBuffer, $$0, 40, () -> "Immediate vertex buffer for " + String.valueOf(this));
        return this.immediateDrawVertexBuffer;
    }

    public GpuBuffer uploadImmediateIndexBuffer(ByteBuffer $$0) {
        this.immediateDrawIndexBuffer = VertexFormat.uploadToBuffer(this.immediateDrawIndexBuffer, $$0, 72, () -> "Immediate index buffer for " + String.valueOf(this));
        return this.immediateDrawIndexBuffer;
    }

    @class_6177
    public static class Builder {
        private final ImmutableMap.Builder<String, VertexFormatElement> elements = ImmutableMap.builder();
        private final IntList offsets = new IntArrayList();
        private int offset;

        Builder() {
        }

        public Builder add(String $$0, VertexFormatElement $$1) {
            this.elements.put((Object)$$0, (Object)$$1);
            this.offsets.add(this.offset);
            this.offset += $$1.byteSize();
            return this;
        }

        public Builder padding(int $$0) {
            this.offset += $$0;
            return this;
        }

        public VertexFormat build() {
            ImmutableMap $$0 = this.elements.buildOrThrow();
            ImmutableList $$1 = $$0.values().asList();
            ImmutableList $$2 = $$0.keySet().asList();
            return new VertexFormat((List<VertexFormatElement>)$$1, (List<String>)$$2, this.offsets, this.offset);
        }
    }

    public static final class class_5596
    extends Enum<class_5596> {
        public static final /* enum */ class_5596 field_27377 = new class_5596(2, 2, false);
        public static final /* enum */ class_5596 field_29344 = new class_5596(2, 2, false);
        public static final /* enum */ class_5596 field_29345 = new class_5596(2, 1, true);
        public static final /* enum */ class_5596 field_63316 = new class_5596(1, 1, false);
        public static final /* enum */ class_5596 field_27379 = new class_5596(3, 3, false);
        public static final /* enum */ class_5596 field_27380 = new class_5596(3, 1, true);
        public static final /* enum */ class_5596 field_27381 = new class_5596(3, 1, true);
        public static final /* enum */ class_5596 field_27382 = new class_5596(4, 4, false);
        public final int field_27384;
        public final int field_27385;
        public final boolean field_38878;
        private static final /* synthetic */ class_5596[] field_27386;

        public static class_5596[] values() {
            return (class_5596[])field_27386.clone();
        }

        public static class_5596 valueOf(String $$0) {
            return Enum.valueOf(class_5596.class, $$0);
        }

        private class_5596(int $$0, int $$1, boolean $$2) {
            this.field_27384 = $$0;
            this.field_27385 = $$1;
            this.field_38878 = $$2;
        }

        public int method_31973(int $$0) {
            int $$3;
            switch (this.ordinal()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    int $$1 = $$0;
                    break;
                }
                case 0: 
                case 7: {
                    int $$2 = $$0 / 4 * 6;
                    break;
                }
                default: {
                    $$3 = 0;
                }
            }
            return $$3;
        }

        private static /* synthetic */ class_5596[] method_36817() {
            return new class_5596[]{field_27377, field_29344, field_29345, field_63316, field_27379, field_27380, field_27381, field_27382};
        }

        static {
            field_27386 = class_5596.method_36817();
        }
    }

    public static final class class_5595
    extends Enum<class_5595> {
        public static final /* enum */ class_5595 field_27372 = new class_5595(2);
        public static final /* enum */ class_5595 field_27373 = new class_5595(4);
        public final int field_27375;
        private static final /* synthetic */ class_5595[] field_27376;

        public static class_5595[] values() {
            return (class_5595[])field_27376.clone();
        }

        public static class_5595 valueOf(String $$0) {
            return Enum.valueOf(class_5595.class, $$0);
        }

        private class_5595(int $$0) {
            this.field_27375 = $$0;
        }

        public static class_5595 method_31972(int $$0) {
            if (($$0 & 0xFFFF0000) != 0) {
                return field_27373;
            }
            return field_27372;
        }

        private static /* synthetic */ class_5595[] method_36816() {
            return new class_5595[]{field_27372, field_27373};
        }

        static {
            field_27376 = class_5595.method_36816();
        }
    }
}

