/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.commons.event;

import dev.yumi.commons.collections.toposort.SortableNode;
import dev.yumi.commons.event.Event;
import dev.yumi.commons.event.FilteredEvent;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class ContextualizedEvent<I extends Comparable<? super I>, T, C>
extends Event<I, T> {
    private final C context;

    public ContextualizedEvent(FilteredEvent<I, T, C> parent, C context) {
        super(parent.type(), parent.defaultPhaseId(), parent.invokerFactory);
        this.context = context;
        for (Event.PhaseData phase : parent.phases.values()) {
            Event.PhaseData copy = this.phases.computeIfAbsent((Comparable)phase.getId(), ignored -> ((FilteredEvent.FilteredPhaseData)phase).copyFor(context));
            phase.getPreviousNodes().forEach(node -> {
                Event.PhaseData previousCopy = this.phases.computeIfAbsent((Comparable)node.getId(), ignored -> ((FilteredEvent.FilteredPhaseData)((Object)node)).copyFor(context));
                SortableNode.link((SortableNode)previousCopy, (SortableNode)copy);
            });
            phase.getNextNodes().forEach(node -> {
                Event.PhaseData nextCopy = this.phases.computeIfAbsent((Comparable)node.getId(), ignored -> ((FilteredEvent.FilteredPhaseData)((Object)node)).copyFor(context));
                SortableNode.link((SortableNode)copy, (SortableNode)nextCopy);
            });
        }
        this.sortedPhases.addAll(this.phases.values());
        this.sortPhases();
        this.rebuildInvoker(this.sortedPhases.stream().mapToInt(value -> value.listeners.length).sum());
    }

    @Contract(pure=true)
    @NotNull
    public C context() {
        return this.context;
    }

    void registerFromParent(@NotNull I phaseIdentifier, @NotNull T listener, @NotNull Predicate<C> selector) {
        if (selector.test(this.context)) {
            this.register(phaseIdentifier, listener);
        }
    }
}

