/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.commons.event.invoker;

import dev.yumi.commons.TriState;
import dev.yumi.commons.event.invoker.InvokerFactory;
import dev.yumi.commons.event.invoker.dynamic.FilterInvokerFactory;
import dev.yumi.commons.event.invoker.dynamic.SequenceInvokerFactory;
import dev.yumi.commons.event.invoker.dynamic.TriStateFilterInvokerFactory;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;

public final class DefaultInvokerFactory<T>
extends InvokerFactory<T> {
    private final InvokerFactory<T> wrapped;

    public DefaultInvokerFactory(@NotNull Class<? super T> type) {
        super(type);
        Method method = DefaultInvokerFactory.getFunctionalMethod(type);
        if (method.getReturnType() == Void.TYPE) {
            this.wrapped = new SequenceInvokerFactory<T>(type, method);
        } else if (method.getReturnType() == Boolean.TYPE) {
            this.wrapped = new FilterInvokerFactory<T>(type, method, false);
        } else if (method.getReturnType() == TriState.class) {
            this.wrapped = new TriStateFilterInvokerFactory<T>(type, method);
        } else {
            throw new IllegalArgumentException("Cannot determine default invoker factory for the given type " + String.valueOf(type) + ".");
        }
    }

    @Override
    public T apply(T[] listeners) {
        return (T)this.wrapped.apply(listeners);
    }
}

