/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.opts.dfc.common.ast.misc;

import com.ishland.c2me.opts.dfc.common.ast.AstNode;
import com.ishland.c2me.opts.dfc.common.ast.AstTransformer;
import com.ishland.c2me.opts.dfc.common.ast.EvalType;
import com.ishland.c2me.opts.dfc.common.ducks.IFastCacheLike;
import com.ishland.c2me.opts.dfc.common.gen.BytecodeGen;
import com.ishland.c2me.opts.dfc.common.gen.IMultiMethod;
import com.ishland.c2me.opts.dfc.common.gen.ISingleMethod;
import com.ishland.c2me.opts.dfc.common.gen.SubCompiledDensityFunction;
import java.util.Objects;
import net.minecraft.class_6910;
import net.minecraft.class_6916;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.InstructionAdapter;

public class CacheLikeNode
implements AstNode {
    private final IFastCacheLike cacheLike;
    private final AstNode delegate;

    public CacheLikeNode(IFastCacheLike cacheLike, AstNode delegate) {
        this.cacheLike = cacheLike;
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public double evalSingle(int x, int y, int z, EvalType type) {
        if (this.cacheLike == null) {
            return this.delegate.evalSingle(x, y, z, type);
        }
        double cached = this.cacheLike.c2me$getCached(x, y, z, type);
        if (Double.doubleToRawLongBits(cached) != 9222769054270909007L) {
            return cached;
        }
        double eval = this.delegate.evalSingle(x, y, z, type);
        this.cacheLike.c2me$cache(x, y, z, type, eval);
        return eval;
    }

    @Override
    public void evalMulti(double[] res, int[] x, int[] y, int[] z, EvalType type) {
        if (this.cacheLike == null) {
            this.delegate.evalMulti(res, x, y, z, type);
            return;
        }
        boolean cached = this.cacheLike.c2me$getCached(res, x, y, z, type);
        if (!cached) {
            this.delegate.evalMulti(res, x, y, z, type);
            this.cacheLike.c2me$cache(res, x, y, z, type);
        }
    }

    @Override
    public AstNode[] getChildren() {
        return new AstNode[]{this.delegate};
    }

    @Override
    public AstNode transform(AstTransformer transformer) {
        AstNode delegate = this.delegate.transform(transformer);
        if (this.delegate == delegate) {
            return transformer.transform(this);
        }
        return transformer.transform(new CacheLikeNode(this.cacheLike, delegate));
    }

    @Override
    public void doBytecodeGenSingle(BytecodeGen.Context context, InstructionAdapter m, BytecodeGen.Context.LocalVarConsumer localVarConsumer) {
        String delegateMethod = context.newSingleMethod(this.delegate);
        String cacheLikeField = context.newField(IFastCacheLike.class, this.cacheLike);
        this.genPostprocessingMethod(context, cacheLikeField);
        int eval = localVarConsumer.createLocalVariable("eval", Type.DOUBLE_TYPE.getDescriptor());
        Label cacheExists = new Label();
        Label cacheMiss = new Label();
        m.load(0, InstructionAdapter.OBJECT_TYPE);
        m.getfield(context.className, cacheLikeField, Type.getDescriptor(IFastCacheLike.class));
        m.ifnonnull(cacheExists);
        context.callDelegateSingle(m, delegateMethod);
        m.areturn(Type.DOUBLE_TYPE);
        m.visitLabel(cacheExists);
        m.load(0, InstructionAdapter.OBJECT_TYPE);
        m.getfield(context.className, cacheLikeField, Type.getDescriptor(IFastCacheLike.class));
        m.load(1, Type.INT_TYPE);
        m.load(2, Type.INT_TYPE);
        m.load(3, Type.INT_TYPE);
        m.load(4, InstructionAdapter.OBJECT_TYPE);
        m.invokeinterface(Type.getInternalName(IFastCacheLike.class), "c2me$getCached", Type.getMethodDescriptor((Type)Type.DOUBLE_TYPE, (Type[])new Type[]{Type.INT_TYPE, Type.INT_TYPE, Type.INT_TYPE, Type.getType(EvalType.class)}));
        m.dup2();
        m.invokestatic(Type.getInternalName(Double.class), "doubleToRawLongBits", Type.getMethodDescriptor((Type)Type.LONG_TYPE, (Type[])new Type[]{Type.DOUBLE_TYPE}), false);
        m.lconst(9222769054270909007L);
        m.lcmp();
        m.ifeq(cacheMiss);
        m.areturn(Type.DOUBLE_TYPE);
        m.visitLabel(cacheMiss);
        m.pop2();
        context.callDelegateSingle(m, delegateMethod);
        m.store(eval, Type.DOUBLE_TYPE);
        m.load(0, InstructionAdapter.OBJECT_TYPE);
        m.getfield(context.className, cacheLikeField, Type.getDescriptor(IFastCacheLike.class));
        m.load(1, Type.INT_TYPE);
        m.load(2, Type.INT_TYPE);
        m.load(3, Type.INT_TYPE);
        m.load(4, InstructionAdapter.OBJECT_TYPE);
        m.load(eval, Type.DOUBLE_TYPE);
        m.invokeinterface(Type.getInternalName(IFastCacheLike.class), "c2me$cache", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE, Type.INT_TYPE, Type.INT_TYPE, Type.getType(EvalType.class), Type.DOUBLE_TYPE}));
        m.load(eval, Type.DOUBLE_TYPE);
        m.areturn(Type.DOUBLE_TYPE);
    }

    @Override
    public void doBytecodeGenMulti(BytecodeGen.Context context, InstructionAdapter m, BytecodeGen.Context.LocalVarConsumer localVarConsumer) {
        String delegateMethod = context.newMultiMethod(this.delegate);
        String cacheLikeField = context.newField(IFastCacheLike.class, this.cacheLike);
        this.genPostprocessingMethod(context, cacheLikeField);
        Label cacheExists = new Label();
        Label cacheMiss = new Label();
        m.load(0, InstructionAdapter.OBJECT_TYPE);
        m.getfield(context.className, cacheLikeField, Type.getDescriptor(IFastCacheLike.class));
        m.ifnonnull(cacheExists);
        context.callDelegateMulti(m, delegateMethod);
        m.areturn(Type.VOID_TYPE);
        m.visitLabel(cacheExists);
        m.load(0, InstructionAdapter.OBJECT_TYPE);
        m.getfield(context.className, cacheLikeField, Type.getDescriptor(IFastCacheLike.class));
        m.load(1, InstructionAdapter.OBJECT_TYPE);
        m.load(2, InstructionAdapter.OBJECT_TYPE);
        m.load(3, InstructionAdapter.OBJECT_TYPE);
        m.load(4, InstructionAdapter.OBJECT_TYPE);
        m.load(5, InstructionAdapter.OBJECT_TYPE);
        m.invokeinterface(Type.getInternalName(IFastCacheLike.class), "c2me$getCached", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.getType(double[].class), Type.getType(int[].class), Type.getType(int[].class), Type.getType(int[].class), Type.getType(EvalType.class)}));
        m.ifeq(cacheMiss);
        m.areturn(Type.VOID_TYPE);
        m.visitLabel(cacheMiss);
        context.callDelegateMulti(m, delegateMethod);
        m.load(0, InstructionAdapter.OBJECT_TYPE);
        m.getfield(context.className, cacheLikeField, Type.getDescriptor(IFastCacheLike.class));
        m.load(1, InstructionAdapter.OBJECT_TYPE);
        m.load(2, InstructionAdapter.OBJECT_TYPE);
        m.load(3, InstructionAdapter.OBJECT_TYPE);
        m.load(4, InstructionAdapter.OBJECT_TYPE);
        m.load(5, InstructionAdapter.OBJECT_TYPE);
        m.invokeinterface(Type.getInternalName(IFastCacheLike.class), "c2me$cache", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(double[].class), Type.getType(int[].class), Type.getType(int[].class), Type.getType(int[].class), Type.getType(EvalType.class)}));
        m.areturn(Type.VOID_TYPE);
    }

    private void genPostprocessingMethod(BytecodeGen.Context context, String cacheLikeField) {
        String methodName = String.format("postProcessing_%s", cacheLikeField);
        String delegateSingle = context.newSingleMethod(this.delegate);
        String delegateMulti = context.newMultiMethod(this.delegate);
        context.genPostprocessingMethod(methodName, (InstructionAdapter m) -> {
            Label cacheExists = new Label();
            m.load(0, InstructionAdapter.OBJECT_TYPE);
            m.load(0, InstructionAdapter.OBJECT_TYPE);
            m.getfield(context.className, cacheLikeField, Type.getDescriptor(IFastCacheLike.class));
            m.dup();
            m.ifnonnull(cacheExists);
            m.pop();
            m.pop();
            m.areturn(Type.VOID_TYPE);
            m.visitLabel(cacheExists);
            m.anew(Type.getType(SubCompiledDensityFunction.class));
            m.dup();
            m.load(0, InstructionAdapter.OBJECT_TYPE);
            m.invokedynamic("evalSingle", Type.getMethodDescriptor((Type)Type.getType(ISingleMethod.class), (Type[])new Type[]{Type.getType((String)context.classDesc)}), new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false), new Object[]{Type.getMethodType((String)BytecodeGen.Context.SINGLE_DESC), new Handle(5, context.className, delegateSingle, BytecodeGen.Context.SINGLE_DESC, false), Type.getMethodType((String)BytecodeGen.Context.SINGLE_DESC)});
            m.load(0, InstructionAdapter.OBJECT_TYPE);
            m.invokedynamic("evalMulti", Type.getMethodDescriptor((Type)Type.getType(IMultiMethod.class), (Type[])new Type[]{Type.getType((String)context.classDesc)}), new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false), new Object[]{Type.getMethodType((String)BytecodeGen.Context.MULTI_DESC), new Handle(5, context.className, delegateMulti, BytecodeGen.Context.MULTI_DESC, false), Type.getMethodType((String)BytecodeGen.Context.MULTI_DESC)});
            m.load(0, InstructionAdapter.OBJECT_TYPE);
            m.getfield(context.className, cacheLikeField, Type.getDescriptor(IFastCacheLike.class));
            m.checkcast(Type.getType(class_6910.class));
            m.invokespecial(Type.getInternalName(SubCompiledDensityFunction.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(ISingleMethod.class), Type.getType(IMultiMethod.class), Type.getType(class_6910.class)}), false);
            m.checkcast(Type.getType(class_6910.class));
            m.invokeinterface(Type.getInternalName(IFastCacheLike.class), "c2me$withDelegate", Type.getMethodDescriptor((Type)Type.getType(class_6910.class), (Type[])new Type[]{Type.getType(class_6910.class)}));
            m.putfield(context.className, cacheLikeField, Type.getDescriptor(IFastCacheLike.class));
            m.areturn(Type.VOID_TYPE);
        });
    }

    public IFastCacheLike getCacheLike() {
        return this.cacheLike;
    }

    public AstNode getDelegate() {
        return this.delegate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheLikeNode that = (CacheLikeNode)o;
        return CacheLikeNode.equals(this.cacheLike, that.cacheLike) && Objects.equals(this.delegate, that.delegate);
    }

    private static boolean equals(IFastCacheLike a, IFastCacheLike b) {
        IFastCacheLike iFastCacheLike = a;
        if (iFastCacheLike instanceof class_6916.class_6927) {
            class_6916.class_6927 wrappingA = (class_6916.class_6927)iFastCacheLike;
            iFastCacheLike = b;
            if (iFastCacheLike instanceof class_6916.class_6927) {
                class_6916.class_6927 wrappingB = (class_6916.class_6927)iFastCacheLike;
                return wrappingA.comp_383() == wrappingB.comp_383();
            }
        }
        return a.equals(b);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.getClass().hashCode();
        result = 31 * result + CacheLikeNode.hashCode(this.cacheLike);
        result = 31 * result + this.delegate.hashCode();
        return result;
    }

    private static int hashCode(IFastCacheLike o) {
        IFastCacheLike iFastCacheLike = o;
        if (iFastCacheLike instanceof class_6916.class_6927) {
            class_6916.class_6927 wrapping = (class_6916.class_6927)iFastCacheLike;
            return wrapping.comp_383().hashCode();
        }
        return o.hashCode();
    }

    @Override
    public boolean relaxedEquals(AstNode o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheLikeNode that = (CacheLikeNode)o;
        return CacheLikeNode.relaxedEquals(this.cacheLike, that.cacheLike) && this.delegate.relaxedEquals(that.delegate);
    }

    private static boolean relaxedEquals(IFastCacheLike a, IFastCacheLike b) {
        IFastCacheLike iFastCacheLike = a;
        if (iFastCacheLike instanceof class_6916.class_6927) {
            class_6916.class_6927 wrappingA = (class_6916.class_6927)iFastCacheLike;
            iFastCacheLike = b;
            if (iFastCacheLike instanceof class_6916.class_6927) {
                class_6916.class_6927 wrappingB = (class_6916.class_6927)iFastCacheLike;
                return wrappingA.comp_383() == wrappingB.comp_383();
            }
        }
        return a.getClass() == b.getClass();
    }

    @Override
    public int relaxedHashCode() {
        int result = 1;
        result = 31 * result + this.getClass().hashCode();
        result = 31 * result + CacheLikeNode.relaxedHashCode(this.cacheLike);
        result = 31 * result + this.delegate.relaxedHashCode();
        return result;
    }

    private static int relaxedHashCode(IFastCacheLike o) {
        IFastCacheLike iFastCacheLike = o;
        if (iFastCacheLike instanceof class_6916.class_6927) {
            class_6916.class_6927 wrapping = (class_6916.class_6927)iFastCacheLike;
            return wrapping.comp_383().hashCode();
        }
        return o.getClass().hashCode();
    }
}

