/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.opts.dfc.common.ast.unary;

import com.ishland.c2me.opts.dfc.common.ast.AstNode;
import com.ishland.c2me.opts.dfc.common.ast.AstTransformer;
import com.ishland.c2me.opts.dfc.common.gen.BytecodeGen;
import java.util.Objects;
import org.objectweb.asm.commons.InstructionAdapter;

public abstract class AbstractUnaryNode
implements AstNode {
    protected final AstNode operand;

    public AbstractUnaryNode(AstNode operand) {
        this.operand = Objects.requireNonNull(operand);
    }

    @Override
    public AstNode[] getChildren() {
        return new AstNode[]{this.operand};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractUnaryNode that = (AbstractUnaryNode)o;
        return Objects.equals(this.operand, that.operand);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.getClass().hashCode();
        result = 31 * result + this.operand.hashCode();
        return result;
    }

    @Override
    public boolean relaxedEquals(AstNode o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractUnaryNode that = (AbstractUnaryNode)o;
        return this.operand.relaxedEquals(that.operand);
    }

    @Override
    public int relaxedHashCode() {
        int result = 1;
        result = 31 * result + this.getClass().hashCode();
        result = 31 * result + this.operand.relaxedHashCode();
        return result;
    }

    protected abstract AstNode newInstance(AstNode var1);

    @Override
    public AstNode transform(AstTransformer transformer) {
        AstNode operand = this.operand.transform(transformer);
        if (this.operand == operand) {
            return transformer.transform(this);
        }
        return transformer.transform(this.newInstance(operand));
    }

    @Override
    public void doBytecodeGenSingle(BytecodeGen.Context context, InstructionAdapter m, BytecodeGen.Context.LocalVarConsumer localVarConsumer) {
        String operandMethod = context.newSingleMethod(this.operand);
        context.callDelegateSingle(m, operandMethod);
    }

    @Override
    public void doBytecodeGenMulti(BytecodeGen.Context context, InstructionAdapter m, BytecodeGen.Context.LocalVarConsumer localVarConsumer) {
        String operandMethod = context.newMultiMethod(this.operand);
        context.callDelegateMulti(m, operandMethod);
    }
}

