/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.client.common.stats;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import me.jfenn.bingo.client.common.packet.ClientPacketEvents;
import me.jfenn.bingo.client.platform.ClientPacket;
import me.jfenn.bingo.client.platform.ISessionAccessor;
import me.jfenn.bingo.common.config.BingoConfig;
import me.jfenn.bingo.common.scope.BingoComponent;
import me.jfenn.bingo.common.stats.StatsService;
import me.jfenn.bingo.common.stats.data.PlayerGameSummary;
import me.jfenn.bingo.common.stats.packets.StatsCheckPacket;
import me.jfenn.bingo.common.stats.packets.StatsGamePacket;
import me.jfenn.bingo.common.stats.packets.StatsIndexPacket;
import me.jfenn.bingo.platform.IExecutors;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.event.IReturnEvent;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J'\u0010\u0016\u001a\u0012\u0012\u0002\b\u0003 \u0015*\b\u0012\u0002\b\u0003\u0018\u00010\u00140\u00142\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J-\u0010\u001b\u001a\u0012\u0012\u0002\b\u0003 \u0015*\b\u0012\u0002\b\u0003\u0018\u00010\u00140\u00142\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ-\u0010\u001d\u001a\u0012\u0012\u0002\b\u0003 \u0015*\b\u0012\u0002\b\u0003\u0018\u00010\u00140\u00142\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001cJ\u0017\u0010!\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b!\u0010\"R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010#R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010$R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010%R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010&R\u001c\u0010'\u001a\n \u0015*\u0004\u0018\u00010\u00190\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u0014\u0010*\u001a\u00020)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+\u00a8\u0006,"}, d2={"Lme/jfenn/bingo/client/common/stats/ClientStatsSyncController;", "Lme/jfenn/bingo/common/scope/BingoComponent;", "Lorg/slf4j/Logger;", "log", "Lme/jfenn/bingo/common/config/BingoConfig;", "config", "Lme/jfenn/bingo/client/common/packet/ClientPacketEvents;", "packets", "Lme/jfenn/bingo/common/stats/StatsService;", "stats", "Lme/jfenn/bingo/platform/IExecutors;", "executors", "Lme/jfenn/bingo/client/platform/ISessionAccessor;", "sessionAccessor", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "<init>", "(Lorg/slf4j/Logger;Lme/jfenn/bingo/common/config/BingoConfig;Lme/jfenn/bingo/client/common/packet/ClientPacketEvents;Lme/jfenn/bingo/common/stats/StatsService;Lme/jfenn/bingo/platform/IExecutors;Lme/jfenn/bingo/client/platform/ISessionAccessor;Lme/jfenn/bingo/platform/event/IEventBus;)V", "Lme/jfenn/bingo/common/stats/packets/StatsCheckPacket;", "check", "Ljava/util/concurrent/Future;", "kotlin.jvm.PlatformType", "sendKnownIdsIfMismatch", "(Lme/jfenn/bingo/common/stats/packets/StatsCheckPacket;)Ljava/util/concurrent/Future;", "", "Ljava/util/UUID;", "gameIds", "checkForMissingIds", "(Ljava/util/Set;)Ljava/util/concurrent/Future;", "sendRequestedIds", "Lme/jfenn/bingo/common/stats/data/PlayerGameSummary;", "game", "", "insertReceivedGame", "(Lme/jfenn/bingo/common/stats/data/PlayerGameSummary;)V", "Lorg/slf4j/Logger;", "Lme/jfenn/bingo/common/config/BingoConfig;", "Lme/jfenn/bingo/client/common/packet/ClientPacketEvents;", "Lme/jfenn/bingo/common/stats/StatsService;", "playerUuid", "Ljava/util/UUID;", "Ljava/util/concurrent/ExecutorService;", "executor", "Ljava/util/concurrent/ExecutorService;", "bingo-common_client"})
@Environment(value=EnvType.CLIENT)
public final class ClientStatsSyncController
extends BingoComponent {
    @NotNull
    private final Logger log;
    @NotNull
    private final BingoConfig config;
    @NotNull
    private final ClientPacketEvents packets;
    @NotNull
    private final StatsService stats;
    private final UUID playerUuid;
    @NotNull
    private final ExecutorService executor;

    public ClientStatsSyncController(@NotNull Logger log, @NotNull BingoConfig config, @NotNull ClientPacketEvents packets, @NotNull StatsService stats, @NotNull IExecutors executors, @NotNull ISessionAccessor sessionAccessor, @NotNull IEventBus eventBus) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)packets, (String)"packets");
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        Intrinsics.checkNotNullParameter((Object)executors, (String)"executors");
        Intrinsics.checkNotNullParameter((Object)sessionAccessor, (String)"sessionAccessor");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        this.log = log;
        this.config = config;
        this.packets = packets;
        this.stats = stats;
        UUID uUID = sessionAccessor.getPlayerUuid();
        if (uUID == null) {
            uUID = UUID.fromString("00000000-0000-0000-0000-000000000000");
        }
        this.playerUuid = uUID;
        this.executor = executors.getIo();
        eventBus.register((IReturnEvent)this.packets.getStatsHashV1S2C(), arg_0 -> ClientStatsSyncController._init_$lambda$0(this, arg_0));
        eventBus.register((IReturnEvent)this.packets.getStatsIndexV1S2C(), arg_0 -> ClientStatsSyncController._init_$lambda$1(this, arg_0));
        eventBus.register((IReturnEvent)this.packets.getStatsGameV1S2C(), arg_0 -> ClientStatsSyncController._init_$lambda$2(this, arg_0));
    }

    private final Future<?> sendKnownIdsIfMismatch(StatsCheckPacket check) {
        return this.executor.submit(() -> ClientStatsSyncController.sendKnownIdsIfMismatch$lambda$0(this, check));
    }

    private final Future<?> checkForMissingIds(Set<UUID> gameIds) {
        return this.executor.submit(() -> ClientStatsSyncController.checkForMissingIds$lambda$0(this, gameIds));
    }

    private final Future<?> sendRequestedIds(Set<UUID> gameIds) {
        return this.executor.submit(() -> ClientStatsSyncController.sendRequestedIds$lambda$0(gameIds, this));
    }

    private final void insertReceivedGame(PlayerGameSummary game) {
        if (!Intrinsics.areEqual((Object)game.getPlayer().getMinecraftId(), (Object)this.playerUuid)) {
            this.log.error("[ClientStatsSyncController] Received game info is for playerId={}, which doesn't match my playerId={}...", (Object)game.getPlayer().getMinecraftId(), (Object)this.playerUuid);
            return;
        }
        this.stats.insertGame(game.getGame(), CollectionsKt.listOf((Object)game.getTeam()), CollectionsKt.listOf((Object)game.getPlayer()));
    }

    private static final void sendKnownIdsIfMismatch$lambda$0(ClientStatsSyncController this$0, StatsCheckPacket $check) {
        StatsService statsService = this$0.stats;
        UUID uUID = this$0.playerUuid;
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"playerUuid");
        String hash = statsService.fetchGamesByPlayerSha512(uUID);
        if (Intrinsics.areEqual((Object)hash, (Object)$check.getHashSha512())) {
            this$0.log.info("[ClientStatsSyncController] Hash matched! No sync required.");
            return;
        }
        this$0.log.info("[ClientStatsSyncController] Hash mismatch - starting sync...");
        this$0.packets.getStatsHashV1C2S().send(new StatsCheckPacket(hash));
        StatsService statsService2 = this$0.stats;
        UUID uUID2 = this$0.playerUuid;
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"playerUuid");
        for (List ids : StatsService.fetchGamesByPlayer$default(statsService2, uUID2, 0L, 2, null)) {
            StatsIndexPacket packet = new StatsIndexPacket(StatsIndexPacket.Action.BROADCAST, CollectionsKt.toSet((Iterable)ids));
            this$0.log.info("[ClientStatsSyncController] Broadcasting {} known gameIds to the server", (Object)ids.size());
            this$0.packets.getStatsIndexV1C2S().send(packet);
            try {
                Thread.sleep(Random.Default.nextLong(50L, 200L));
            }
            catch (InterruptedException e) {
                this$0.log.warn("[ClientStatsSyncController] broadcastKnownIds interrupted!");
                break;
            }
        }
    }

    private static final void checkForMissingIds$lambda$0(ClientStatsSyncController this$0, Set $gameIds) {
        StatsService statsService = this$0.stats;
        UUID uUID = this$0.playerUuid;
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"playerUuid");
        Set<UUID> missingIds = statsService.checkIfIdsExist(uUID, $gameIds);
        if (!((Collection)missingIds).isEmpty()) {
            this$0.log.info("[ClientStatsSyncController] Requesting {} missing gameIds from the server", (Object)missingIds.size());
            this$0.packets.getStatsIndexV1C2S().send(new StatsIndexPacket(StatsIndexPacket.Action.REQUEST, missingIds));
        }
    }

    private static final void sendRequestedIds$lambda$0(Set $gameIds, ClientStatsSyncController this$0) {
        for (UUID gameId : $gameIds) {
            StatsService statsService = this$0.stats;
            UUID uUID = this$0.playerUuid;
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"playerUuid");
            PlayerGameSummary gameSummary = statsService.findById(gameId, uUID);
            if (gameSummary == null) {
                this$0.log.error("[ClientStatsSyncController] Requested gameId={}, playerId={} does not exist in the database", (Object)gameId, (Object)this$0.playerUuid);
                continue;
            }
            this$0.log.info("[ClientStatsSyncController] Sending requested gameId={}", (Object)gameId);
            StatsGamePacket packet = new StatsGamePacket(gameSummary);
            this$0.packets.getStatsGameV1C2S().send(packet);
            try {
                Thread.sleep(Random.Default.nextLong(50L, 200L));
            }
            catch (InterruptedException e) {
                this$0.log.warn("[ClientStatsSyncController] sendRequestedIds interrupted!");
                break;
            }
        }
    }

    private static final Unit _init_$lambda$0(ClientStatsSyncController this$0, ClientPacket it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!this$0.config.getSyncStats()) {
            return Unit.INSTANCE;
        }
        this$0.sendKnownIdsIfMismatch((StatsCheckPacket)it.getPacket());
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(ClientStatsSyncController this$0, ClientPacket it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!this$0.config.getSyncStats()) {
            return Unit.INSTANCE;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[((StatsIndexPacket)it.getPacket()).getAction().ordinal()]) {
            case 1: {
                Future<?> future = this$0.checkForMissingIds(((StatsIndexPacket)it.getPacket()).getGames());
                break;
            }
            case 2: {
                Future<?> future = this$0.sendRequestedIds(((StatsIndexPacket)it.getPacket()).getGames());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(ClientStatsSyncController this$0, ClientPacket it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!this$0.config.getSyncStats()) {
            return Unit.INSTANCE;
        }
        this$0.insertReceivedGame(((StatsGamePacket)it.getPacket()).getGame());
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    @Environment(value=EnvType.CLIENT)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StatsIndexPacket.Action.values().length];
            try {
                nArray[StatsIndexPacket.Action.BROADCAST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StatsIndexPacket.Action.REQUEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

